/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.setting;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.base.SyncBLEViewModel;
import com.brytonsport.active.db.setting.entity.DeviceManagerEntity;
import com.brytonsport.active.repo.setting.DeviceRepository;
import com.brytonsport.active.repo.setting.FirmwareUpdateRepository;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.utils.SettingLanguageUtil;
import com.brytonsport.active.utils.Utils;
import javax.inject.Inject;

public class SettingGeneralSettingViewModel
extends SyncBLEViewModel {
    @Inject
    DeviceRepository deviceRepository;
    @Inject
    FirmwareUpdateRepository firmwareUpdateRepository;
    public boolean isAutoLap = true;
    public boolean isAutoPowerOff = true;
    public String language = "Nederlands";
    public String lapBy = "Distance";
    public String lapBy2;
    public float odoKm;
    public float odoMi;
    public String whenIdleAfter = "10 mins";

    @Inject
    public SettingGeneralSettingViewModel() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Utils.convertKM(10.0f));
        stringBuilder.append(" ");
        stringBuilder.append(Utils.getUnitByKM());
        this.lapBy2 = stringBuilder.toString();
        this.odoKm = 100.0f;
        this.odoMi = 62.0f;
    }

    @Override
    protected String getCustomDeviceLangMapKeyByValue(String string2) {
        return SettingLanguageUtil.getRider320LangKeyByServerStr(string2);
    }

    public void getDeviceFirmVer() {
        this.deviceRepository.getDeviceInfoFromDb();
    }

    public MutableLiveData<String> getDeviceFirmVerLiveData() {
        return this.deviceRepository.getDeviceFirmVerLiveData();
    }

    public String getOdoByUnit() {
        if ((Integer)ProfileUtil.getInstance().get("app_unit_id") == 0) {
            return String.valueOf(Utils.convertKM(this.odoKm));
        }
        return String.valueOf(Utils.convertKMByImperial(this.odoMi));
    }

    public void getSptLanguageList(String string2, String string3) {
        this.firmwareUpdateRepository.getSptLanguageListByModalAndVer(string2, string3);
    }

    public MutableLiveData<String> getSptLanguageListLiveData() {
        return this.firmwareUpdateRepository.getSptLanguageListLiveData();
    }

    public void getSptLanguagePack(String string2, String string3, String string4) {
        this.firmwareUpdateRepository.getSptLanguagePack(string2, string3, string4);
    }

    public MutableLiveData<FirmwareUpdateRepository.SptLanguagePack> getSptLanguagePackLiveData() {
        return this.firmwareUpdateRepository.getSptLanguagePackLiveData();
    }

    public LiveData<DeviceManagerEntity> loadDeviceIsChoiceAndConnected() {
        return this.deviceRepository.loadDeviceIsChoiceAndConnected();
    }

    public void setOdoValue() {
    }
}

