/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.setting;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Base64;
import android.util.Log;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.base.App;
import com.brytonsport.active.base.SyncBLEViewModel;
import com.brytonsport.active.db.setting.entity.DeviceManagerEntity;
import com.brytonsport.active.repo.BleRepository;
import com.brytonsport.active.repo.setting.DeviceRepository;
import com.brytonsport.active.utils.JsonUtil;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.utils.SettingLanguageUtil;
import com.brytonsport.active.utils.i18N;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.inject.Inject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SettingLanguageViewModel
extends SyncBLEViewModel {
    static final String TAG = "SettingLanguageViewModel";
    @Inject
    BleRepository bleRepository;
    @Inject
    DeviceRepository deviceRepository;
    public ArrayList<String> languages;
    public MutableLiveData<Integer> mFWDeviceLangPosted;
    public boolean mIsDeviceReboot = false;
    public MutableLiveData<Boolean> mIsPackageInfoUpdated = new MutableLiveData();
    private byte[] mLanguagePackData;
    public String mSelectedLanguage = "";

    @Inject
    public SettingLanguageViewModel() {
        this.mFWDeviceLangPosted = new MutableLiveData();
        this.languages = new ArrayList();
        SettingLanguageUtil.appLangMap = new HashMap<String, String>();
        SettingLanguageUtil.voiceLangMap = new HashMap<String, String>();
    }

    static /* synthetic */ byte[] access$002(SettingLanguageViewModel settingLanguageViewModel, byte[] byArray) {
        settingLanguageViewModel.mLanguagePackData = byArray;
        return byArray;
    }

    private void sendTmpLangFileToDevice() {
        if (new File("/data/data/com.brytonsport.active.debuglee/files/JPN.bft").exists()) {
            try {
                this.mLanguagePackData = Files.readAllBytes(Paths.get("/data/data/com.brytonsport.active.debuglee/files/JPN.bft", new String[0]));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            byte[] byArray = this.mLanguagePackData;
            if (byArray != null && byArray.length > 0) {
                this.bleRepository.postData(5, byArray);
            }
        }
    }

    private void setAppLanguage() {
        String string2 = (String)ProfileUtil.getInstance().get("setting_app_lang");
        if (string2.isEmpty()) {
            i18N.setLanguage(i18N.getCurrentLanguage());
        } else {
            i18N.setLanguage(string2);
        }
    }

    public void choiceAppLanguage(String string2) {
        if (SettingLanguageUtil.appLangMap != null) {
            ProfileUtil profileUtil = ProfileUtil.getInstance();
            string2 = string2.equals(i18N.get("Default")) ? "" : SettingLanguageUtil.appLangMap.get(string2);
            profileUtil.set("setting_app_lang", string2);
            this.setAppLanguage();
            App.initAppUnit();
        }
    }

    public void choiceDeviceLanguage(String string2) {
        if (SettingLanguageUtil.deviceLangMap != null) {
            String string3 = TAG;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("choiceDeviceLanguage: langKey -> ");
            stringBuilder.append(string2);
            stringBuilder.append(", \u4e0bCMD\u7684\u503c -> ");
            stringBuilder.append(SettingLanguageUtil.deviceLangMap.getMap().get(string2));
            Log.d((String)string3, (String)stringBuilder.toString());
        }
    }

    public void choiceLanguageItemFromPageType(String string2, String string3) {
        string2.hashCode();
        int n = string2.hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case 1233787845: {
                if (!string2.equals("voice_language")) break;
                n2 = 2;
                break;
            }
            case -384145631: {
                if (!string2.equals("device_language")) break;
                n2 = 1;
                break;
            }
            case -1816715338: {
                if (!string2.equals("app_language")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                this.choiceVoiceLanguage(string3);
                break;
            }
            case 1: {
                this.choiceDeviceLanguage(string3);
                break;
            }
            case 0: {
                this.choiceAppLanguage(string3);
            }
        }
    }

    public void choiceVoiceLanguage(String string2) {
        if (SettingLanguageUtil.voiceLangMap != null) {
            ProfileUtil.getInstance().set("setting_voice_lang_key", string2);
            ProfileUtil.getInstance().set("setting_voice_lang_id", SettingLanguageUtil.voiceLangMap.get(string2));
            this.setDevVoiceLang(string2);
        }
    }

    public void getAppLangList() {
        Object object;
        JSONArray jSONArray = new JSONArray();
        try {
            object = new JSONArray(JsonUtil.readJsonFile(0x7F0F0000));
            jSONArray = object;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        object = new ArrayList();
        SettingLanguageUtil.appLangMap.put(i18N.get("Default"), "default");
        object.add(i18N.get("Default"));
        for (int i = 0; i < jSONArray.length(); ++i) {
            try {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                object.add(jSONObject.getString("key"));
                SettingLanguageUtil.appLangMap.put(jSONObject.getString("key"), jSONObject.getString("id"));
                continue;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        this.languages.addAll((Collection<String>)object);
    }

    public void getSptGoogleLangList() {
        Object object;
        JSONArray jSONArray = new JSONArray();
        try {
            object = new JSONArray(JsonUtil.readJsonFile(2131689507));
            jSONArray = object;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        object = new ArrayList();
        for (int i = 0; i < jSONArray.length(); ++i) {
            try {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                object.add(jSONObject.getString("key"));
                SettingLanguageUtil.voiceLangMap.put(jSONObject.getString("key"), jSONObject.getString("id"));
                continue;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        this.languages.addAll((Collection<String>)object);
    }

    public LiveData<DeviceManagerEntity> loadDeviceIsChoiceAndConnected() {
        return this.deviceRepository.loadDeviceIsChoiceAndConnected();
    }

    public void loadLanguageListFromPageType(String string2, String string3) {
        string2.hashCode();
        int n = string2.hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case 1233787845: {
                if (!string2.equals("voice_language")) break;
                n2 = 2;
                break;
            }
            case -384145631: {
                if (!string2.equals("device_language")) break;
                n2 = 1;
                break;
            }
            case -1816715338: {
                if (!string2.equals("app_language")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                this.getSptGoogleLangList();
                break;
            }
            case 1: {
                this.languages.addAll(this.getDeviceLangListByModelName(string3));
                break;
            }
            case 0: {
                this.getAppLangList();
            }
        }
    }

    @Override
    protected IntentFilter makeGattUpdateIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.brytonsport.active.SERVICE_SETTING_COMMAND_RETURN");
        intentFilter.addAction("com.brytonsport.active.SERVICE_POST_DATA");
        return intentFilter;
    }

    @Override
    protected void onBLEReceive(Context context, Intent intent) {
        CharSequence charSequence = intent.getAction();
        if (charSequence != null && ((String)charSequence).equals("com.brytonsport.active.SERVICE_POST_DATA")) {
            int n = intent.getIntExtra("com.brytonsport.active.SERVICE_POST_FILE_TYPE", 0);
            String string2 = TAG;
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("onReceive post data ok, postDataContentType -> ");
            ((StringBuilder)charSequence).append(n);
            Log.d((String)string2, (String)((StringBuilder)charSequence).toString());
            if (n == 5) {
                this.mFWDeviceLangPosted.postValue(this.mLanguagePackData.length);
            } else {
                super.onBLEReceive(context, intent);
            }
        } else {
            super.onBLEReceive(context, intent);
        }
    }

    @Override
    protected void onPackageInfoUpdated(boolean bl) {
        this.mIsPackageInfoUpdated.postValue(bl);
    }

    public void post320DeviceLanguage(final String string2) {
        if (string2 == null) {
            return;
        }
        this.mIsLoading.setValue(true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                SettingLanguageViewModel.access$002(SettingLanguageViewModel.this, Base64.decode((String)string2, (int)0));
                SettingLanguageViewModel.this.bleRepository.postData(5, SettingLanguageViewModel.this.mLanguagePackData);
            }
        }).start();
    }

    public void setDevVoiceLang(String string2) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)"set.dev.voiceLang");
        jSONArray.put((Object)string2);
        this.bleRepository.passSettingCommand(jSONArray);
    }
}

