/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.vm.setting;

import android.util.Log;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.base.BaseViewModel;
import com.brytonsport.active.bleplugin.DeviceSupportFeature;
import com.brytonsport.active.db.setting.entity.DeviceManagerEntity;
import com.brytonsport.active.repo.BleRepository;
import com.brytonsport.active.repo.account.LoginRepository;
import com.brytonsport.active.repo.setting.DeviceRepository;
import com.brytonsport.active.ui.DeviceVo;
import com.brytonsport.active.utils.BleUtil;
import com.brytonsport.active.utils.FeatureUtil;
import com.brytonsport.active.vm.base.Device;
import com.brytonsport.active.vm.setting.SettingParingNewDeviceViewModel$$ExternalSyntheticLambda0;
import com.brytonsport.active.vm.setting.SettingParingNewDeviceViewModel$$ExternalSyntheticLambda1;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SettingParingNewDeviceViewModel
extends BaseViewModel {
    static final String TAG = "SettingParingNewDeviceViewModel";
    @Inject
    BleRepository bleRepository;
    public Device choiceDevice;
    public Device deviceInfo;
    @Inject
    DeviceRepository deviceRepository;
    public ArrayList<Device> devices;
    private MutableLiveData<Boolean> disconnectCurrentDeviceLiveData = new MutableLiveData();
    @Inject
    LoginRepository loginRepository;
    private Map<String, String> pairedDevices;
    public String selectDevUuid = "";

    @Inject
    public SettingParingNewDeviceViewModel() {
        this.devices = new ArrayList();
        this.choiceDevice = new Device();
        this.deviceInfo = new Device();
    }

    public void cancelChoiceAndUnBondDevice() {
        if (!this.choiceDevice.macAddress.isEmpty()) {
            if (FeatureUtil.isSptBleBinding(this.choiceDevice)) {
                this.bleRepository.unBondDevice(this.choiceDevice.macAddress);
            } else {
                this.bleRepository.disConnectDevice(this.choiceDevice.macAddress);
            }
        }
    }

    public void checkUuidFromServer(Device object) {
        Log.d((String)TAG, (String)"[Jeff] checkUuidFromServer: ");
        this.selectDevUuid = object = ((Device)object).uuid;
        this.loginRepository.checkUuid((String)object);
    }

    public void choiceDeviceToConnect(Device object) {
        object = new DeviceManagerEntity(((Device)object).macAddress, ((Device)object).deviceName);
        this.bleRepository.checkHasDeviceConnect((DeviceManagerEntity)object, true);
    }

    public void disconnectCurrentDevice(boolean bl) {
        Log.d((String)TAG, (String)"[Jeff]\u547c\u53eb disconnectCurrentDevice: ");
        new Thread(new SettingParingNewDeviceViewModel$$ExternalSyntheticLambda1(this, bl)).start();
    }

    public MutableLiveData<JSONObject> getCheckUuidHasOwnerLiveData() {
        return this.loginRepository.getCheckUuidHasOwnerLiveData();
    }

    public MutableLiveData<Boolean> getDisconnectCurrentDeviceLiveData() {
        return this.disconnectCurrentDeviceLiveData;
    }

    public void getFileList() {
        this.bleRepository.getFileList();
    }

    public MutableLiveData<AccountErrorVo> getLiveAccountErrorResponse() {
        return this.loginRepository.getLiveAccountErrorResponse();
    }

    public MutableLiveData<Boolean> getOverwriteUuidSuccessLiveData() {
        return this.loginRepository.getOverwriteUuidSuccessLiveData();
    }

    public MutableLiveData<Map<String, DeviceVo>> getPeripheralsMapLiveData() {
        return this.bleRepository.getPeripheralsMapLiveData();
    }

    public MutableLiveData<Device> getReadDeviceInfoResultLiveData() {
        return this.bleRepository.getReadDeviceInfoResultLiveData();
    }

    public void insertNewDeviceToDb(Device object) {
        object = new DeviceManagerEntity(((Device)object).macAddress, ((Device)object).deviceName, ((Device)object).uuid, ((Device)object).firmware, ((Device)object).capability, true, true, DeviceSupportFeature.LIVE_TRACKING, DeviceSupportFeature.GROUP_RIDE);
        this.deviceRepository.insert((DeviceManagerEntity)object);
    }

    public /* synthetic */ void lambda$disconnectCurrentDevice$1$com-brytonsport-active-vm-setting-SettingParingNewDeviceViewModel(boolean bl) {
        for (DeviceManagerEntity deviceManagerEntity : this.deviceRepository.loadDeviceManagerList()) {
            if (!deviceManagerEntity.isConnected()) continue;
            this.bleRepository.disConnectDevice(deviceManagerEntity.getMacAddress());
        }
        if (bl) {
            this.disconnectCurrentDeviceLiveData.postValue(true);
        }
    }

    public /* synthetic */ void lambda$startScan$0$com-brytonsport-active-vm-setting-SettingParingNewDeviceViewModel() {
        this.pairedDevices = new HashMap<String, String>();
        List<DeviceManagerEntity> list = this.deviceRepository.loadDeviceManagerList();
        for (DeviceManagerEntity deviceManagerEntity : list) {
            String string2 = TAG;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(deviceManagerEntity.getDevName());
            stringBuilder.append(" ");
            stringBuilder.append(deviceManagerEntity.getMacAddress());
            stringBuilder.append(" connect:");
            stringBuilder.append(deviceManagerEntity.isConnected());
            Log.d((String)string2, (String)stringBuilder.toString());
            this.pairedDevices.put(deviceManagerEntity.getMacAddress(), deviceManagerEntity.getDevName());
        }
        BleUtil.getInstance().setDevicesInDb(list);
        this.bleRepository.startScan();
    }

    public void newApp() {
        JSONArray jSONArray = new JSONArray();
        try {
            jSONArray.put(0, (Object)"set.new.app");
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.bleRepository.passSettingCommand(jSONArray);
    }

    public void overwriteUuidToServer() {
        Log.d((String)TAG, (String)"[Jeff] overwriteUuidToServer: ");
        this.loginRepository.overwriteUuid(this.selectDevUuid);
    }

    public void postData() {
        byte[] byArray = ByteBuffer.allocate(4).putInt(56).array();
        this.bleRepository.postData(1, byArray);
    }

    public void processDeviceInfo(String string2, JSONObject jSONObject) {
        this.bleRepository.processDeviceInfo(string2, jSONObject);
    }

    public void processScanResultMap(Map<String, DeviceVo> object) {
        this.devices = new ArrayList();
        object = object.entrySet().iterator();
        while (object.hasNext()) {
            DeviceVo deviceVo = (DeviceVo)((Map.Entry)object.next()).getValue();
            if (this.pairedDevices.containsKey(deviceVo.getAddress())) continue;
            Device device = new Device();
            device.deviceName = deviceVo.getName();
            device.macAddress = deviceVo.getAddress();
            this.devices.add(device);
        }
    }

    public void registerGattReceiver() {
        Log.d((String)TAG, (String)"registerGattReceiver: ");
        this.bleRepository.registerGattReceiver();
    }

    public void registerScanReceiver() {
        this.bleRepository.registerScanReceiver();
    }

    public void runConnectTask() {
        this.bleRepository.runConnectTask();
    }

    public void startScan() {
        new Thread(new SettingParingNewDeviceViewModel$$ExternalSyntheticLambda0(this)).start();
    }

    public void stopScan() {
        this.bleRepository.stopScan();
    }

    public void unregisterGattReceiver() {
        Log.d((String)TAG, (String)"unregisterGattReceiver: ");
        this.bleRepository.unregisterGattReceiver();
    }

    public void unregisterScanReceiver() {
        this.bleRepository.unregisterScanReceiver();
    }
}

