/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.disklrucache;

import android.os.Build;
import android.os.StrictMode;
import com.bumptech.glide.disklrucache.StrictLineReader;
import com.bumptech.glide.disklrucache.Util;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class DiskLruCache
implements Closeable {
    static final long ANY_SEQUENCE_NUMBER = -1L;
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    static final String JOURNAL_FILE = "journal";
    static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    static final String JOURNAL_FILE_TEMP = "journal.tmp";
    static final String MAGIC = "libcore.io.DiskLruCache";
    private static final String READ = "READ";
    private static final String REMOVE = "REMOVE";
    static final String VERSION_1 = "1";
    private final int appVersion;
    private final Callable<Void> cleanupCallable;
    private final File directory;
    final ThreadPoolExecutor executorService;
    private final File journalFile;
    private final File journalFileBackup;
    private final File journalFileTmp;
    private Writer journalWriter;
    private final LinkedHashMap<String, Entry> lruEntries = new LinkedHashMap(0, 0.75f, true);
    private long maxSize;
    private long nextSequenceNumber = 0L;
    private int redundantOpCount;
    private long size = 0L;
    private final int valueCount;

    private DiskLruCache(File file, int n, int n2, long l) {
        this.executorService = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DiskLruCacheThreadFactory());
        this.cleanupCallable = new Callable<Void>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Void call() throws Exception {
                DiskLruCache diskLruCache = DiskLruCache.this;
                synchronized (diskLruCache) {
                    if (DiskLruCache.this.journalWriter == null) {
                        return null;
                    }
                    DiskLruCache.this.trimToSize();
                    if (DiskLruCache.this.journalRebuildRequired()) {
                        DiskLruCache.this.rebuildJournal();
                        DiskLruCache.access$502(DiskLruCache.this, 0);
                    }
                    return null;
                }
            }
        };
        this.directory = file;
        this.appVersion = n;
        this.journalFile = new File(file, JOURNAL_FILE);
        this.journalFileTmp = new File(file, JOURNAL_FILE_TEMP);
        this.journalFileBackup = new File(file, JOURNAL_FILE_BACKUP);
        this.valueCount = n2;
        this.maxSize = l;
    }

    static /* synthetic */ int access$502(DiskLruCache diskLruCache, int n) {
        diskLruCache.redundantOpCount = n;
        return n;
    }

    private void checkNotClosed() {
        if (this.journalWriter != null) {
            return;
        }
        throw new IllegalStateException("cache is closed");
    }

    private static void closeWriter(Writer writer) throws IOException {
        if (Build.VERSION.SDK_INT < 26) {
            writer.close();
            return;
        }
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder(threadPolicy).permitUnbufferedIo().build());
        try {
            writer.close();
            return;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void completeEdit(Editor object, boolean bl) throws IOException {
        synchronized (this) {
            long l;
            void var2_2;
            int n;
            Object object2 = ((Editor)object).entry;
            if (((Entry)object2).currentEditor != object) {
                object = new IllegalStateException();
                throw object;
            }
            int n2 = n = 0;
            if (var2_2 != false) {
                n2 = n;
                if (!((Entry)object2).readable) {
                    int n3 = 0;
                    while (true) {
                        n2 = n;
                        if (n3 >= this.valueCount) break;
                        if (!((Editor)object).written[n3]) {
                            ((Editor)object).abort();
                            object = new StringBuilder();
                            ((StringBuilder)object).append("Newly created entry didn't create value for index ");
                            ((StringBuilder)object).append(n3);
                            object2 = new IllegalStateException(((StringBuilder)object).toString());
                            throw object2;
                        }
                        if (!((Entry)object2).getDirtyFile(n3).exists()) {
                            ((Editor)object).abort();
                            return;
                        }
                        ++n3;
                    }
                }
            }
            while (n2 < this.valueCount) {
                object = ((Entry)object2).getDirtyFile(n2);
                if (var2_2 != false) {
                    if (((File)object).exists()) {
                        File file = ((Entry)object2).getCleanFile(n2);
                        ((File)object).renameTo(file);
                        long l2 = ((Entry)object2).lengths[n2];
                        ((Entry)object2).lengths[n2] = l = file.length();
                        this.size = this.size - l2 + l;
                    }
                } else {
                    DiskLruCache.deleteIfExists((File)object);
                }
                ++n2;
            }
            ++this.redundantOpCount;
            Entry.access$802((Entry)object2, null);
            if ((((Entry)object2).readable | var2_2) != 0) {
                Entry.access$702((Entry)object2, true);
                this.journalWriter.append(CLEAN);
                this.journalWriter.append(' ');
                this.journalWriter.append(((Entry)object2).key);
                this.journalWriter.append(((Entry)object2).getLengths());
                this.journalWriter.append('\n');
                if (var2_2 != false) {
                    l = this.nextSequenceNumber;
                    this.nextSequenceNumber = 1L + l;
                    Entry.access$1302((Entry)object2, l);
                }
            } else {
                this.lruEntries.remove(((Entry)object2).key);
                this.journalWriter.append(REMOVE);
                this.journalWriter.append(' ');
                this.journalWriter.append(((Entry)object2).key);
                this.journalWriter.append('\n');
            }
            DiskLruCache.flushWriter(this.journalWriter);
            if (this.size > this.maxSize || this.journalRebuildRequired()) {
                this.executorService.submit(this.cleanupCallable);
            }
            return;
        }
    }

    private static void deleteIfExists(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Editor edit(String string2, long l) throws IOException {
        synchronized (this) {
            Editor editor;
            long l2;
            void var2_2;
            this.checkNotClosed();
            Entry entry = this.lruEntries.get(string2);
            if (var2_2 != -1L && (entry == null || (l2 = entry.sequenceNumber) != var2_2)) {
                return null;
            }
            if (entry == null) {
                entry = new Entry(string2);
                this.lruEntries.put(string2, entry);
            } else {
                editor = entry.currentEditor;
                if (editor != null) {
                    return null;
                }
            }
            editor = new Editor(entry);
            Entry.access$802(entry, editor);
            this.journalWriter.append(DIRTY);
            this.journalWriter.append(' ');
            this.journalWriter.append(string2);
            this.journalWriter.append('\n');
            DiskLruCache.flushWriter(this.journalWriter);
            return editor;
        }
    }

    private static void flushWriter(Writer writer) throws IOException {
        if (Build.VERSION.SDK_INT < 26) {
            writer.flush();
            return;
        }
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder(threadPolicy).permitUnbufferedIo().build());
        try {
            writer.flush();
            return;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    private static String inputStreamToString(InputStream inputStream) throws IOException {
        return Util.readFully(new InputStreamReader(inputStream, Util.UTF_8));
    }

    private boolean journalRebuildRequired() {
        int n = this.redundantOpCount;
        boolean bl = n >= 2000 && n >= this.lruEntries.size();
        return bl;
    }

    public static DiskLruCache open(File object, int n, int n2, long l) throws IOException {
        if (l > 0L) {
            if (n2 > 0) {
                Object object2 = new File((File)object, JOURNAL_FILE_BACKUP);
                if (((File)object2).exists()) {
                    File file = new File((File)object, JOURNAL_FILE);
                    if (file.exists()) {
                        ((File)object2).delete();
                    } else {
                        DiskLruCache.renameTo((File)object2, file, false);
                    }
                }
                object2 = new DiskLruCache((File)object, n, n2, l);
                if (((DiskLruCache)object2).journalFile.exists()) {
                    try {
                        super.readJournal();
                        super.processJournal();
                        return object2;
                    }
                    catch (IOException iOException) {
                        PrintStream printStream = System.out;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("DiskLruCache ");
                        stringBuilder.append(object);
                        stringBuilder.append(" is corrupt: ");
                        stringBuilder.append(iOException.getMessage());
                        stringBuilder.append(", removing");
                        printStream.println(stringBuilder.toString());
                        ((DiskLruCache)object2).delete();
                    }
                }
                ((File)object).mkdirs();
                object = new DiskLruCache((File)object, n, n2, l);
                super.rebuildJournal();
                return object;
            }
            throw new IllegalArgumentException("valueCount <= 0");
        }
        throw new IllegalArgumentException("maxSize <= 0");
    }

    private void processJournal() throws IOException {
        DiskLruCache.deleteIfExists(this.journalFileTmp);
        Iterator<Entry> iterator = this.lruEntries.values().iterator();
        while (iterator.hasNext()) {
            int n;
            Entry entry = iterator.next();
            Editor editor = entry.currentEditor;
            int n2 = 0;
            if (editor == null) {
                for (n = 0; n < this.valueCount; ++n) {
                    this.size += entry.lengths[n];
                }
                continue;
            }
            Entry.access$802(entry, null);
            for (n = n2; n < this.valueCount; ++n) {
                DiskLruCache.deleteIfExists(entry.getCleanFile(n));
                DiskLruCache.deleteIfExists(entry.getDirtyFile(n));
            }
            iterator.remove();
        }
    }

    /*
     * Loose catch block
     */
    private void readJournal() throws IOException {
        String string2;
        Object object;
        Object object2;
        String string3;
        Object object3;
        StrictLineReader strictLineReader;
        block10: {
            boolean bl;
            strictLineReader = new StrictLineReader(new FileInputStream(this.journalFile), Util.US_ASCII);
            object3 = strictLineReader.readLine();
            string3 = strictLineReader.readLine();
            object2 = strictLineReader.readLine();
            object = strictLineReader.readLine();
            string2 = strictLineReader.readLine();
            if (!MAGIC.equals(object3) || !VERSION_1.equals(string3) || !Integer.toString(this.appVersion).equals(object2) || !Integer.toString(this.valueCount).equals(object) || !(bl = "".equals(string2))) break block10;
            int n = 0;
            while (true) {
                try {
                    this.readJournalLine(strictLineReader.readLine());
                    ++n;
                }
                catch (EOFException eOFException) {
                    this.redundantOpCount = n - this.lruEntries.size();
                    if (strictLineReader.hasUnterminatedLine()) {
                        this.rebuildJournal();
                    } else {
                        object = new FileOutputStream(this.journalFile, true);
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)object, Util.US_ASCII);
                        this.journalWriter = object3 = new BufferedWriter(outputStreamWriter);
                    }
                    return;
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("unexpected journal header: [");
        stringBuilder.append((String)object3);
        stringBuilder.append(", ");
        stringBuilder.append(string3);
        stringBuilder.append(", ");
        stringBuilder.append((String)object);
        stringBuilder.append(", ");
        stringBuilder.append(string2);
        stringBuilder.append("]");
        object2 = new IOException(stringBuilder.toString());
        throw object2;
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        finally {
            Util.closeQuietly(strictLineReader);
        }
    }

    private void readJournalLine(String stringArray) throws IOException {
        block9: {
            CharSequence charSequence;
            block13: {
                block11: {
                    int n;
                    int n2;
                    block12: {
                        Object object;
                        block10: {
                            n2 = stringArray.indexOf(32);
                            if (n2 == -1) break block9;
                            int n3 = n2 + 1;
                            n = stringArray.indexOf(32, n3);
                            if (n == -1) {
                                object = stringArray.substring(n3);
                                charSequence = object;
                                if (n2 == 6) {
                                    charSequence = object;
                                    if (stringArray.startsWith(REMOVE)) {
                                        this.lruEntries.remove(object);
                                        return;
                                    }
                                }
                            } else {
                                charSequence = stringArray.substring(n3, n);
                            }
                            Entry entry = this.lruEntries.get(charSequence);
                            object = entry;
                            if (entry == null) {
                                object = new Entry((String)charSequence);
                                this.lruEntries.put((String)charSequence, (Entry)object);
                            }
                            if (n == -1 || n2 != 5 || !stringArray.startsWith(CLEAN)) break block10;
                            stringArray = stringArray.substring(n + 1).split(" ");
                            Entry.access$702((Entry)object, true);
                            Entry.access$802((Entry)object, null);
                            ((Entry)object).setLengths(stringArray);
                            break block11;
                        }
                        if (n != -1 || n2 != 5 || !stringArray.startsWith(DIRTY)) break block12;
                        Entry.access$802((Entry)object, new Editor((Entry)object));
                        break block11;
                    }
                    if (n != -1 || n2 != 4 || !stringArray.startsWith(READ)) break block13;
                }
                return;
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("unexpected journal line: ");
            ((StringBuilder)charSequence).append((String)stringArray);
            throw new IOException(((StringBuilder)charSequence).toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("unexpected journal line: ");
        stringBuilder.append((String)stringArray);
        throw new IOException(stringBuilder.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rebuildJournal() throws IOException {
        synchronized (this) {
            Object object;
            Writer writer;
            block9: {
                writer = this.journalWriter;
                if (writer != null) {
                    DiskLruCache.closeWriter(writer);
                }
                object = new FileOutputStream(this.journalFileTmp);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)object, Util.US_ASCII);
                writer = new BufferedWriter(outputStreamWriter);
                writer.write(MAGIC);
                writer.write("\n");
                writer.write(VERSION_1);
                writer.write("\n");
                writer.write(Integer.toString(this.appVersion));
                writer.write("\n");
                writer.write(Integer.toString(this.valueCount));
                writer.write("\n");
                writer.write("\n");
                for (Entry entry : this.lruEntries.values()) {
                    StringBuilder stringBuilder;
                    if (entry.currentEditor != null) {
                        stringBuilder = new StringBuilder();
                        stringBuilder.append("DIRTY ");
                        stringBuilder.append(entry.key);
                        stringBuilder.append('\n');
                        writer.write(stringBuilder.toString());
                        continue;
                    }
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("CLEAN ");
                    stringBuilder.append(entry.key);
                    stringBuilder.append(entry.getLengths());
                    stringBuilder.append('\n');
                    writer.write(stringBuilder.toString());
                }
                if (!this.journalFile.exists()) break block9;
                DiskLruCache.renameTo(this.journalFile, this.journalFileBackup, true);
            }
            DiskLruCache.renameTo(this.journalFileTmp, this.journalFile, false);
            this.journalFileBackup.delete();
            object = new FileOutputStream(this.journalFile, true);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)object, Util.US_ASCII);
            this.journalWriter = writer = new BufferedWriter(outputStreamWriter);
            return;
            finally {
                DiskLruCache.closeWriter(writer);
            }
        }
    }

    private static void renameTo(File file, File file2, boolean bl) throws IOException {
        if (bl) {
            DiskLruCache.deleteIfExists(file2);
        }
        if (file.renameTo(file2)) {
            return;
        }
        throw new IOException();
    }

    private void trimToSize() throws IOException {
        while (this.size > this.maxSize) {
            this.remove(this.lruEntries.entrySet().iterator().next().getKey());
        }
    }

    @Override
    public void close() throws IOException {
        synchronized (this) {
            Object object;
            block5: {
                object = this.journalWriter;
                if (object != null) break block5;
                return;
            }
            object = new ArrayList(this.lruEntries.values());
            Iterator<Entry> iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (((Entry)object).currentEditor == null) continue;
                ((Entry)object).currentEditor.abort();
            }
            this.trimToSize();
            DiskLruCache.closeWriter(this.journalWriter);
            this.journalWriter = null;
            return;
        }
    }

    public void delete() throws IOException {
        this.close();
        Util.deleteContents(this.directory);
    }

    public Editor edit(String string2) throws IOException {
        return this.edit(string2, -1L);
    }

    public void flush() throws IOException {
        synchronized (this) {
            this.checkNotClosed();
            this.trimToSize();
            DiskLruCache.flushWriter(this.journalWriter);
            return;
        }
    }

    public Value get(String object) throws IOException {
        synchronized (this) {
            boolean bl;
            Entry entry;
            block10: {
                block9: {
                    this.checkNotClosed();
                    entry = this.lruEntries.get(object);
                    if (entry != null) break block9;
                    return null;
                }
                bl = entry.readable;
                if (bl) break block10;
                return null;
            }
            File[] fileArray = entry.cleanFiles;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                bl = fileArray[i].exists();
                if (bl) continue;
                return null;
            }
            ++this.redundantOpCount;
            this.journalWriter.append(READ);
            this.journalWriter.append(' ');
            this.journalWriter.append((CharSequence)object);
            this.journalWriter.append('\n');
            if (this.journalRebuildRequired()) {
                this.executorService.submit(this.cleanupCallable);
            }
            object = new Value((String)object, entry.sequenceNumber, entry.cleanFiles, entry.lengths);
            return object;
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    public long getMaxSize() {
        synchronized (this) {
            long l = this.maxSize;
            return l;
        }
    }

    public boolean isClosed() {
        synchronized (this) {
            Writer writer = this.journalWriter;
            boolean bl = writer == null;
            return bl;
        }
    }

    public boolean remove(String charSequence) throws IOException {
        synchronized (this) {
            block8: {
                this.checkNotClosed();
                Object object = this.lruEntries.get(charSequence);
                if (object == null) break block8;
                if (((Entry)object).currentEditor != null) break block8;
                for (int i = 0; i < this.valueCount; ++i) {
                    File file = ((Entry)object).getCleanFile(i);
                    if (file.exists() && !file.delete()) {
                        charSequence = new StringBuilder();
                        ((StringBuilder)charSequence).append("failed to delete ");
                        ((StringBuilder)charSequence).append(file);
                        object = new IOException(((StringBuilder)charSequence).toString());
                        throw object;
                    }
                    this.size -= ((Entry)object).lengths[i];
                    ((Entry)object).lengths[i] = 0L;
                }
                ++this.redundantOpCount;
                this.journalWriter.append(REMOVE);
                this.journalWriter.append(' ');
                this.journalWriter.append(charSequence);
                this.journalWriter.append('\n');
                this.lruEntries.remove(charSequence);
                if (this.journalRebuildRequired()) {
                    this.executorService.submit(this.cleanupCallable);
                }
                return true;
            }
            return false;
        }
    }

    public void setMaxSize(long l) {
        synchronized (this) {
            this.maxSize = l;
            this.executorService.submit(this.cleanupCallable);
            return;
        }
    }

    public long size() {
        synchronized (this) {
            long l = this.size;
            return l;
        }
    }

    private static final class DiskLruCacheThreadFactory
    implements ThreadFactory {
        private DiskLruCacheThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            synchronized (this) {
                Thread thread = new Thread(runnable, "glide-disk-lru-cache-thread");
                thread.setPriority(1);
                return thread;
            }
        }
    }

    public final class Editor {
        private boolean committed;
        private final Entry entry;
        private final boolean[] written;

        private Editor(Entry entry) {
            this.entry = entry;
            DiskLruCache.this = entry.readable ? null : (Object)new boolean[((DiskLruCache)DiskLruCache.this).valueCount];
            this.written = (boolean[])DiskLruCache.this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private InputStream newInputStream(int n) throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.entry.currentEditor != this) {
                    IllegalStateException illegalStateException = new IllegalStateException();
                    throw illegalStateException;
                }
                if (!this.entry.readable) {
                    return null;
                }
                try {
                    return new FileInputStream(this.entry.getCleanFile(n));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
        }

        public void abort() throws IOException {
            DiskLruCache.this.completeEdit(this, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void abortUnlessCommitted() {
            if (this.committed) return;
            try {
                this.abort();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }

        public void commit() throws IOException {
            DiskLruCache.this.completeEdit(this, true);
            this.committed = true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public File getFile(int n) throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.entry.currentEditor != this) {
                    IllegalStateException illegalStateException = new IllegalStateException();
                    throw illegalStateException;
                }
                if (!this.entry.readable) {
                    this.written[n] = true;
                }
                File file = this.entry.getDirtyFile(n);
                if (!DiskLruCache.this.directory.exists()) {
                    DiskLruCache.this.directory.mkdirs();
                }
                return file;
            }
        }

        public String getString(int n) throws IOException {
            Object object = this.newInputStream(n);
            object = object != null ? DiskLruCache.inputStreamToString((InputStream)object) : null;
            return object;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void set(int n, String string2) throws IOException {
            void var2_5;
            OutputStreamWriter outputStreamWriter;
            block4: {
                OutputStreamWriter outputStreamWriter2;
                outputStreamWriter = null;
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(this.getFile(n));
                    outputStreamWriter2 = new OutputStreamWriter((OutputStream)fileOutputStream, Util.UTF_8);
                }
                catch (Throwable throwable) {
                    // empty catch block
                    break block4;
                }
                try {
                    outputStreamWriter2.write(string2);
                }
                catch (Throwable throwable) {
                    outputStreamWriter = outputStreamWriter2;
                    break block4;
                }
                Util.closeQuietly(outputStreamWriter2);
                return;
            }
            Util.closeQuietly(outputStreamWriter);
            throw var2_5;
        }
    }

    private final class Entry {
        File[] cleanFiles;
        private Editor currentEditor;
        File[] dirtyFiles;
        private final String key;
        private final long[] lengths;
        private boolean readable;
        private long sequenceNumber;

        private Entry(String charSequence) {
            this.key = charSequence;
            this.lengths = new long[DiskLruCache.this.valueCount];
            this.cleanFiles = new File[DiskLruCache.this.valueCount];
            this.dirtyFiles = new File[DiskLruCache.this.valueCount];
            charSequence = new StringBuilder((String)charSequence);
            ((StringBuilder)charSequence).append('.');
            int n = ((StringBuilder)charSequence).length();
            for (int i = 0; i < DiskLruCache.this.valueCount; ++i) {
                ((StringBuilder)charSequence).append(i);
                this.cleanFiles[i] = new File(DiskLruCache.this.directory, ((StringBuilder)charSequence).toString());
                ((StringBuilder)charSequence).append(".tmp");
                this.dirtyFiles[i] = new File(DiskLruCache.this.directory, ((StringBuilder)charSequence).toString());
                ((StringBuilder)charSequence).setLength(n);
            }
        }

        static /* synthetic */ long access$1302(Entry entry, long l) {
            entry.sequenceNumber = l;
            return l;
        }

        static /* synthetic */ boolean access$702(Entry entry, boolean bl) {
            entry.readable = bl;
            return bl;
        }

        static /* synthetic */ Editor access$802(Entry entry, Editor editor) {
            entry.currentEditor = editor;
            return editor;
        }

        private IOException invalidLengths(String[] stringArray) throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("unexpected journal line: ");
            stringBuilder.append(Arrays.toString(stringArray));
            throw new IOException(stringBuilder.toString());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void setLengths(String[] stringArray) throws IOException {
            if (stringArray.length != DiskLruCache.this.valueCount) {
                throw this.invalidLengths(stringArray);
            }
            int n = 0;
            try {
                while (true) {
                    if (n >= stringArray.length) {
                        return;
                    }
                    this.lengths[n] = Long.parseLong(stringArray[n]);
                    ++n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidLengths(stringArray);
            }
        }

        public File getCleanFile(int n) {
            return this.cleanFiles[n];
        }

        public File getDirtyFile(int n) {
            return this.dirtyFiles[n];
        }

        public String getLengths() throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            for (long l : this.lengths) {
                stringBuilder.append(' ');
                stringBuilder.append(l);
            }
            return stringBuilder.toString();
        }
    }

    public final class Value {
        private final File[] files;
        private final String key;
        private final long[] lengths;
        private final long sequenceNumber;

        private Value(String string2, long l, File[] fileArray, long[] lArray) {
            this.key = string2;
            this.sequenceNumber = l;
            this.files = fileArray;
            this.lengths = lArray;
        }

        public Editor edit() throws IOException {
            return DiskLruCache.this.edit(this.key, this.sequenceNumber);
        }

        public File getFile(int n) {
            return this.files[n];
        }

        public long getLength(int n) {
            return this.lengths[n];
        }

        public String getString(int n) throws IOException {
            return DiskLruCache.inputStreamToString(new FileInputStream(this.files[n]));
        }
    }
}

