/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.disklrucache;

import com.bumptech.glide.disklrucache.Util;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

class StrictLineReader
implements Closeable {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private byte[] buf;
    private final Charset charset;
    private int end;
    private final InputStream in;
    private int pos;

    public StrictLineReader(InputStream inputStream, int n, Charset charset) {
        if (inputStream != null && charset != null) {
            if (n >= 0) {
                if (charset.equals(Util.US_ASCII)) {
                    this.in = inputStream;
                    this.charset = charset;
                    this.buf = new byte[n];
                    return;
                }
                throw new IllegalArgumentException("Unsupported encoding");
            }
            throw new IllegalArgumentException("capacity <= 0");
        }
        throw null;
    }

    public StrictLineReader(InputStream inputStream, Charset charset) {
        this(inputStream, 8192, charset);
    }

    private void fillBuf() throws IOException {
        InputStream inputStream = this.in;
        byte[] byArray = this.buf;
        int n = inputStream.read(byArray, 0, byArray.length);
        if (n != -1) {
            this.pos = 0;
            this.end = n;
            return;
        }
        throw new EOFException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            if (this.buf != null) {
                this.buf = null;
                this.in.close();
            }
            return;
        }
    }

    public boolean hasUnterminatedLine() {
        boolean bl = this.end == -1;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readLine() throws IOException {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            byte[] byArray;
            int n;
            if (this.buf == null) {
                IOException iOException = new IOException("LineReader is closed");
                throw iOException;
            }
            if (this.pos >= this.end) {
                this.fillBuf();
            }
            for (n = this.pos; n != this.end; ++n) {
                int n2;
                byArray = this.buf;
                if (byArray[n] != 10) continue;
                int n3 = this.pos;
                if (n == n3 || byArray[n2 = n - 1] != 13) {
                    n2 = n;
                }
                String string2 = new String(byArray, n3, n2 - n3, this.charset.name());
                this.pos = n + 1;
                return string2;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.end - this.pos + 80){

                @Override
                public String toString() {
                    int n = this.count > 0 && this.buf[this.count - 1] == 13 ? this.count - 1 : this.count;
                    try {
                        String string2 = new String(this.buf, 0, n, StrictLineReader.this.charset.name());
                        return string2;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new AssertionError((Object)unsupportedEncodingException);
                    }
                }
            };
            block8: while (true) {
                byArray = this.buf;
                n = this.pos;
                byteArrayOutputStream.write(byArray, n, this.end - n);
                this.end = -1;
                this.fillBuf();
                n = this.pos;
                while (true) {
                    if (n == this.end) continue block8;
                    byArray = this.buf;
                    if (byArray[n] == 10) {
                        int n4 = this.pos;
                        if (n != n4) {
                            byteArrayOutputStream.write(byArray, n4, n - n4);
                        }
                        this.pos = n + 1;
                        return byteArrayOutputStream.toString();
                    }
                    ++n;
                }
                break;
            }
        }
    }
}

