/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.gifdecoder;

import android.graphics.Bitmap;
import android.util.Log;
import com.bumptech.glide.gifdecoder.GifDecoder;
import com.bumptech.glide.gifdecoder.GifFrame;
import com.bumptech.glide.gifdecoder.GifHeader;
import com.bumptech.glide.gifdecoder.GifHeaderParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Iterator;

public class StandardGifDecoder
implements GifDecoder {
    private static final int BYTES_PER_INTEGER = 4;
    private static final int COLOR_TRANSPARENT_BLACK = 0;
    private static final int INITIAL_FRAME_POINTER = -1;
    private static final int MASK_INT_LOWEST_BYTE = 255;
    private static final int MAX_STACK_SIZE = 4096;
    private static final int NULL_CODE = -1;
    private static final String TAG = "StandardGifDecoder";
    private int[] act;
    private Bitmap.Config bitmapConfig;
    private final GifDecoder.BitmapProvider bitmapProvider;
    private byte[] block;
    private int downsampledHeight;
    private int downsampledWidth;
    private int framePointer;
    private GifHeader header;
    private Boolean isFirstFrameTransparent;
    private byte[] mainPixels;
    private int[] mainScratch;
    private GifHeaderParser parser;
    private final int[] pct = new int[256];
    private byte[] pixelStack;
    private short[] prefix;
    private Bitmap previousImage;
    private ByteBuffer rawData;
    private int sampleSize;
    private boolean savePrevious;
    private int status;
    private byte[] suffix;

    public StandardGifDecoder(GifDecoder.BitmapProvider bitmapProvider) {
        this.bitmapConfig = Bitmap.Config.ARGB_8888;
        this.bitmapProvider = bitmapProvider;
        this.header = new GifHeader();
    }

    public StandardGifDecoder(GifDecoder.BitmapProvider bitmapProvider, GifHeader gifHeader, ByteBuffer byteBuffer) {
        this(bitmapProvider, gifHeader, byteBuffer, 1);
    }

    public StandardGifDecoder(GifDecoder.BitmapProvider bitmapProvider, GifHeader gifHeader, ByteBuffer byteBuffer, int n) {
        this(bitmapProvider);
        this.setData(gifHeader, byteBuffer, n);
    }

    private int averageColorsNear(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        byte[] byArray;
        int n9;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        for (n9 = n; n9 < this.sampleSize + n && n9 < (byArray = this.mainPixels).length && n9 < n2; ++n9) {
            n8 = byArray[n9];
            int n15 = this.act[n8 & 0xFF];
            n7 = n10;
            n6 = n11;
            n5 = n12;
            n4 = n13;
            n8 = n14;
            if (n15 != 0) {
                n7 = n10 + (n15 >> 24 & 0xFF);
                n6 = n11 + (n15 >> 16 & 0xFF);
                n5 = n12 + (n15 >> 8 & 0xFF);
                n4 = n13 + (n15 & 0xFF);
                n8 = n14 + 1;
            }
            n10 = n7;
            n11 = n6;
            n12 = n5;
            n13 = n4;
            n14 = n8;
        }
        n9 = n11;
        n4 = n10;
        for (n = n6 = n + n3; n < this.sampleSize + n6 && n < (byArray = this.mainPixels).length && n < n2; ++n) {
            n3 = byArray[n];
            n7 = this.act[n3 & 0xFF];
            n5 = n4;
            n8 = n9;
            n10 = n12;
            n11 = n13;
            n3 = n14;
            if (n7 != 0) {
                n5 = n4 + (n7 >> 24 & 0xFF);
                n8 = n9 + (n7 >> 16 & 0xFF);
                n10 = n12 + (n7 >> 8 & 0xFF);
                n11 = n13 + (n7 & 0xFF);
                n3 = n14 + 1;
            }
            n4 = n5;
            n9 = n8;
            n12 = n10;
            n13 = n11;
            n14 = n3;
        }
        if (n14 == 0) {
            return 0;
        }
        return n4 / n14 << 24 | n9 / n14 << 16 | n12 / n14 << 8 | n13 / n14;
    }

    private void copyCopyIntoScratchRobust(GifFrame gifFrame) {
        int[] nArray = this.mainScratch;
        int n = gifFrame.ih / this.sampleSize;
        int n2 = gifFrame.iy / this.sampleSize;
        int n3 = gifFrame.iw / this.sampleSize;
        int n4 = gifFrame.ix;
        int n5 = this.sampleSize;
        int n6 = n4 / n5;
        n4 = this.framePointer;
        Boolean bl = true;
        boolean bl2 = n4 == 0;
        int n7 = this.downsampledWidth;
        int n8 = this.downsampledHeight;
        byte[] byArray = this.mainPixels;
        int[] nArray2 = this.act;
        Boolean bl3 = this.isFirstFrameTransparent;
        int n9 = 8;
        int n10 = 0;
        n4 = 1;
        for (int i = 0; i < n; ++i) {
            Boolean bl4;
            int n11;
            int n12;
            block26: {
                block25: {
                    int n13;
                    if (gifFrame.interlace) {
                        if (n10 >= n) {
                            if (++n4 != 2) {
                                if (n4 != 3) {
                                    if (n4 == 4) {
                                        n10 = 1;
                                        n9 = 2;
                                    }
                                } else {
                                    n10 = 2;
                                    n9 = 4;
                                }
                            } else {
                                n10 = 4;
                            }
                        }
                        n12 = n10 + n9;
                        n13 = n10;
                        n11 = n4;
                    } else {
                        n13 = i;
                        n11 = n4;
                        n12 = n10;
                    }
                    n10 = n13 + n2;
                    n4 = n5 == 1 ? 1 : 0;
                    if (n10 < n8) {
                        n13 = n10 * n7;
                        int n14 = n13 + n6;
                        n10 = n14 + n3;
                        int n15 = n13 + n7;
                        n13 = n10;
                        if (n15 < n10) {
                            n13 = n15;
                        }
                        n15 = i * n5 * gifFrame.iw;
                        if (n4 != 0) {
                            n10 = n14;
                            while (true) {
                                n4 = n2;
                                bl4 = bl3;
                                if (n10 < n13) {
                                    n4 = nArray2[byArray[n15] & 0xFF];
                                    if (n4 != 0) {
                                        nArray[n10] = n4;
                                        bl4 = bl3;
                                    } else {
                                        bl4 = bl3;
                                        if (bl2) {
                                            bl4 = bl3;
                                            if (bl3 == null) {
                                                bl4 = bl;
                                            }
                                        }
                                    }
                                    n15 += n5;
                                    ++n10;
                                    bl3 = bl4;
                                    continue;
                                }
                                break block25;
                                break;
                            }
                        }
                        int n16 = n2;
                        n10 = n14;
                        n4 = n15;
                        n2 = n3;
                        n3 = n10;
                        while (true) {
                            int n17 = n4;
                            n10 = n16;
                            bl4 = bl3;
                            n4 = n2;
                            if (n3 < n13) {
                                n4 = this.averageColorsNear(n17, (n13 - n14) * n5 + n15, gifFrame.iw);
                                if (n4 != 0) {
                                    nArray[n3] = n4;
                                    bl4 = bl3;
                                } else {
                                    bl4 = bl3;
                                    if (bl2) {
                                        bl4 = bl3;
                                        if (bl3 == null) {
                                            bl4 = bl;
                                        }
                                    }
                                }
                                n4 = n17 + n5;
                                ++n3;
                                bl3 = bl4;
                                continue;
                            }
                            break block26;
                            break;
                        }
                    }
                    bl4 = bl3;
                    n4 = n2;
                }
                n10 = n4;
                n4 = n3;
            }
            bl3 = bl4;
            n2 = n10;
            n10 = n12;
            n3 = n4;
            n4 = n11;
        }
        if (this.isFirstFrameTransparent == null) {
            boolean bl5 = bl3 == null ? false : bl3;
            this.isFirstFrameTransparent = bl5;
        }
    }

    private void copyIntoScratchFast(GifFrame object) {
        Object object2 = object;
        int[] nArray = this.mainScratch;
        int n = ((GifFrame)object2).ih;
        int n2 = ((GifFrame)object2).iy;
        int n3 = ((GifFrame)object2).iw;
        int n4 = ((GifFrame)object2).ix;
        boolean bl = this.framePointer == 0;
        int n5 = this.downsampledWidth;
        object2 = this.mainPixels;
        int[] nArray2 = this.act;
        int n6 = -1;
        for (int i = 0; i < n; ++i) {
            int n7 = (i + n2) * n5;
            int n8 = n7 + n4;
            int n9 = n8 + n3;
            Object object3 = n7 + n5;
            n7 = n9;
            if (object3 < n9) {
                n7 = object3;
            }
            n9 = ((GifFrame)object).iw * i;
            while (n8 < n7) {
                Object object4 = object2[n9];
                int n10 = object4 & 0xFF;
                object3 = n6;
                if (n10 != n6) {
                    object3 = nArray2[n10];
                    if (object3 != 0) {
                        nArray[n8] = object3;
                        object3 = n6;
                    } else {
                        object3 = object4;
                    }
                }
                ++n9;
                ++n8;
                n6 = object3;
            }
        }
        object = this.isFirstFrameTransparent;
        boolean bl2 = object != null && ((Boolean)object).booleanValue() || this.isFirstFrameTransparent == null && bl && n6 != -1;
        this.isFirstFrameTransparent = bl2;
    }

    private void decodeBitmapData(GifFrame object) {
        int n;
        int n2;
        Object object2 = this;
        if (object != null) {
            ((StandardGifDecoder)object2).rawData.position(((GifFrame)object).bufferFrameStart);
        }
        if (object == null) {
            n2 = ((StandardGifDecoder)object2).header.width * ((StandardGifDecoder)object2).header.height;
        } else {
            n = ((GifFrame)object).iw;
            n2 = ((GifFrame)object).ih * n;
        }
        object = ((StandardGifDecoder)object2).mainPixels;
        if (object == null || ((Object)object).length < n2) {
            ((StandardGifDecoder)object2).mainPixels = ((StandardGifDecoder)object2).bitmapProvider.obtainByteArray(n2);
        }
        byte[] byArray = ((StandardGifDecoder)object2).mainPixels;
        if (((StandardGifDecoder)object2).prefix == null) {
            ((StandardGifDecoder)object2).prefix = new short[4096];
        }
        short[] sArray = ((StandardGifDecoder)object2).prefix;
        if (((StandardGifDecoder)object2).suffix == null) {
            ((StandardGifDecoder)object2).suffix = new byte[4096];
        }
        byte[] byArray2 = ((StandardGifDecoder)object2).suffix;
        if (((StandardGifDecoder)object2).pixelStack == null) {
            ((StandardGifDecoder)object2).pixelStack = new byte[4097];
        }
        object = ((StandardGifDecoder)object2).pixelStack;
        n = this.readByte();
        int n3 = 1 << n;
        int n4 = n3 + 2;
        int n5 = n + 1;
        int n6 = (1 << n5) - 1;
        int n7 = 0;
        for (n = 0; n < n3; ++n) {
            sArray[n] = (short)0;
            byArray2[n] = (byte)n;
        }
        object2 = ((StandardGifDecoder)object2).block;
        n = n5;
        int n8 = n4;
        int n9 = n6;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = -1;
        int n16 = 0;
        int n17 = 0;
        block1: while (n7 < n2) {
            int n18;
            int n19 = n10;
            if (n10 == 0) {
                n19 = this.readBlock();
                if (n19 <= 0) {
                    this.status = 3;
                    break;
                }
                n11 = 0;
            }
            n13 += (object2[n11] & 0xFF) << n12;
            int n20 = n11 + 1;
            int n21 = n19 - 1;
            n19 = n12 + 8;
            n12 = n8;
            n8 = n;
            n = n15;
            n11 = n16;
            n10 = n7;
            n15 = n4;
            n16 = n12;
            n4 = n11;
            n12 = n19;
            while (n12 >= n8) {
                n11 = n13 & n9;
                n13 >>= n8;
                n12 -= n8;
                if (n11 == n3) {
                    n9 = n6;
                    n8 = n5;
                    n11 = n15;
                    n = -1;
                    n16 = n15;
                    n15 = n11;
                    continue;
                }
                if (n11 == n3 + 1) {
                    n19 = n4;
                    n4 = n15;
                    n15 = n;
                    n = n8;
                    n7 = n10;
                    n10 = n21;
                    n11 = n20;
                    n8 = n16;
                    n16 = n19;
                    continue block1;
                }
                if (n == -1) {
                    byArray[n14] = byArray2[n11];
                    ++n14;
                    ++n10;
                    n4 = n = n11;
                    continue;
                }
                if (n11 >= n16) {
                    object[n17] = (byte)n4;
                    n4 = n17 + 1;
                    n17 = n;
                } else {
                    n7 = n11;
                    n4 = n17;
                    n17 = n7;
                }
                while (n17 >= n3) {
                    object[n4] = byArray2[n17];
                    ++n4;
                    n17 = sArray[n17];
                }
                int n22 = byArray2[n17] & 0xFF;
                byte by = (byte)n22;
                byArray[n14] = by;
                n17 = n4;
                while (true) {
                    ++n14;
                    ++n10;
                    if (n17 <= 0) break;
                    byArray[n14] = (byte)object[--n17];
                }
                n18 = n16;
                n19 = n8;
                n7 = n9;
                if (n16 < 4096) {
                    sArray[n16] = (short)n;
                    byArray2[n16] = by;
                    n18 = n = n16 + 1;
                    n19 = n8;
                    n7 = n9;
                    if ((n & n9) == 0) {
                        n18 = n;
                        n19 = n8;
                        n7 = n9;
                        if (n < 4096) {
                            n19 = n8 + 1;
                            n7 = n9 + n;
                            n18 = n;
                        }
                    }
                }
                n = n11;
                n4 = n22;
                n16 = n18;
                n8 = n19;
                n9 = n7;
            }
            n19 = n;
            n = n16;
            n16 = n4;
            n18 = n8;
            n4 = n15;
            n7 = n10;
            n10 = n21;
            n11 = n20;
            n8 = n;
            n = n18;
            n15 = n19;
        }
        Arrays.fill(byArray, n14, n2, (byte)0);
    }

    private GifHeaderParser getHeaderParser() {
        if (this.parser == null) {
            this.parser = new GifHeaderParser();
        }
        return this.parser;
    }

    private Bitmap getNextBitmap() {
        Boolean bl = this.isFirstFrameTransparent;
        bl = bl != null && !bl.booleanValue() ? this.bitmapConfig : Bitmap.Config.ARGB_8888;
        bl = this.bitmapProvider.obtain(this.downsampledWidth, this.downsampledHeight, (Bitmap.Config)bl);
        bl.setHasAlpha(true);
        return bl;
    }

    private int readBlock() {
        int n = this.readByte();
        if (n <= 0) {
            return n;
        }
        ByteBuffer byteBuffer = this.rawData;
        byteBuffer.get(this.block, 0, Math.min(n, byteBuffer.remaining()));
        return n;
    }

    private int readByte() {
        return this.rawData.get() & 0xFF;
    }

    private Bitmap setPixels(GifFrame gifFrame, GifFrame gifFrame2) {
        int[] nArray = this.mainScratch;
        int n = 0;
        if (gifFrame2 == null) {
            Bitmap bitmap = this.previousImage;
            if (bitmap != null) {
                this.bitmapProvider.release(bitmap);
            }
            this.previousImage = null;
            Arrays.fill(nArray, 0);
        }
        if (gifFrame2 != null && gifFrame2.dispose == 3 && this.previousImage == null) {
            Arrays.fill(nArray, 0);
        }
        if (gifFrame2 != null && gifFrame2.dispose > 0) {
            if (gifFrame2.dispose == 2) {
                int n2;
                int n3 = n;
                if (!gifFrame.transparency) {
                    n3 = this.header.bgColor;
                    if (gifFrame.lct != null && this.header.bgIndex == gifFrame.transIndex) {
                        n3 = n;
                    }
                }
                int n4 = gifFrame2.ih / this.sampleSize;
                n = gifFrame2.iy / this.sampleSize;
                int n5 = gifFrame2.iw / this.sampleSize;
                int n6 = gifFrame2.ix / this.sampleSize;
                int n7 = this.downsampledWidth;
                for (n = n2 = n * n7 + n6; n < n4 * n7 + n2; n += this.downsampledWidth) {
                    for (n6 = n; n6 < n + n5; ++n6) {
                        nArray[n6] = n3;
                    }
                }
            } else if (gifFrame2.dispose == 3 && (gifFrame2 = this.previousImage) != null) {
                n = this.downsampledWidth;
                gifFrame2.getPixels(nArray, 0, n, 0, 0, n, this.downsampledHeight);
            }
        }
        this.decodeBitmapData(gifFrame);
        if (!gifFrame.interlace && this.sampleSize == 1) {
            this.copyIntoScratchFast(gifFrame);
        } else {
            this.copyCopyIntoScratchRobust(gifFrame);
        }
        if (this.savePrevious && (gifFrame.dispose == 0 || gifFrame.dispose == 1)) {
            if (this.previousImage == null) {
                this.previousImage = this.getNextBitmap();
            }
            gifFrame = this.previousImage;
            n = this.downsampledWidth;
            gifFrame.setPixels(nArray, 0, n, 0, 0, n, this.downsampledHeight);
        }
        gifFrame = this.getNextBitmap();
        n = this.downsampledWidth;
        gifFrame.setPixels(nArray, 0, n, 0, 0, n, this.downsampledHeight);
        return gifFrame;
    }

    @Override
    public void advance() {
        this.framePointer = (this.framePointer + 1) % this.header.frameCount;
    }

    @Override
    public void clear() {
        this.header = null;
        Object object = this.mainPixels;
        if (object != null) {
            this.bitmapProvider.release((byte[])object);
        }
        if ((object = (Object)this.mainScratch) != null) {
            this.bitmapProvider.release((int[])object);
        }
        if ((object = (Object)this.previousImage) != null) {
            this.bitmapProvider.release((Bitmap)object);
        }
        this.previousImage = null;
        this.rawData = null;
        this.isFirstFrameTransparent = null;
        object = this.block;
        if (object != null) {
            this.bitmapProvider.release((byte[])object);
        }
    }

    @Override
    public int getByteSize() {
        return this.rawData.limit() + this.mainPixels.length + this.mainScratch.length * 4;
    }

    @Override
    public int getCurrentFrameIndex() {
        return this.framePointer;
    }

    @Override
    public ByteBuffer getData() {
        return this.rawData;
    }

    @Override
    public int getDelay(int n) {
        n = n >= 0 && n < this.header.frameCount ? this.header.frames.get((int)n).delay : -1;
        return n;
    }

    @Override
    public int getFrameCount() {
        return this.header.frameCount;
    }

    @Override
    public int getHeight() {
        return this.header.height;
    }

    @Override
    @Deprecated
    public int getLoopCount() {
        if (this.header.loopCount == -1) {
            return 1;
        }
        return this.header.loopCount;
    }

    @Override
    public int getNetscapeLoopCount() {
        return this.header.loopCount;
    }

    @Override
    public int getNextDelay() {
        int n;
        if (this.header.frameCount > 0 && (n = this.framePointer) >= 0) {
            return this.getDelay(n);
        }
        return 0;
    }

    @Override
    public Bitmap getNextFrame() {
        synchronized (this) {
            Object object;
            Object object2;
            block16: {
                GifFrame gifFrame;
                block19: {
                    block18: {
                        block17: {
                            int n;
                            if (this.header.frameCount <= 0 || this.framePointer < 0) {
                                object2 = TAG;
                                if (Log.isLoggable((String)object2, (int)3)) {
                                    object = new StringBuilder();
                                    ((StringBuilder)object).append("Unable to decode frame, frameCount=");
                                    ((StringBuilder)object).append(this.header.frameCount);
                                    ((StringBuilder)object).append(", framePointer=");
                                    ((StringBuilder)object).append(this.framePointer);
                                    Log.d((String)object2, (String)((StringBuilder)object).toString());
                                }
                                this.status = 1;
                            }
                            if ((n = this.status) == 1 || n == 2) break block16;
                            this.status = 0;
                            if (this.block == null) {
                                this.block = this.bitmapProvider.obtainByteArray(255);
                            }
                            gifFrame = this.header.frames.get(this.framePointer);
                            n = this.framePointer - 1;
                            if (n < 0) break block17;
                            object2 = this.header.frames.get(n);
                            break block18;
                        }
                        object2 = null;
                    }
                    object = gifFrame.lct != null ? (Object)gifFrame.lct : (Object)this.header.gct;
                    this.act = (int[])object;
                    if (object != null) break block19;
                    object2 = TAG;
                    if (Log.isLoggable((String)object2, (int)3)) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("No valid color table found for frame #");
                        ((StringBuilder)object).append(this.framePointer);
                        Log.d((String)object2, (String)((StringBuilder)object).toString());
                    }
                    this.status = 1;
                    return null;
                }
                if (gifFrame.transparency) {
                    object = this.act;
                    System.arraycopy(object, 0, this.pct, 0, ((Object)object).length);
                    object = this.pct;
                    this.act = (int[])object;
                    object[gifFrame.transIndex] = false;
                    if (gifFrame.dispose == 2 && this.framePointer == 0) {
                        this.isFirstFrameTransparent = true;
                    }
                }
                object2 = this.setPixels(gifFrame, (GifFrame)object2);
                return object2;
            }
            object2 = TAG;
            if (Log.isLoggable((String)object2, (int)3)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Unable to decode frame, status=");
                ((StringBuilder)object).append(this.status);
                Log.d((String)object2, (String)((StringBuilder)object).toString());
            }
            return null;
        }
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public int getTotalIterationCount() {
        if (this.header.loopCount == -1) {
            return 1;
        }
        if (this.header.loopCount == 0) {
            return 0;
        }
        return this.header.loopCount + 1;
    }

    @Override
    public int getWidth() {
        return this.header.width;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(InputStream inputStream, int n) {
        if (inputStream != null) {
            n = n > 0 ? (n += 4096) : 16384;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
                byte[] byArray = new byte[16384];
                while ((n = inputStream.read(byArray, 0, 16384)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayOutputStream.flush();
                this.read(byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                Log.w((String)TAG, (String)"Error reading data from stream", (Throwable)iOException);
            }
        } else {
            this.status = 2;
        }
        if (inputStream == null) return this.status;
        try {
            inputStream.close();
            return this.status;
        }
        catch (IOException iOException) {
            Log.w((String)TAG, (String)"Error closing stream", (Throwable)iOException);
        }
        return this.status;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read(byte[] byArray) {
        synchronized (this) {
            GifHeader gifHeader;
            this.header = gifHeader = this.getHeaderParser().setData(byArray).parseHeader();
            if (byArray == null) return this.status;
            this.setData(gifHeader, byArray);
            return this.status;
        }
    }

    @Override
    public void resetFrameIndex() {
        this.framePointer = -1;
    }

    @Override
    public void setData(GifHeader gifHeader, ByteBuffer byteBuffer) {
        synchronized (this) {
            this.setData(gifHeader, byteBuffer, 1);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setData(GifHeader object, ByteBuffer iterator, int n) {
        synchronized (this) {
            Throwable throwable2;
            if (n > 0) {
                try {
                    n = Integer.highestOneBit(n);
                    this.status = 0;
                    this.header = object;
                    this.framePointer = -1;
                    iterator = ((ByteBuffer)((Object)iterator)).asReadOnlyBuffer();
                    this.rawData = iterator;
                    ((ByteBuffer)((Object)iterator)).position(0);
                    this.rawData.order(ByteOrder.LITTLE_ENDIAN);
                    this.savePrevious = false;
                    iterator = ((GifHeader)object).frames.iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next().dispose != 3) continue;
                        this.savePrevious = true;
                        break;
                    }
                    this.sampleSize = n;
                    this.downsampledWidth = ((GifHeader)object).width / n;
                    this.downsampledHeight = ((GifHeader)object).height / n;
                    this.mainPixels = this.bitmapProvider.obtainByteArray(((GifHeader)object).width * ((GifHeader)object).height);
                    this.mainScratch = this.bitmapProvider.obtainIntArray(this.downsampledWidth * this.downsampledHeight);
                    return;
                }
                catch (Throwable throwable2) {}
            } else {
                object = new StringBuilder();
                ((StringBuilder)object).append("Sample size must be >=0, not: ");
                ((StringBuilder)object).append(n);
                iterator = new Iterator<GifFrame>(((StringBuilder)object).toString());
                throw iterator;
            }
            throw throwable2;
        }
    }

    @Override
    public void setData(GifHeader gifHeader, byte[] byArray) {
        synchronized (this) {
            this.setData(gifHeader, ByteBuffer.wrap(byArray));
            return;
        }
    }

    @Override
    public void setDefaultBitmapConfig(Bitmap.Config config) {
        if (config != Bitmap.Config.ARGB_8888 && config != Bitmap.Config.RGB_565) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unsupported format: ");
            stringBuilder.append(config);
            stringBuilder.append(", must be one of ");
            stringBuilder.append(Bitmap.Config.ARGB_8888);
            stringBuilder.append(" or ");
            stringBuilder.append(Bitmap.Config.RGB_565);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        this.bitmapConfig = config;
    }
}

