/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load;

import com.bumptech.glide.load.ImageHeaderParser;
import com.bumptech.glide.load.data.ParcelFileDescriptorRewinder;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.resource.bitmap.RecyclableBufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;

public final class ImageHeaderParserUtils {
    private static final int MARK_READ_LIMIT = 0x500000;

    private ImageHeaderParserUtils() {
    }

    public static int getOrientation(List<ImageHeaderParser> list, final ParcelFileDescriptorRewinder parcelFileDescriptorRewinder, final ArrayPool arrayPool) throws IOException {
        return ImageHeaderParserUtils.getOrientationInternal(list, new OrientationReader(){

            /*
             * Loose catch block
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int getOrientation(ImageHeaderParser imageHeaderParser) throws IOException {
                void var1_4;
                block10: {
                    int n;
                    block8: {
                        InputStream inputStream;
                        block9: {
                            inputStream = null;
                            FileInputStream fileInputStream = new FileInputStream(parcelFileDescriptorRewinder.rewindAndGet().getFileDescriptor());
                            RecyclableBufferedInputStream recyclableBufferedInputStream = new RecyclableBufferedInputStream(fileInputStream, arrayPool);
                            try {
                                n = imageHeaderParser.getOrientation(recyclableBufferedInputStream, arrayPool);
                            }
                            catch (Throwable throwable) {
                                inputStream = recyclableBufferedInputStream;
                                break block9;
                            }
                            try {
                                ((InputStream)recyclableBufferedInputStream).close();
                                break block8;
                            }
                            catch (IOException iOException) {}
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (inputStream == null) break block10;
                        try {
                            inputStream.close();
                            break block10;
                        }
                        catch (IOException iOException) {}
                    }
                    parcelFileDescriptorRewinder.rewindAndGet();
                    return n;
                }
                parcelFileDescriptorRewinder.rewindAndGet();
                throw var1_4;
            }
        });
    }

    public static int getOrientation(List<ImageHeaderParser> list, InputStream inputStream, final ArrayPool arrayPool) throws IOException {
        if (inputStream == null) {
            return -1;
        }
        final InputStream inputStream2 = inputStream;
        if (!inputStream.markSupported()) {
            inputStream2 = new RecyclableBufferedInputStream(inputStream, arrayPool);
        }
        inputStream2.mark(0x500000);
        return ImageHeaderParserUtils.getOrientationInternal(list, new OrientationReader(){

            @Override
            public int getOrientation(ImageHeaderParser imageHeaderParser) throws IOException {
                try {
                    int n = imageHeaderParser.getOrientation(inputStream2, arrayPool);
                    return n;
                }
                finally {
                    inputStream2.reset();
                }
            }
        });
    }

    private static int getOrientationInternal(List<ImageHeaderParser> list, OrientationReader orientationReader) throws IOException {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int n2 = orientationReader.getOrientation(list.get(i));
            if (n2 == -1) continue;
            return n2;
        }
        return -1;
    }

    public static ImageHeaderParser.ImageType getType(List<ImageHeaderParser> list, final ParcelFileDescriptorRewinder parcelFileDescriptorRewinder, final ArrayPool arrayPool) throws IOException {
        return ImageHeaderParserUtils.getTypeInternal(list, new TypeReader(){

            /*
             * Loose catch block
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ImageHeaderParser.ImageType getType(ImageHeaderParser object) throws IOException {
                void var1_5;
                block10: {
                    ImageHeaderParser.ImageType imageType;
                    block8: {
                        InputStream inputStream;
                        block9: {
                            inputStream = null;
                            FileInputStream fileInputStream = new FileInputStream(parcelFileDescriptorRewinder.rewindAndGet().getFileDescriptor());
                            RecyclableBufferedInputStream recyclableBufferedInputStream = new RecyclableBufferedInputStream(fileInputStream, arrayPool);
                            try {
                                imageType = object.getType(recyclableBufferedInputStream);
                            }
                            catch (Throwable throwable) {
                                inputStream = recyclableBufferedInputStream;
                                break block9;
                            }
                            try {
                                ((InputStream)recyclableBufferedInputStream).close();
                                break block8;
                            }
                            catch (IOException iOException) {}
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (inputStream == null) break block10;
                        try {
                            inputStream.close();
                            break block10;
                        }
                        catch (IOException iOException) {}
                    }
                    parcelFileDescriptorRewinder.rewindAndGet();
                    return imageType;
                }
                parcelFileDescriptorRewinder.rewindAndGet();
                throw var1_5;
            }
        });
    }

    public static ImageHeaderParser.ImageType getType(List<ImageHeaderParser> list, InputStream inputStream, ArrayPool arrayPool) throws IOException {
        if (inputStream == null) {
            return ImageHeaderParser.ImageType.UNKNOWN;
        }
        final InputStream inputStream2 = inputStream;
        if (!inputStream.markSupported()) {
            inputStream2 = new RecyclableBufferedInputStream(inputStream, arrayPool);
        }
        inputStream2.mark(0x500000);
        return ImageHeaderParserUtils.getTypeInternal(list, new TypeReader(){

            @Override
            public ImageHeaderParser.ImageType getType(ImageHeaderParser object) throws IOException {
                try {
                    object = object.getType(inputStream2);
                    return object;
                }
                finally {
                    inputStream2.reset();
                }
            }
        });
    }

    public static ImageHeaderParser.ImageType getType(List<ImageHeaderParser> list, final ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            return ImageHeaderParser.ImageType.UNKNOWN;
        }
        return ImageHeaderParserUtils.getTypeInternal(list, new TypeReader(){

            @Override
            public ImageHeaderParser.ImageType getType(ImageHeaderParser imageHeaderParser) throws IOException {
                return imageHeaderParser.getType(byteBuffer);
            }
        });
    }

    private static ImageHeaderParser.ImageType getTypeInternal(List<ImageHeaderParser> list, TypeReader typeReader) throws IOException {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ImageHeaderParser.ImageType imageType = typeReader.getType(list.get(i));
            if (imageType == ImageHeaderParser.ImageType.UNKNOWN) continue;
            return imageType;
        }
        return ImageHeaderParser.ImageType.UNKNOWN;
    }

    private static interface OrientationReader {
        public int getOrientation(ImageHeaderParser var1) throws IOException;
    }

    private static interface TypeReader {
        public ImageHeaderParser.ImageType getType(ImageHeaderParser var1) throws IOException;
    }
}

