/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.data;

import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import java.io.IOException;
import java.io.OutputStream;

public final class BufferedOutputStream
extends OutputStream {
    private ArrayPool arrayPool;
    private byte[] buffer;
    private int index;
    private final OutputStream out;

    public BufferedOutputStream(OutputStream outputStream, ArrayPool arrayPool) {
        this(outputStream, arrayPool, 65536);
    }

    BufferedOutputStream(OutputStream outputStream, ArrayPool arrayPool, int n) {
        this.out = outputStream;
        this.arrayPool = arrayPool;
        this.buffer = arrayPool.get(n, byte[].class);
    }

    private void flushBuffer() throws IOException {
        int n = this.index;
        if (n > 0) {
            this.out.write(this.buffer, 0, n);
            this.index = 0;
        }
    }

    private void maybeFlushBuffer() throws IOException {
        if (this.index == this.buffer.length) {
            this.flushBuffer();
        }
    }

    private void release() {
        byte[] byArray = this.buffer;
        if (byArray != null) {
            this.arrayPool.put(byArray);
            this.buffer = null;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
            this.release();
            return;
        }
        finally {
            this.out.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = this.buffer;
        int n2 = this.index;
        this.index = n2 + 1;
        byArray[n2] = (byte)n;
        this.maybeFlushBuffer();
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        do {
            int n5 = n2 - n4;
            n3 = n + n4;
            int n6 = this.index;
            if (n6 == 0 && n5 >= this.buffer.length) {
                this.out.write(byArray, n3, n5);
                return;
            }
            n5 = Math.min(n5, this.buffer.length - n6);
            System.arraycopy(byArray, n3, this.buffer, this.index, n5);
            this.index += n5;
            n3 = n4 + n5;
            this.maybeFlushBuffer();
            n4 = n3;
        } while (n3 < n2);
    }
}

