/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.data;

import android.text.TextUtils;
import android.util.Log;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.HttpException;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.util.ContentLengthInputStream;
import com.bumptech.glide.util.LogTime;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;

public class HttpUrlFetcher
implements DataFetcher<InputStream> {
    static final HttpUrlConnectionFactory DEFAULT_CONNECTION_FACTORY = new DefaultHttpUrlConnectionFactory();
    private static final int INVALID_STATUS_CODE = -1;
    private static final int MAXIMUM_REDIRECTS = 5;
    private static final String TAG = "HttpUrlFetcher";
    private final HttpUrlConnectionFactory connectionFactory;
    private final GlideUrl glideUrl;
    private volatile boolean isCancelled;
    private InputStream stream;
    private final int timeout;
    private HttpURLConnection urlConnection;

    public HttpUrlFetcher(GlideUrl glideUrl, int n) {
        this(glideUrl, n, DEFAULT_CONNECTION_FACTORY);
    }

    HttpUrlFetcher(GlideUrl glideUrl, int n, HttpUrlConnectionFactory httpUrlConnectionFactory) {
        this.glideUrl = glideUrl;
        this.timeout = n;
        this.connectionFactory = httpUrlConnectionFactory;
    }

    private InputStream getStreamForSuccessfulRequest(HttpURLConnection httpURLConnection) throws IOException {
        if (TextUtils.isEmpty((CharSequence)httpURLConnection.getContentEncoding())) {
            int n = httpURLConnection.getContentLength();
            this.stream = ContentLengthInputStream.obtain(httpURLConnection.getInputStream(), n);
        } else {
            if (Log.isLoggable((String)TAG, (int)3)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Got non empty content encoding: ");
                stringBuilder.append(httpURLConnection.getContentEncoding());
                Log.d((String)TAG, (String)stringBuilder.toString());
            }
            this.stream = httpURLConnection.getInputStream();
        }
        return this.stream;
    }

    private static boolean isHttpOk(int n) {
        boolean bl = n / 100 == 2;
        return bl;
    }

    private static boolean isHttpRedirect(int n) {
        boolean bl = n / 100 == 3;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream loadDataWithRedirects(URL uRL, int n, URL object, Map<String, String> map) throws IOException {
        if (n >= 5) {
            throw new HttpException("Too many (> 5) redirects!");
        }
        if (object != null) {
            try {
                if (uRL.toURI().equals(((URL)object).toURI())) {
                    object = new HttpException("In re-direct loop");
                    throw object;
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        this.urlConnection = this.connectionFactory.build(uRL);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.urlConnection.addRequestProperty(entry.getKey(), entry.getValue());
        }
        this.urlConnection.setConnectTimeout(this.timeout);
        this.urlConnection.setReadTimeout(this.timeout);
        this.urlConnection.setUseCaches(false);
        this.urlConnection.setDoInput(true);
        this.urlConnection.setInstanceFollowRedirects(false);
        this.urlConnection.connect();
        this.stream = this.urlConnection.getInputStream();
        if (this.isCancelled) {
            return null;
        }
        int n2 = this.urlConnection.getResponseCode();
        if (HttpUrlFetcher.isHttpOk(n2)) {
            return this.getStreamForSuccessfulRequest(this.urlConnection);
        }
        if (HttpUrlFetcher.isHttpRedirect(n2)) {
            object = this.urlConnection.getHeaderField("Location");
            if (!TextUtils.isEmpty((CharSequence)object)) {
                object = new URL(uRL, (String)object);
                this.cleanup();
                return this.loadDataWithRedirects((URL)object, n + 1, uRL, map);
            }
            throw new HttpException("Received empty or null redirect url");
        }
        if (n2 == -1) {
            throw new HttpException(n2);
        }
        throw new HttpException(this.urlConnection.getResponseMessage(), n2);
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
    }

    @Override
    public void cleanup() {
        Object object = this.stream;
        if (object != null) {
            try {
                ((InputStream)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((object = this.urlConnection) != null) {
            ((HttpURLConnection)object).disconnect();
        }
        this.urlConnection = null;
    }

    @Override
    public Class<InputStream> getDataClass() {
        return InputStream.class;
    }

    @Override
    public DataSource getDataSource() {
        return DataSource.REMOTE;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void loadData(Priority object, DataFetcher.DataCallback<? super InputStream> dataCallback) {
        Throwable throwable2222222;
        long l;
        block9: {
            block10: {
                block11: {
                    l = LogTime.getLogTime();
                    dataCallback.onDataReady(this.loadDataWithRedirects(this.glideUrl.toURL(), 0, null, this.glideUrl.getHeaders()));
                    {
                        catch (Throwable throwable2222222) {
                            break block9;
                        }
                        catch (IOException iOException) {}
                        {
                            if (Log.isLoggable((String)TAG, (int)3)) {
                                Log.d((String)TAG, (String)"Failed to load data for url", (Throwable)iOException);
                            }
                            dataCallback.onLoadFailed(iOException);
                        }
                        if (!Log.isLoggable((String)TAG, (int)2)) break block10;
                        object = new StringBuilder();
                        break block11;
                    }
                    if (!Log.isLoggable((String)TAG, (int)2)) break block10;
                    object = new StringBuilder();
                }
                ((StringBuilder)object).append("Finished http url fetcher fetch in ");
                ((StringBuilder)object).append(LogTime.getElapsedMillis(l));
                Log.v((String)TAG, (String)((StringBuilder)object).toString());
            }
            return;
        }
        if (Log.isLoggable((String)TAG, (int)2)) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Finished http url fetcher fetch in ");
            ((StringBuilder)object).append(LogTime.getElapsedMillis(l));
            Log.v((String)TAG, (String)((StringBuilder)object).toString());
        }
        throw throwable2222222;
    }

    private static class DefaultHttpUrlConnectionFactory
    implements HttpUrlConnectionFactory {
        DefaultHttpUrlConnectionFactory() {
        }

        @Override
        public HttpURLConnection build(URL uRL) throws IOException {
            return (HttpURLConnection)uRL.openConnection();
        }
    }

    static interface HttpUrlConnectionFactory {
        public HttpURLConnection build(URL var1) throws IOException;
    }
}

