/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import android.util.Log;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Key;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class GlideException
extends Exception {
    private static final StackTraceElement[] EMPTY_ELEMENTS = new StackTraceElement[0];
    private static final long serialVersionUID = 1L;
    private final List<Throwable> causes;
    private Class<?> dataClass;
    private DataSource dataSource;
    private String detailMessage;
    private Exception exception;
    private Key key;

    public GlideException(String string2) {
        this(string2, Collections.emptyList());
    }

    public GlideException(String string2, Throwable throwable) {
        this(string2, Collections.singletonList(throwable));
    }

    public GlideException(String string2, List<Throwable> list) {
        this.detailMessage = string2;
        this.setStackTrace(EMPTY_ELEMENTS);
        this.causes = list;
    }

    private void addRootCauses(Throwable object, List<Throwable> list) {
        if (object instanceof GlideException) {
            object = ((GlideException)object).getCauses().iterator();
            while (object.hasNext()) {
                this.addRootCauses((Throwable)object.next(), list);
            }
        } else {
            list.add((Throwable)object);
        }
    }

    private static void appendCauses(List<Throwable> list, Appendable appendable) {
        try {
            GlideException.appendCausesWrapped(list, appendable);
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static void appendCausesWrapped(List<Throwable> list, Appendable appendable) throws IOException {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object object = appendable.append("Cause (");
            int n3 = n2 + 1;
            object.append(String.valueOf(n3)).append(" of ").append(String.valueOf(n)).append("): ");
            object = list.get(n2);
            if (object instanceof GlideException) {
                ((GlideException)object).printStackTrace(appendable);
            } else {
                GlideException.appendExceptionMessage((Throwable)object, appendable);
            }
            n2 = n3;
        }
    }

    private static void appendExceptionMessage(Throwable throwable, Appendable appendable) {
        try {
            appendable.append(throwable.getClass().toString()).append(": ").append(throwable.getMessage()).append('\n');
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(throwable);
        }
    }

    private void printStackTrace(Appendable appendable) {
        GlideException.appendExceptionMessage(this, appendable);
        GlideException.appendCauses(this.getCauses(), new IndentedAppendable(appendable));
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    public List<Throwable> getCauses() {
        return this.causes;
    }

    @Override
    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder(71);
        stringBuilder.append(this.detailMessage);
        Iterator iterator = this.dataClass;
        Object object = "";
        if (iterator != null) {
            iterator = new StringBuilder();
            ((StringBuilder)((Object)iterator)).append(", ");
            ((StringBuilder)((Object)iterator)).append(this.dataClass);
            iterator = ((StringBuilder)((Object)iterator)).toString();
        } else {
            iterator = "";
        }
        stringBuilder.append((String)((Object)iterator));
        if (this.dataSource != null) {
            iterator = new StringBuilder();
            ((StringBuilder)((Object)iterator)).append(", ");
            ((StringBuilder)((Object)iterator)).append((Object)this.dataSource);
            iterator = ((StringBuilder)((Object)iterator)).toString();
        } else {
            iterator = "";
        }
        stringBuilder.append((String)((Object)iterator));
        iterator = object;
        if (this.key != null) {
            iterator = new StringBuilder();
            ((StringBuilder)((Object)iterator)).append(", ");
            ((StringBuilder)((Object)iterator)).append(this.key);
            iterator = ((StringBuilder)((Object)iterator)).toString();
        }
        stringBuilder.append((String)((Object)iterator));
        iterator = this.getRootCauses();
        if (iterator.isEmpty()) {
            return stringBuilder.toString();
        }
        if (iterator.size() == 1) {
            stringBuilder.append("\nThere was 1 cause:");
        } else {
            stringBuilder.append("\nThere were ");
            stringBuilder.append(iterator.size());
            stringBuilder.append(" causes:");
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            object = (Throwable)iterator.next();
            stringBuilder.append('\n');
            stringBuilder.append(object.getClass().getName());
            stringBuilder.append('(');
            stringBuilder.append(((Throwable)object).getMessage());
            stringBuilder.append(')');
        }
        stringBuilder.append("\n call GlideException#logRootCauses(String) for more detail");
        return stringBuilder.toString();
    }

    public Exception getOrigin() {
        return this.exception;
    }

    public List<Throwable> getRootCauses() {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        this.addRootCauses(this, arrayList);
        return arrayList;
    }

    public void logRootCauses(String string2) {
        List<Throwable> list = this.getRootCauses();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Root cause (");
            int n3 = n2 + 1;
            stringBuilder.append(n3);
            stringBuilder.append(" of ");
            stringBuilder.append(n);
            stringBuilder.append(")");
            Log.i((String)string2, (String)stringBuilder.toString(), (Throwable)list.get(n2));
            n2 = n3;
        }
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace((Appendable)printStream);
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        this.printStackTrace((Appendable)printWriter);
    }

    void setLoggingDetails(Key key, DataSource dataSource) {
        this.setLoggingDetails(key, dataSource, null);
    }

    void setLoggingDetails(Key key, DataSource dataSource, Class<?> clazz) {
        this.key = key;
        this.dataSource = dataSource;
        this.dataClass = clazz;
    }

    public void setOrigin(Exception exception) {
        this.exception = exception;
    }

    private static final class IndentedAppendable
    implements Appendable {
        private static final String EMPTY_SEQUENCE = "";
        private static final String INDENT = "  ";
        private final Appendable appendable;
        private boolean printedNewLine = true;

        IndentedAppendable(Appendable appendable) {
            this.appendable = appendable;
        }

        private CharSequence safeSequence(CharSequence charSequence) {
            CharSequence charSequence2 = charSequence;
            if (charSequence == null) {
                charSequence2 = EMPTY_SEQUENCE;
            }
            return charSequence2;
        }

        @Override
        public Appendable append(char c) throws IOException {
            boolean bl = this.printedNewLine;
            boolean bl2 = false;
            if (bl) {
                this.printedNewLine = false;
                this.appendable.append(INDENT);
            }
            if (c == '\n') {
                bl2 = true;
            }
            this.printedNewLine = bl2;
            this.appendable.append(c);
            return this;
        }

        @Override
        public Appendable append(CharSequence charSequence) throws IOException {
            charSequence = this.safeSequence(charSequence);
            return this.append(charSequence, 0, charSequence.length());
        }

        @Override
        public Appendable append(CharSequence charSequence, int n, int n2) throws IOException {
            charSequence = this.safeSequence(charSequence);
            boolean bl = this.printedNewLine;
            boolean bl2 = false;
            if (bl) {
                this.printedNewLine = false;
                this.appendable.append(INDENT);
            }
            bl = bl2;
            if (charSequence.length() > 0) {
                bl = bl2;
                if (charSequence.charAt(n2 - 1) == '\n') {
                    bl = true;
                }
            }
            this.printedNewLine = bl;
            this.appendable.append(charSequence, n, n2);
            return this;
        }
    }
}

