/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.engine.DataFetcherGenerator;
import com.bumptech.glide.load.engine.DecodeHelper;
import com.bumptech.glide.load.engine.ResourceCacheKey;
import com.bumptech.glide.load.model.ModelLoader;
import java.io.File;
import java.util.List;

class ResourceCacheGenerator
implements DataFetcherGenerator,
DataFetcher.DataCallback<Object> {
    private File cacheFile;
    private final DataFetcherGenerator.FetcherReadyCallback cb;
    private ResourceCacheKey currentKey;
    private final DecodeHelper<?> helper;
    private volatile ModelLoader.LoadData<?> loadData;
    private int modelLoaderIndex;
    private List<ModelLoader<File, ?>> modelLoaders;
    private int resourceClassIndex = -1;
    private int sourceIdIndex;
    private Key sourceKey;

    ResourceCacheGenerator(DecodeHelper<?> decodeHelper, DataFetcherGenerator.FetcherReadyCallback fetcherReadyCallback) {
        this.helper = decodeHelper;
        this.cb = fetcherReadyCallback;
    }

    private boolean hasNextModelLoader() {
        boolean bl = this.modelLoaderIndex < this.modelLoaders.size();
        return bl;
    }

    @Override
    public void cancel() {
        ModelLoader.LoadData<?> loadData = this.loadData;
        if (loadData != null) {
            loadData.fetcher.cancel();
        }
    }

    @Override
    public void onDataReady(Object object) {
        this.cb.onDataFetcherReady(this.sourceKey, object, this.loadData.fetcher, DataSource.RESOURCE_DISK_CACHE, this.currentKey);
    }

    @Override
    public void onLoadFailed(Exception exception) {
        this.cb.onDataFetcherFailed(this.currentKey, exception, this.loadData.fetcher, DataSource.RESOURCE_DISK_CACHE);
    }

    @Override
    public boolean startNext() {
        List<Key> list = this.helper.getCacheKeys();
        boolean bl = list.isEmpty();
        boolean bl2 = false;
        if (bl) {
            return false;
        }
        List<Object> list2 = this.helper.getRegisteredResourceClasses();
        if (list2.isEmpty()) {
            if (File.class.equals(this.helper.getTranscodeClass())) {
                return false;
            }
            list2 = new StringBuilder();
            ((StringBuilder)((Object)list2)).append("Failed to find any load path from ");
            ((StringBuilder)((Object)list2)).append(this.helper.getModelClass());
            ((StringBuilder)((Object)list2)).append(" to ");
            ((StringBuilder)((Object)list2)).append(this.helper.getTranscodeClass());
            throw new IllegalStateException(((StringBuilder)((Object)list2)).toString());
        }
        while (true) {
            int n;
            if (this.modelLoaders != null && this.hasNextModelLoader()) {
                this.loadData = null;
                while (!bl2 && this.hasNextModelLoader()) {
                    list2 = this.modelLoaders;
                    n = this.modelLoaderIndex;
                    this.modelLoaderIndex = n + 1;
                    this.loadData = list2.get(n).buildLoadData(this.cacheFile, this.helper.getWidth(), this.helper.getHeight(), this.helper.getOptions());
                    if (this.loadData == null || !this.helper.hasLoadPath(this.loadData.fetcher.getDataClass())) continue;
                    this.loadData.fetcher.loadData(this.helper.getPriority(), this);
                    bl2 = true;
                }
                return bl2;
            }
            this.resourceClassIndex = n = this.resourceClassIndex + 1;
            if (n >= list2.size()) {
                this.sourceIdIndex = n = this.sourceIdIndex + 1;
                if (n >= list.size()) {
                    return false;
                }
                this.resourceClassIndex = 0;
            }
            Key key = list.get(this.sourceIdIndex);
            Class clazz = (Class)((Object)list2.get(this.resourceClassIndex));
            Object object = this.helper.getTransformation(clazz);
            this.currentKey = new ResourceCacheKey(this.helper.getArrayPool(), key, this.helper.getSignature(), this.helper.getWidth(), this.helper.getHeight(), (Transformation<?>)object, clazz, this.helper.getOptions());
            this.cacheFile = object = this.helper.getDiskCache().get(this.currentKey);
            if (object == null) continue;
            this.sourceKey = key;
            this.modelLoaders = this.helper.getModelLoaders((File)object);
            this.modelLoaderIndex = 0;
        }
    }
}

