/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.bitmap_recycle;

import android.graphics.Bitmap;
import com.bumptech.glide.load.engine.bitmap_recycle.BaseKeyPool;
import com.bumptech.glide.load.engine.bitmap_recycle.GroupedLinkedMap;
import com.bumptech.glide.load.engine.bitmap_recycle.LruPoolStrategy;
import com.bumptech.glide.load.engine.bitmap_recycle.Poolable;
import com.bumptech.glide.util.Util;

class AttributeStrategy
implements LruPoolStrategy {
    private final GroupedLinkedMap<Key, Bitmap> groupedMap;
    private final KeyPool keyPool = new KeyPool();

    AttributeStrategy() {
        this.groupedMap = new GroupedLinkedMap();
    }

    static String getBitmapString(int n, int n2, Bitmap.Config config) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(n);
        stringBuilder.append("x");
        stringBuilder.append(n2);
        stringBuilder.append("], ");
        stringBuilder.append(config);
        return stringBuilder.toString();
    }

    private static String getBitmapString(Bitmap bitmap) {
        return AttributeStrategy.getBitmapString(bitmap.getWidth(), bitmap.getHeight(), bitmap.getConfig());
    }

    @Override
    public Bitmap get(int n, int n2, Bitmap.Config object) {
        object = this.keyPool.get(n, n2, (Bitmap.Config)object);
        return this.groupedMap.get((Key)object);
    }

    @Override
    public int getSize(Bitmap bitmap) {
        return Util.getBitmapByteSize(bitmap);
    }

    @Override
    public String logBitmap(int n, int n2, Bitmap.Config config) {
        return AttributeStrategy.getBitmapString(n, n2, config);
    }

    @Override
    public String logBitmap(Bitmap bitmap) {
        return AttributeStrategy.getBitmapString(bitmap);
    }

    @Override
    public void put(Bitmap bitmap) {
        Key key = this.keyPool.get(bitmap.getWidth(), bitmap.getHeight(), bitmap.getConfig());
        this.groupedMap.put(key, bitmap);
    }

    @Override
    public Bitmap removeLast() {
        return this.groupedMap.removeLast();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AttributeStrategy:\n  ");
        stringBuilder.append(this.groupedMap);
        return stringBuilder.toString();
    }

    static class Key
    implements Poolable {
        private Bitmap.Config config;
        private int height;
        private final KeyPool pool;
        private int width;

        public Key(KeyPool keyPool) {
            this.pool = keyPool;
        }

        public boolean equals(Object object) {
            boolean bl;
            boolean bl2 = object instanceof Key;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (Key)object;
                bl3 = bl;
                if (this.width == ((Key)object).width) {
                    bl3 = bl;
                    if (this.height == ((Key)object).height) {
                        bl3 = bl;
                        if (this.config == ((Key)object).config) {
                            bl3 = true;
                        }
                    }
                }
            }
            return bl3;
        }

        public int hashCode() {
            int n = this.width;
            int n2 = this.height;
            Bitmap.Config config = this.config;
            int n3 = config != null ? config.hashCode() : 0;
            return (n * 31 + n2) * 31 + n3;
        }

        public void init(int n, int n2, Bitmap.Config config) {
            this.width = n;
            this.height = n2;
            this.config = config;
        }

        @Override
        public void offer() {
            this.pool.offer(this);
        }

        public String toString() {
            return AttributeStrategy.getBitmapString(this.width, this.height, this.config);
        }
    }

    static class KeyPool
    extends BaseKeyPool<Key> {
        KeyPool() {
        }

        @Override
        protected Key create() {
            return new Key(this);
        }

        Key get(int n, int n2, Bitmap.Config config) {
            Key key = (Key)this.get();
            key.init(n, n2, config);
            return key;
        }
    }
}

