/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.bitmap_recycle;

import android.graphics.Bitmap;
import com.bumptech.glide.load.engine.bitmap_recycle.BaseKeyPool;
import com.bumptech.glide.load.engine.bitmap_recycle.GroupedLinkedMap;
import com.bumptech.glide.load.engine.bitmap_recycle.LruPoolStrategy;
import com.bumptech.glide.load.engine.bitmap_recycle.Poolable;
import com.bumptech.glide.load.engine.bitmap_recycle.PrettyPrintTreeMap;
import com.bumptech.glide.util.Util;
import java.util.NavigableMap;

final class SizeStrategy
implements LruPoolStrategy {
    private static final int MAX_SIZE_MULTIPLE = 8;
    private final GroupedLinkedMap<Key, Bitmap> groupedMap;
    private final KeyPool keyPool = new KeyPool();
    private final NavigableMap<Integer, Integer> sortedSizes;

    SizeStrategy() {
        this.groupedMap = new GroupedLinkedMap();
        this.sortedSizes = new PrettyPrintTreeMap<Integer, Integer>();
    }

    private void decrementBitmapOfSize(Integer n) {
        Integer n2 = (Integer)this.sortedSizes.get(n);
        if (n2 == 1) {
            this.sortedSizes.remove(n);
        } else {
            this.sortedSizes.put(n, n2 - 1);
        }
    }

    static String getBitmapString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(n);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static String getBitmapString(Bitmap bitmap) {
        return SizeStrategy.getBitmapString(Util.getBitmapByteSize(bitmap));
    }

    @Override
    public Bitmap get(int n, int n2, Bitmap.Config config) {
        int n3 = Util.getBitmapByteSize(n, n2, config);
        Key key = this.keyPool.get(n3);
        Integer n4 = this.sortedSizes.ceilingKey(n3);
        Key key2 = key;
        if (n4 != null) {
            key2 = key;
            if (n4 != n3) {
                key2 = key;
                if (n4 <= n3 * 8) {
                    this.keyPool.offer(key);
                    key2 = this.keyPool.get(n4);
                }
            }
        }
        if ((key2 = this.groupedMap.get(key2)) != null) {
            key2.reconfigure(n, n2, config);
            this.decrementBitmapOfSize(n4);
        }
        return key2;
    }

    @Override
    public int getSize(Bitmap bitmap) {
        return Util.getBitmapByteSize(bitmap);
    }

    @Override
    public String logBitmap(int n, int n2, Bitmap.Config config) {
        return SizeStrategy.getBitmapString(Util.getBitmapByteSize(n, n2, config));
    }

    @Override
    public String logBitmap(Bitmap bitmap) {
        return SizeStrategy.getBitmapString(bitmap);
    }

    @Override
    public void put(Bitmap object) {
        int n = Util.getBitmapByteSize((Bitmap)object);
        Key key = this.keyPool.get(n);
        this.groupedMap.put(key, (Bitmap)object);
        object = (Integer)this.sortedSizes.get(key.size);
        NavigableMap<Integer, Integer> navigableMap = this.sortedSizes;
        int n2 = key.size;
        n = 1;
        if (object != null) {
            n = 1 + (Integer)object;
        }
        navigableMap.put(n2, n);
    }

    @Override
    public Bitmap removeLast() {
        Bitmap bitmap = this.groupedMap.removeLast();
        if (bitmap != null) {
            this.decrementBitmapOfSize(Util.getBitmapByteSize(bitmap));
        }
        return bitmap;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SizeStrategy:\n  ");
        stringBuilder.append(this.groupedMap);
        stringBuilder.append("\n  SortedSizes");
        stringBuilder.append(this.sortedSizes);
        return stringBuilder.toString();
    }

    static final class Key
    implements Poolable {
        private final KeyPool pool;
        int size;

        Key(KeyPool keyPool) {
            this.pool = keyPool;
        }

        public boolean equals(Object object) {
            boolean bl;
            boolean bl2 = object instanceof Key;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (Key)object;
                bl3 = bl;
                if (this.size == ((Key)object).size) {
                    bl3 = true;
                }
            }
            return bl3;
        }

        public int hashCode() {
            return this.size;
        }

        public void init(int n) {
            this.size = n;
        }

        @Override
        public void offer() {
            this.pool.offer(this);
        }

        public String toString() {
            return SizeStrategy.getBitmapString(this.size);
        }
    }

    static class KeyPool
    extends BaseKeyPool<Key> {
        KeyPool() {
        }

        @Override
        protected Key create() {
            return new Key(this);
        }

        public Key get(int n) {
            Key key = (Key)super.get();
            key.init(n);
            return key;
        }
    }
}

