/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.cache;

import com.bumptech.glide.load.engine.cache.DiskCache;
import com.bumptech.glide.load.engine.cache.DiskLruCacheWrapper;
import java.io.File;

public class DiskLruCacheFactory
implements DiskCache.Factory {
    private final CacheDirectoryGetter cacheDirectoryGetter;
    private final long diskCacheSize;

    public DiskLruCacheFactory(CacheDirectoryGetter cacheDirectoryGetter, long l) {
        this.diskCacheSize = l;
        this.cacheDirectoryGetter = cacheDirectoryGetter;
    }

    public DiskLruCacheFactory(final String string2, long l) {
        this(new CacheDirectoryGetter(){

            @Override
            public File getCacheDirectory() {
                return new File(string2);
            }
        }, l);
    }

    public DiskLruCacheFactory(final String string2, final String string3, long l) {
        this(new CacheDirectoryGetter(){

            @Override
            public File getCacheDirectory() {
                return new File(string2, string3);
            }
        }, l);
    }

    @Override
    public DiskCache build() {
        File file = this.cacheDirectoryGetter.getCacheDirectory();
        if (file == null) {
            return null;
        }
        if (!(file.mkdirs() || file.exists() && file.isDirectory())) {
            return null;
        }
        return DiskLruCacheWrapper.create(file, this.diskCacheSize);
    }

    public static interface CacheDirectoryGetter {
        public File getCacheDirectory();
    }
}

