/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.executor;

import android.os.Build;
import android.os.StrictMode;
import android.util.Log;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

final class RuntimeCompat {
    private static final String CPU_LOCATION = "/sys/devices/system/cpu/";
    private static final String CPU_NAME_REGEX = "cpu[0-9]+";
    private static final String TAG = "GlideRuntimeCompat";

    private RuntimeCompat() {
    }

    static int availableProcessors() {
        int n;
        int n2 = n = Runtime.getRuntime().availableProcessors();
        if (Build.VERSION.SDK_INT < 17) {
            n2 = Math.max(RuntimeCompat.getCoreCountPre17(), n);
        }
        return n2;
    }

    private static int getCoreCountPre17() {
        FilenameFilter filenameFilter;
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            File file = new File(CPU_LOCATION);
            final Pattern pattern = Pattern.compile(CPU_NAME_REGEX);
            filenameFilter = new FilenameFilter(){

                @Override
                public boolean accept(File file, String string2) {
                    return pattern.matcher(string2).matches();
                }
            };
            filenameFilter = file.listFiles(filenameFilter);
        }
        catch (Throwable throwable) {
            if (Log.isLoggable((String)TAG, (int)6)) {
                Log.e((String)TAG, (String)"Failed to calculate accurate cpu count", (Throwable)throwable);
            }
            filenameFilter = null;
        }
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        int n = filenameFilter != null ? (filenameFilter).length : 0;
        return Math.max(1, n);
        {
            finally {
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
            }
        }
    }
}

