/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.prefill;

import android.graphics.Bitmap;
import com.bumptech.glide.util.Preconditions;

public final class PreFillType {
    static final Bitmap.Config DEFAULT_CONFIG = Bitmap.Config.RGB_565;
    private final Bitmap.Config config;
    private final int height;
    private final int weight;
    private final int width;

    PreFillType(int n, int n2, Bitmap.Config config, int n3) {
        this.config = Preconditions.checkNotNull(config, "Config must not be null");
        this.width = n;
        this.height = n2;
        this.weight = n3;
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = object instanceof PreFillType;
        boolean bl3 = bl = false;
        if (bl2) {
            object = (PreFillType)object;
            bl3 = bl;
            if (this.height == ((PreFillType)object).height) {
                bl3 = bl;
                if (this.width == ((PreFillType)object).width) {
                    bl3 = bl;
                    if (this.weight == ((PreFillType)object).weight) {
                        bl3 = bl;
                        if (this.config == ((PreFillType)object).config) {
                            bl3 = true;
                        }
                    }
                }
            }
        }
        return bl3;
    }

    Bitmap.Config getConfig() {
        return this.config;
    }

    int getHeight() {
        return this.height;
    }

    int getWeight() {
        return this.weight;
    }

    int getWidth() {
        return this.width;
    }

    public int hashCode() {
        return ((this.width * 31 + this.height) * 31 + this.config.hashCode()) * 31 + this.weight;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PreFillSize{width=");
        stringBuilder.append(this.width);
        stringBuilder.append(", height=");
        stringBuilder.append(this.height);
        stringBuilder.append(", config=");
        stringBuilder.append(this.config);
        stringBuilder.append(", weight=");
        stringBuilder.append(this.weight);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static class Builder {
        private Bitmap.Config config;
        private final int height;
        private int weight = 1;
        private final int width;

        public Builder(int n) {
            this(n, n);
        }

        public Builder(int n, int n2) {
            if (n > 0) {
                if (n2 > 0) {
                    this.width = n;
                    this.height = n2;
                    return;
                }
                throw new IllegalArgumentException("Height must be > 0");
            }
            throw new IllegalArgumentException("Width must be > 0");
        }

        PreFillType build() {
            return new PreFillType(this.width, this.height, this.config, this.weight);
        }

        Bitmap.Config getConfig() {
            return this.config;
        }

        public Builder setConfig(Bitmap.Config config) {
            this.config = config;
            return this;
        }

        public Builder setWeight(int n) {
            if (n > 0) {
                this.weight = n;
                return this;
            }
            throw new IllegalArgumentException("Weight must be > 0");
        }
    }
}

