/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource;

import android.graphics.ColorSpace;
import android.graphics.ImageDecoder;
import android.os.Build;
import android.util.Log;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.PreferredColorSpace;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.resource.bitmap.DownsampleStrategy;
import com.bumptech.glide.load.resource.bitmap.Downsampler;
import com.bumptech.glide.load.resource.bitmap.HardwareConfigState;
import java.io.IOException;

public abstract class ImageDecoderResourceDecoder<T>
implements ResourceDecoder<ImageDecoder.Source, T> {
    private static final String TAG = "ImageDecoder";
    final HardwareConfigState hardwareConfigState = HardwareConfigState.getInstance();

    protected abstract Resource<T> decode(ImageDecoder.Source var1, int var2, int var3, ImageDecoder.OnHeaderDecodedListener var4) throws IOException;

    @Override
    public final Resource<T> decode(ImageDecoder.Source source, final int n, final int n2, Options options) throws IOException {
        final DecodeFormat decodeFormat = options.get(Downsampler.DECODE_FORMAT);
        final DownsampleStrategy downsampleStrategy = options.get(DownsampleStrategy.OPTION);
        final boolean bl = options.get(Downsampler.ALLOW_HARDWARE_CONFIG) != null && options.get(Downsampler.ALLOW_HARDWARE_CONFIG) != false;
        return this.decode(source, n, n2, new ImageDecoder.OnHeaderDecodedListener(options.get(Downsampler.PREFERRED_COLOR_SPACE)){
            final /* synthetic */ PreferredColorSpace val$preferredColorSpace;
            {
                this.val$preferredColorSpace = preferredColorSpace;
            }

            public void onHeaderDecoded(ImageDecoder imageDecoder, ImageDecoder.ImageInfo imageInfo, ImageDecoder.Source object) {
                int n5;
                object = ImageDecoderResourceDecoder.this.hardwareConfigState;
                int n22 = n;
                int n3 = n2;
                boolean bl2 = bl;
                int n4 = 0;
                if (((HardwareConfigState)object).isHardwareConfigAllowed(n22, n3, bl2, false)) {
                    imageDecoder.setAllocator(3);
                } else {
                    imageDecoder.setAllocator(1);
                }
                if (decodeFormat == DecodeFormat.PREFER_RGB_565) {
                    imageDecoder.setMemorySizePolicy(0);
                }
                imageDecoder.setOnPartialImageListener(new ImageDecoder.OnPartialImageListener(){

                    public boolean onPartialImage(ImageDecoder.DecodeException decodeException) {
                        return false;
                    }
                });
                object = imageInfo.getSize();
                n22 = n3 = n;
                if (n3 == Integer.MIN_VALUE) {
                    n22 = object.getWidth();
                }
                n3 = n5 = n2;
                if (n5 == Integer.MIN_VALUE) {
                    n3 = object.getHeight();
                }
                float f = downsampleStrategy.getScaleFactor(object.getWidth(), object.getHeight(), n22, n3);
                n3 = Math.round((float)object.getWidth() * f);
                n22 = Math.round((float)object.getHeight() * f);
                if (Log.isLoggable((String)ImageDecoderResourceDecoder.TAG, (int)2)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Resizing from [");
                    stringBuilder.append(object.getWidth());
                    stringBuilder.append("x");
                    stringBuilder.append(object.getHeight());
                    stringBuilder.append("] to [");
                    stringBuilder.append(n3);
                    stringBuilder.append("x");
                    stringBuilder.append(n22);
                    stringBuilder.append("] scaleFactor: ");
                    stringBuilder.append(f);
                    Log.v((String)ImageDecoderResourceDecoder.TAG, (String)stringBuilder.toString());
                }
                imageDecoder.setTargetSize(n3, n22);
                if (Build.VERSION.SDK_INT >= 28) {
                    n22 = n4;
                    if (this.val$preferredColorSpace == PreferredColorSpace.DISPLAY_P3) {
                        n22 = n4;
                        if (imageInfo.getColorSpace() != null) {
                            n22 = n4;
                            if (imageInfo.getColorSpace().isWideGamut()) {
                                n22 = 1;
                            }
                        }
                    }
                    imageInfo = n22 != 0 ? ColorSpace.Named.DISPLAY_P3 : ColorSpace.Named.SRGB;
                    imageDecoder.setTargetColorSpace(ColorSpace.get((ColorSpace.Named)imageInfo));
                } else if (Build.VERSION.SDK_INT >= 26) {
                    imageDecoder.setTargetColorSpace(ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SRGB));
                }
            }
        });
    }

    @Override
    public final boolean handles(ImageDecoder.Source source, Options options) {
        return true;
    }
}

