/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.util.Log;
import java.io.File;

public final class HardwareConfigState {
    private static final File FD_SIZE_LIST = new File("/proc/self/fd");
    private static final int MAXIMUM_FDS_FOR_HARDWARE_CONFIGS_O = 700;
    private static final int MAXIMUM_FDS_FOR_HARDWARE_CONFIGS_P = 20000;
    private static final int MINIMUM_DECODES_BETWEEN_FD_CHECKS = 50;
    static final int MIN_HARDWARE_DIMENSION_O = 128;
    private static final int MIN_HARDWARE_DIMENSION_P = 0;
    private static volatile HardwareConfigState instance;
    private int decodesSinceLastFdCheck;
    private final int fdCountLimit;
    private boolean isFdSizeBelowHardwareLimit = true;
    private final boolean isHardwareConfigAllowedByDeviceModel = HardwareConfigState.isHardwareConfigAllowedByDeviceModel();
    private final int minHardwareDimension;

    HardwareConfigState() {
        if (Build.VERSION.SDK_INT >= 28) {
            this.fdCountLimit = 20000;
            this.minHardwareDimension = 0;
        } else {
            this.fdCountLimit = 700;
            this.minHardwareDimension = 128;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HardwareConfigState getInstance() {
        if (instance != null) return instance;
        synchronized (HardwareConfigState.class) {
            HardwareConfigState hardwareConfigState;
            if (instance != null) return instance;
            instance = hardwareConfigState = new HardwareConfigState();
            return instance;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFdSizeBelowHardwareLimit() {
        synchronized (this) {
            boolean bl;
            int n;
            block7: {
                n = this.decodesSinceLastFdCheck;
                bl = true;
                ++n;
                this.decodesSinceLastFdCheck = n;
                if (n < 50) return this.isFdSizeBelowHardwareLimit;
                this.decodesSinceLastFdCheck = 0;
                n = FD_SIZE_LIST.list().length;
                if (n < this.fdCountLimit) break block7;
                bl = false;
            }
            this.isFdSizeBelowHardwareLimit = bl;
            if (bl) return this.isFdSizeBelowHardwareLimit;
            if (!Log.isLoggable((String)"Downsampler", (int)5)) return this.isFdSizeBelowHardwareLimit;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Excluding HARDWARE bitmap config because we're over the file descriptor limit, file descriptors ");
            stringBuilder.append(n);
            stringBuilder.append(", limit ");
            stringBuilder.append(this.fdCountLimit);
            Log.w((String)"Downsampler", (String)stringBuilder.toString());
            return this.isFdSizeBelowHardwareLimit;
        }
    }

    private static boolean isHardwareConfigAllowedByDeviceModel() {
        boolean bl;
        String string2 = Build.MODEL;
        boolean bl2 = bl = true;
        if (string2 != null) {
            if (Build.MODEL.length() < 7) {
                bl2 = bl;
            } else {
                string2 = Build.MODEL.substring(0, 7);
                string2.hashCode();
                int n = -1;
                switch (string2.hashCode()) {
                    default: {
                        break;
                    }
                    case -1398222624: {
                        if (!string2.equals("SM-N935")) break;
                        n = 6;
                        break;
                    }
                    case -1398343746: {
                        if (!string2.equals("SM-J720")) break;
                        n = 5;
                        break;
                    }
                    case -1398431068: {
                        if (!string2.equals("SM-G965")) break;
                        n = 4;
                        break;
                    }
                    case -1398431073: {
                        if (!string2.equals("SM-G960")) break;
                        n = 3;
                        break;
                    }
                    case -1398431161: {
                        if (!string2.equals("SM-G935")) break;
                        n = 2;
                        break;
                    }
                    case -1398431166: {
                        if (!string2.equals("SM-G930")) break;
                        n = 1;
                        break;
                    }
                    case -1398613787: {
                        if (!string2.equals("SM-A520")) break;
                        n = 0;
                    }
                }
                switch (n) {
                    default: {
                        return true;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                }
                bl2 = Build.VERSION.SDK_INT != 26 ? bl : false;
            }
        }
        return bl2;
    }

    public boolean isHardwareConfigAllowed(int n, int n2, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = false;
        if (bl) {
            bl4 = bl3;
            if (this.isHardwareConfigAllowedByDeviceModel) {
                bl4 = bl3;
                if (Build.VERSION.SDK_INT >= 26) {
                    if (bl2) {
                        bl4 = bl3;
                    } else {
                        int n3 = this.minHardwareDimension;
                        bl4 = bl3;
                        if (n >= n3) {
                            bl4 = bl3;
                            if (n2 >= n3) {
                                bl4 = bl3;
                                if (this.isFdSizeBelowHardwareLimit()) {
                                    bl4 = true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return bl4;
    }

    boolean setHardwareConfigIfAllowed(int n, int n2, BitmapFactory.Options options, boolean bl, boolean bl2) {
        if (bl = this.isHardwareConfigAllowed(n, n2, bl, bl2)) {
            options.inPreferredConfig = Bitmap.Config.HARDWARE;
            options.inMutable = false;
        }
        return bl;
    }
}

