/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RecyclableBufferedInputStream
extends FilterInputStream {
    private volatile byte[] buf;
    private final ArrayPool byteArrayPool;
    private int count;
    private int marklimit;
    private int markpos = -1;
    private int pos;

    public RecyclableBufferedInputStream(InputStream inputStream, ArrayPool arrayPool) {
        this(inputStream, arrayPool, 65536);
    }

    RecyclableBufferedInputStream(InputStream inputStream, ArrayPool arrayPool, int n) {
        super(inputStream);
        this.byteArrayPool = arrayPool;
        this.buf = arrayPool.get(n, byte[].class);
    }

    private int fillbuf(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2;
        int n3 = this.markpos;
        if (n3 != -1 && (n2 = this.pos) - n3 < (n = this.marklimit)) {
            byte[] byArray2;
            if (n3 == 0 && n > byArray.length && this.count == byArray.length) {
                n2 = byArray.length * 2;
                if (n2 <= n) {
                    n = n2;
                }
                byArray2 = this.byteArrayPool.get(n, byte[].class);
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                this.buf = byArray2;
                this.byteArrayPool.put(byArray);
            } else {
                byArray2 = byArray;
                if (n3 > 0) {
                    System.arraycopy(byArray, n3, byArray, 0, byArray.length - n3);
                    byArray2 = byArray;
                }
            }
            this.pos = n = this.pos - this.markpos;
            this.markpos = 0;
            this.count = 0;
            n2 = inputStream.read(byArray2, n, byArray2.length - n);
            n = this.pos;
            if (n2 > 0) {
                n += n2;
            }
            this.count = n;
            return n2;
        }
        n = inputStream.read(byArray);
        if (n > 0) {
            this.markpos = -1;
            this.pos = 0;
            this.count = n;
        }
        return n;
    }

    private static IOException streamClosed() throws IOException {
        throw new IOException("BufferedInputStream is closed");
    }

    @Override
    public int available() throws IOException {
        synchronized (this) {
            block5: {
                InputStream inputStream = this.in;
                if (this.buf == null || inputStream == null) break block5;
                int n = this.count;
                int n2 = this.pos;
                int n3 = inputStream.available();
                return n - n2 + n3;
            }
            throw RecyclableBufferedInputStream.streamClosed();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.buf != null) {
            this.byteArrayPool.put(this.buf);
            this.buf = null;
        }
        InputStream inputStream = this.in;
        this.in = null;
        if (inputStream != null) {
            inputStream.close();
        }
    }

    public void fixMarkLimit() {
        synchronized (this) {
            this.marklimit = this.buf.length;
            return;
        }
    }

    @Override
    public void mark(int n) {
        synchronized (this) {
            this.marklimit = Math.max(this.marklimit, n);
            this.markpos = this.pos;
            return;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read() throws IOException {
        synchronized (this) {
            byte[] byArray = this.buf;
            Object object = this.in;
            if (byArray != null && object != null) {
                int n;
                if (this.pos >= this.count && (n = this.fillbuf((InputStream)object, byArray)) == -1) {
                    return -1;
                }
                object = byArray;
                if (byArray != this.buf && (object = (Object)this.buf) == null) {
                    throw RecyclableBufferedInputStream.streamClosed();
                }
                int n2 = this.count;
                int n3 = this.pos;
                if (n2 - n3 > 0) {
                    this.pos = n3 + 1;
                    Object object2 = object[n3];
                    return object2 & 0xFF;
                }
                return -1;
            }
            throw RecyclableBufferedInputStream.streamClosed();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        synchronized (this) {
            int n3;
            int n4;
            int n5;
            InputStream inputStream;
            int n6;
            byte[] byArray2;
            block24: {
                byArray2 = this.buf;
                if (byArray2 == null) {
                    throw RecyclableBufferedInputStream.streamClosed();
                }
                if (n6 == 0) {
                    return 0;
                }
                inputStream = this.in;
                if (inputStream == null) {
                    throw RecyclableBufferedInputStream.streamClosed();
                }
                n5 = this.pos;
                n4 = this.count;
                if (n5 < n4) {
                    n4 = n4 - n5 >= n6 ? n6 : (n4 -= n5);
                    System.arraycopy(byArray2, n5, byArray, n3, n4);
                    this.pos += n4;
                    if (n4 == n6) return n4;
                    n5 = inputStream.available();
                    if (n5 != 0) {
                        n5 = n3 + n4;
                        n3 = n6 - n4;
                        n4 = n5;
                        break block24;
                    } else {
                        return n4;
                    }
                }
                n5 = n6;
                n4 = n3;
                n3 = n5;
            }
            while (true) {
                byte[] byArray3;
                int n7 = this.markpos;
                n5 = -1;
                if (n7 == -1 && n3 >= byArray2.length) {
                    int n8 = inputStream.read(byArray, n4, n3);
                    byArray3 = byArray2;
                    n7 = n8;
                    if (n8 == -1) {
                        if (n3 != n6) return (int)(n6 - n3);
                        return n5;
                    }
                } else {
                    n7 = this.fillbuf(inputStream, byArray2);
                    if (n7 == -1) {
                        if (n3 != n6) return (int)(n6 - n3);
                        return n5;
                    }
                    byArray3 = byArray2;
                    if (byArray2 != this.buf && (byArray3 = this.buf) == null) {
                        throw RecyclableBufferedInputStream.streamClosed();
                    }
                    n5 = this.count;
                    n7 = this.pos;
                    n5 = n5 - n7 >= n3 ? n3 : (n5 -= n7);
                    System.arraycopy(byArray3, n7, byArray, n4, n5);
                    this.pos += n5;
                    n7 = n5;
                }
                if ((n3 -= n7) == 0) {
                    return n6;
                }
                n5 = inputStream.available();
                if (n5 == 0) {
                    return (int)(n6 - n3);
                }
                n4 += n7;
                byArray2 = byArray3;
            }
        }
    }

    public void release() {
        synchronized (this) {
            if (this.buf != null) {
                this.byteArrayPool.put(this.buf);
                this.buf = null;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void reset() throws IOException {
        synchronized (this) {
            if (this.buf == null) {
                IOException iOException = new IOException("Stream is closed");
                throw iOException;
            }
            int n = this.markpos;
            if (-1 != n) {
                this.pos = n;
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Mark has been invalidated, pos: ");
            stringBuilder.append(this.pos);
            stringBuilder.append(" markLimit: ");
            stringBuilder.append(this.marklimit);
            InvalidMarkException invalidMarkException = new InvalidMarkException(stringBuilder.toString());
            throw invalidMarkException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long skip(long l) throws IOException {
        synchronized (this) {
            block15: {
                long l2;
                InputStream inputStream;
                block16: {
                    int n;
                    int n2;
                    block17: {
                        if (l < 1L) {
                            return 0L;
                        }
                        byte[] byArray = this.buf;
                        if (byArray == null) throw RecyclableBufferedInputStream.streamClosed();
                        inputStream = this.in;
                        if (inputStream == null) break block15;
                        n2 = this.count;
                        n = this.pos;
                        if ((long)(n2 - n) >= l) {
                            this.pos = (int)((long)n + l);
                            return l;
                        }
                        l2 = (long)n2 - (long)n;
                        this.pos = n2;
                        if (this.markpos == -1 || l > (long)this.marklimit) break block16;
                        n2 = this.fillbuf(inputStream, byArray);
                        if (n2 != -1) break block17;
                        return l2;
                    }
                    n = this.count;
                    n2 = this.pos;
                    if ((long)(n - n2) >= l - l2) {
                        this.pos = (int)((long)n2 + l - l2);
                        return l;
                    }
                    long l3 = n;
                    l = n2;
                    this.pos = n;
                    return l2 + l3 - l;
                }
                l = inputStream.skip(l - l2);
                return l2 + l;
            }
            throw RecyclableBufferedInputStream.streamClosed();
        }
    }

    static class InvalidMarkException
    extends IOException {
        private static final long serialVersionUID = -4338378848813561757L;

        InvalidMarkException(String string2) {
            super(string2);
        }
    }
}

