/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.DrawableToBitmapConverter;
import com.bumptech.glide.load.resource.drawable.ResourceDrawableDecoder;

public class ResourceBitmapDecoder
implements ResourceDecoder<Uri, Bitmap> {
    private final BitmapPool bitmapPool;
    private final ResourceDrawableDecoder drawableDecoder;

    public ResourceBitmapDecoder(ResourceDrawableDecoder resourceDrawableDecoder, BitmapPool bitmapPool) {
        this.drawableDecoder = resourceDrawableDecoder;
        this.bitmapPool = bitmapPool;
    }

    @Override
    public Resource<Bitmap> decode(Uri object, int n, int n2, Options options) {
        if ((object = this.drawableDecoder.decode((Uri)object, n, n2, options)) == null) {
            return null;
        }
        object = (Drawable)object.get();
        return DrawableToBitmapConverter.convert(this.bitmapPool, (Drawable)object, n, n2);
    }

    @Override
    public boolean handles(Uri uri, Options options) {
        return "android.resource".equals(uri.getScheme());
    }
}

