/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.media.MediaDataSource;
import android.media.MediaMetadataRetriever;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.bumptech.glide.load.Option;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.bumptech.glide.load.resource.bitmap.DownsampleStrategy;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public class VideoDecoder<T>
implements ResourceDecoder<T, Bitmap> {
    private static final MediaMetadataRetrieverFactory DEFAULT_FACTORY;
    public static final long DEFAULT_FRAME = -1L;
    static final int DEFAULT_FRAME_OPTION = 2;
    public static final Option<Integer> FRAME_OPTION;
    private static final String TAG = "VideoDecoder";
    public static final Option<Long> TARGET_FRAME;
    private final BitmapPool bitmapPool;
    private final MediaMetadataRetrieverFactory factory;
    private final MediaMetadataRetrieverInitializer<T> initializer;

    static {
        TARGET_FRAME = Option.disk("com.bumptech.glide.load.resource.bitmap.VideoBitmapDecode.TargetFrame", -1L, new Option.CacheKeyUpdater<Long>(){
            private final ByteBuffer buffer = ByteBuffer.allocate(8);

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void update(byte[] object, Long l, MessageDigest messageDigest) {
                messageDigest.update((byte[])object);
                object = this.buffer;
                synchronized (object) {
                    this.buffer.position(0);
                    messageDigest.update(this.buffer.putLong(l).array());
                    return;
                }
            }
        });
        FRAME_OPTION = Option.disk("com.bumptech.glide.load.resource.bitmap.VideoBitmapDecode.FrameOption", 2, new Option.CacheKeyUpdater<Integer>(){
            private final ByteBuffer buffer = ByteBuffer.allocate(4);

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void update(byte[] object, Integer n, MessageDigest messageDigest) {
                if (n == null) {
                    return;
                }
                messageDigest.update((byte[])object);
                object = this.buffer;
                synchronized (object) {
                    this.buffer.position(0);
                    messageDigest.update(this.buffer.putInt(n).array());
                    return;
                }
            }
        });
        DEFAULT_FACTORY = new MediaMetadataRetrieverFactory();
    }

    VideoDecoder(BitmapPool bitmapPool, MediaMetadataRetrieverInitializer<T> mediaMetadataRetrieverInitializer) {
        this(bitmapPool, mediaMetadataRetrieverInitializer, DEFAULT_FACTORY);
    }

    VideoDecoder(BitmapPool bitmapPool, MediaMetadataRetrieverInitializer<T> mediaMetadataRetrieverInitializer, MediaMetadataRetrieverFactory mediaMetadataRetrieverFactory) {
        this.bitmapPool = bitmapPool;
        this.initializer = mediaMetadataRetrieverInitializer;
        this.factory = mediaMetadataRetrieverFactory;
    }

    public static ResourceDecoder<AssetFileDescriptor, Bitmap> asset(BitmapPool bitmapPool) {
        return new VideoDecoder<AssetFileDescriptor>(bitmapPool, new AssetFileDescriptorInitializer());
    }

    public static ResourceDecoder<ByteBuffer, Bitmap> byteBuffer(BitmapPool bitmapPool) {
        return new VideoDecoder<ByteBuffer>(bitmapPool, new ByteBufferInitializer());
    }

    private static Bitmap decodeFrame(MediaMetadataRetriever mediaMetadataRetriever, long l, int n, int n2, int n3, DownsampleStrategy downsampleStrategy) {
        downsampleStrategy = Build.VERSION.SDK_INT >= 27 && n2 != Integer.MIN_VALUE && n3 != Integer.MIN_VALUE && downsampleStrategy != DownsampleStrategy.NONE ? VideoDecoder.decodeScaledFrame(mediaMetadataRetriever, l, n, n2, n3, downsampleStrategy) : null;
        DownsampleStrategy downsampleStrategy2 = downsampleStrategy;
        if (downsampleStrategy == null) {
            downsampleStrategy2 = VideoDecoder.decodeOriginalFrame(mediaMetadataRetriever, l, n);
        }
        return downsampleStrategy2;
    }

    private static Bitmap decodeOriginalFrame(MediaMetadataRetriever mediaMetadataRetriever, long l, int n) {
        return mediaMetadataRetriever.getFrameAtTime(l, n);
    }

    private static Bitmap decodeScaledFrame(MediaMetadataRetriever mediaMetadataRetriever, long l, int n, int n2, int n3, DownsampleStrategy downsampleStrategy) {
        int n4;
        int n5;
        block5: {
            try {
                int n6 = Integer.parseInt(mediaMetadataRetriever.extractMetadata(18));
                int n7 = Integer.parseInt(mediaMetadataRetriever.extractMetadata(19));
                int n8 = Integer.parseInt(mediaMetadataRetriever.extractMetadata(24));
                if (n8 != 90) {
                    n5 = n6;
                    n4 = n7;
                    if (n8 != 270) break block5;
                }
                n4 = n6;
                n5 = n7;
            }
            catch (Throwable throwable) {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)"Exception trying to decode frame on oreo+", (Throwable)throwable);
                }
                return null;
            }
        }
        float f = downsampleStrategy.getScaleFactor(n5, n4, n2, n3);
        mediaMetadataRetriever = mediaMetadataRetriever.getScaledFrameAtTime(l, n, Math.round((float)n5 * f), Math.round(f * (float)n4));
        return mediaMetadataRetriever;
    }

    public static ResourceDecoder<ParcelFileDescriptor, Bitmap> parcel(BitmapPool bitmapPool) {
        return new VideoDecoder<ParcelFileDescriptor>(bitmapPool, new ParcelFileDescriptorInitializer());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Resource<Bitmap> decode(T object, int n, int n2, Options object2) throws IOException {
        Throwable throwable2222222;
        Object object3;
        block7: {
            long l = ((Options)object2).get(TARGET_FRAME);
            if (l < 0L && l != -1L) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Requested frame must be non-negative, or DEFAULT_FRAME, given: ");
                ((StringBuilder)object).append(l);
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            object3 = ((Options)object2).get(FRAME_OPTION);
            Integer n3 = object3;
            if (object3 == null) {
                n3 = 2;
            }
            object2 = object3 = ((Options)object2).get(DownsampleStrategy.OPTION);
            if (object3 == null) {
                object2 = DownsampleStrategy.DEFAULT;
            }
            object3 = this.factory.build();
            this.initializer.initialize((MediaMetadataRetriever)object3, object);
            object = VideoDecoder.decodeFrame((MediaMetadataRetriever)object3, l, n3, n, n2, (DownsampleStrategy)object2);
            {
                catch (Throwable throwable2222222) {
                    break block7;
                }
                catch (RuntimeException runtimeException) {}
                {
                    object2 = new IOException(runtimeException);
                    throw object2;
                }
            }
            object3.release();
            return BitmapResource.obtain((Bitmap)object, this.bitmapPool);
        }
        object3.release();
        throw throwable2222222;
    }

    @Override
    public boolean handles(T t, Options options) {
        return true;
    }

    private static final class AssetFileDescriptorInitializer
    implements MediaMetadataRetrieverInitializer<AssetFileDescriptor> {
        private AssetFileDescriptorInitializer() {
        }

        @Override
        public void initialize(MediaMetadataRetriever mediaMetadataRetriever, AssetFileDescriptor assetFileDescriptor) {
            mediaMetadataRetriever.setDataSource(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), assetFileDescriptor.getLength());
        }
    }

    static final class ByteBufferInitializer
    implements MediaMetadataRetrieverInitializer<ByteBuffer> {
        ByteBufferInitializer() {
        }

        @Override
        public void initialize(MediaMetadataRetriever mediaMetadataRetriever, final ByteBuffer byteBuffer) {
            mediaMetadataRetriever.setDataSource(new MediaDataSource(){

                public void close() {
                }

                public long getSize() {
                    return byteBuffer.limit();
                }

                public int readAt(long l, byte[] byArray, int n, int n2) {
                    if (l >= (long)byteBuffer.limit()) {
                        return -1;
                    }
                    byteBuffer.position((int)l);
                    n2 = Math.min(n2, byteBuffer.remaining());
                    byteBuffer.get(byArray, n, n2);
                    return n2;
                }
            });
        }
    }

    static class MediaMetadataRetrieverFactory {
        MediaMetadataRetrieverFactory() {
        }

        public MediaMetadataRetriever build() {
            return new MediaMetadataRetriever();
        }
    }

    static interface MediaMetadataRetrieverInitializer<T> {
        public void initialize(MediaMetadataRetriever var1, T var2);
    }

    static final class ParcelFileDescriptorInitializer
    implements MediaMetadataRetrieverInitializer<ParcelFileDescriptor> {
        ParcelFileDescriptorInitializer() {
        }

        @Override
        public void initialize(MediaMetadataRetriever mediaMetadataRetriever, ParcelFileDescriptor parcelFileDescriptor) {
            mediaMetadataRetriever.setDataSource(parcelFileDescriptor.getFileDescriptor());
        }
    }
}

