/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.manager;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.util.Log;
import com.bumptech.glide.manager.ConnectivityMonitor;
import com.bumptech.glide.util.Preconditions;

final class DefaultConnectivityMonitor
implements ConnectivityMonitor {
    private static final String TAG = "ConnectivityMonitor";
    private final BroadcastReceiver connectivityReceiver = new BroadcastReceiver(){

        public void onReceive(Context object, Intent object2) {
            boolean bl = DefaultConnectivityMonitor.this.isConnected;
            object2 = DefaultConnectivityMonitor.this;
            ((DefaultConnectivityMonitor)object2).isConnected = ((DefaultConnectivityMonitor)object2).isConnected((Context)object);
            if (bl != DefaultConnectivityMonitor.this.isConnected) {
                if (Log.isLoggable((String)DefaultConnectivityMonitor.TAG, (int)3)) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("connectivity changed, isConnected: ");
                    ((StringBuilder)object).append(DefaultConnectivityMonitor.this.isConnected);
                    Log.d((String)DefaultConnectivityMonitor.TAG, (String)((StringBuilder)object).toString());
                }
                DefaultConnectivityMonitor.this.listener.onConnectivityChanged(DefaultConnectivityMonitor.this.isConnected);
            }
        }
    };
    private final Context context;
    boolean isConnected;
    private boolean isRegistered;
    final ConnectivityMonitor.ConnectivityListener listener;

    DefaultConnectivityMonitor(Context context, ConnectivityMonitor.ConnectivityListener connectivityListener) {
        this.context = context.getApplicationContext();
        this.listener = connectivityListener;
    }

    private void register() {
        block3: {
            if (this.isRegistered) {
                return;
            }
            this.isConnected = this.isConnected(this.context);
            try {
                Context context = this.context;
                BroadcastReceiver broadcastReceiver = this.connectivityReceiver;
                IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
                context.registerReceiver(broadcastReceiver, intentFilter);
                this.isRegistered = true;
            }
            catch (SecurityException securityException) {
                if (!Log.isLoggable((String)TAG, (int)5)) break block3;
                Log.w((String)TAG, (String)"Failed to register", (Throwable)securityException);
            }
        }
    }

    private void unregister() {
        if (!this.isRegistered) {
            return;
        }
        this.context.unregisterReceiver(this.connectivityReceiver);
        this.isRegistered = false;
    }

    boolean isConnected(Context context) {
        context = Preconditions.checkNotNull((ConnectivityManager)context.getSystemService("connectivity"));
        boolean bl = true;
        try {
            context = context.getActiveNetworkInfo();
        }
        catch (RuntimeException runtimeException) {
            if (Log.isLoggable((String)TAG, (int)5)) {
                Log.w((String)TAG, (String)"Failed to determine connectivity status when connectivity changed", (Throwable)runtimeException);
            }
            return true;
        }
        if (context == null || !context.isConnected()) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void onDestroy() {
    }

    @Override
    public void onStart() {
        this.register();
    }

    @Override
    public void onStop() {
        this.unregister();
    }
}

