/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.signature;

import android.content.Context;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.signature.ApplicationVersionSignature;
import com.bumptech.glide.util.Util;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public final class AndroidResourceSignature
implements Key {
    private final Key applicationVersion;
    private final int nightMode;

    private AndroidResourceSignature(int n, Key key) {
        this.nightMode = n;
        this.applicationVersion = key;
    }

    public static Key obtain(Context context) {
        Key key = ApplicationVersionSignature.obtain(context);
        return new AndroidResourceSignature(context.getResources().getConfiguration().uiMode & 0x30, key);
    }

    @Override
    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = object instanceof AndroidResourceSignature;
        boolean bl3 = bl = false;
        if (bl2) {
            object = (AndroidResourceSignature)object;
            bl3 = bl;
            if (this.nightMode == ((AndroidResourceSignature)object).nightMode) {
                bl3 = bl;
                if (this.applicationVersion.equals(((AndroidResourceSignature)object).applicationVersion)) {
                    bl3 = true;
                }
            }
        }
        return bl3;
    }

    @Override
    public int hashCode() {
        return Util.hashCode(this.applicationVersion, this.nightMode);
    }

    @Override
    public void updateDiskCacheKey(MessageDigest messageDigest) {
        this.applicationVersion.updateDiskCacheKey(messageDigest);
        messageDigest.update(ByteBuffer.allocate(4).putInt(this.nightMode).array());
    }
}

