/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.concurrent.atomic.AtomicReference;

public final class ByteBufferUtil {
    private static final AtomicReference<byte[]> BUFFER_REF = new AtomicReference();
    private static final int BUFFER_SIZE = 16384;

    private ByteBufferUtil() {
    }

    /*
     * Unable to fully structure code
     */
    public static ByteBuffer fromFile(File var0) throws IOException {
        block22: {
            block20: {
                block21: {
                    var1_4 = null;
                    var2_5 = null;
                    var3_8 = var0.length();
                    if (var3_8 > 0x7FFFFFFFL) ** GOTO lbl32
                    if (var3_8 == 0L) break block20;
                    var5_9 = new RandomAccessFile((File)var0, "r");
                    var0 = var2_5;
                    var2_5 = var5_9.getChannel();
                    var0 = var2_5;
                    var1_4 = var2_5.map(FileChannel.MapMode.READ_ONLY, 0L, var3_8).load();
                    if (var2_5 == null) break block21;
                    var2_5.close();
                }
lbl19:
                // 2 sources

                while (true) {
                    var5_9.close();
lbl22:
                    // 2 sources

                    return var1_4;
                    break;
                }
                catch (Throwable var2_6) {
                    var1_4 = var0;
                    var0 = var2_6;
                }
                break block22;
            }
            try {
                var0 = new IOException("File unsuitable for memory mapping");
                throw var0;
lbl32:
                // 1 sources

                var0 = new IOException("File too large to map into memory");
                throw var0;
            }
            catch (Throwable var0_1) {
                var5_9 = null;
            }
        }
        if (var1_4 != null) {
            try {
                var1_4.close();
            }
            catch (IOException var2_7) {
                // empty catch block
            }
        }
        if (var5_9 != null) {
            var5_9.close();
        }
lbl46:
        // 4 sources

        throw var0;
        catch (IOException var0_2) {
            ** continue;
        }
        catch (IOException var0_3) {
            ** continue;
        }
        catch (IOException var5_10) {
            ** continue;
        }
    }

    public static ByteBuffer fromStream(InputStream object) throws IOException {
        int n;
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
        byte[] byArray2 = byArray = (byte[])BUFFER_REF.getAndSet(null);
        if (byArray == null) {
            byArray2 = new byte[16384];
        }
        while ((n = ((InputStream)object).read(byArray2)) >= 0) {
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        BUFFER_REF.set(byArray2);
        object = byteArrayOutputStream.toByteArray();
        return (ByteBuffer)ByteBuffer.allocateDirect(((Object)object).length).put((byte[])object).position(0);
    }

    private static SafeArray getSafeArray(ByteBuffer byteBuffer) {
        if (!byteBuffer.isReadOnly() && byteBuffer.hasArray()) {
            return new SafeArray(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
        }
        return null;
    }

    public static byte[] toBytes(ByteBuffer object) {
        Object object2 = ByteBufferUtil.getSafeArray((ByteBuffer)object);
        if (object2 != null && ((SafeArray)object2).offset == 0 && ((SafeArray)object2).limit == ((SafeArray)object2).data.length) {
            object = ((ByteBuffer)object).array();
        } else {
            object2 = ((ByteBuffer)object).asReadOnlyBuffer();
            object = new byte[((Buffer)object2).limit()];
            ((ByteBuffer)object2).position(0);
            ((ByteBuffer)object2).get((byte[])object);
        }
        return object;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void toFile(ByteBuffer byteBuffer, File object) throws IOException {
        RandomAccessFile randomAccessFile;
        block13: {
            void var0_3;
            Object object2;
            block14: {
                byteBuffer.position(0);
                object2 = null;
                Object var3_10 = null;
                randomAccessFile = new RandomAccessFile((File)object, "rw");
                object = var3_10;
                object = object2 = randomAccessFile.getChannel();
                ((FileChannel)object2).write(byteBuffer);
                object = object2;
                ((FileChannel)object2).force(false);
                object = object2;
                ((AbstractInterruptibleChannel)object2).close();
                object = object2;
                randomAccessFile.close();
                if (object2 == null) break block13;
                try {
                    ((AbstractInterruptibleChannel)object2).close();
                    break block13;
                }
                catch (IOException iOException) {}
                catch (Throwable throwable) {
                    object2 = object;
                    object = randomAccessFile;
                }
                break block14;
                catch (Throwable throwable) {
                    object = null;
                }
            }
            if (object2 != null) {
                try {
                    ((AbstractInterruptibleChannel)object2).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (object == null) throw var0_3;
            try {
                ((RandomAccessFile)object).close();
            }
            catch (IOException iOException) {
                throw var0_3;
            }
            throw var0_3;
        }
        try {
            randomAccessFile.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static InputStream toStream(ByteBuffer byteBuffer) {
        return new ByteBufferStream(byteBuffer);
    }

    public static void toStream(ByteBuffer byteBuffer, OutputStream outputStream) throws IOException {
        Object object = ByteBufferUtil.getSafeArray(byteBuffer);
        if (object != null) {
            outputStream.write(((SafeArray)object).data, ((SafeArray)object).offset, ((SafeArray)object).offset + ((SafeArray)object).limit);
        } else {
            byte[] byArray = BUFFER_REF.getAndSet(null);
            object = byArray;
            if (byArray == null) {
                object = new byte[16384];
            }
            while (byteBuffer.remaining() > 0) {
                int n = Math.min(byteBuffer.remaining(), ((Object)object).length);
                byteBuffer.get((byte[])object, 0, n);
                outputStream.write((byte[])object, 0, n);
            }
            BUFFER_REF.set((byte[])object);
        }
    }

    private static class ByteBufferStream
    extends InputStream {
        private static final int UNSET = -1;
        private final ByteBuffer byteBuffer;
        private int markPos = -1;

        ByteBufferStream(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
        }

        @Override
        public int available() {
            return this.byteBuffer.remaining();
        }

        @Override
        public void mark(int n) {
            synchronized (this) {
                this.markPos = this.byteBuffer.position();
                return;
            }
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public int read() {
            if (!this.byteBuffer.hasRemaining()) {
                return -1;
            }
            return this.byteBuffer.get() & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (!this.byteBuffer.hasRemaining()) {
                return -1;
            }
            n2 = Math.min(n2, this.available());
            this.byteBuffer.get(byArray, n, n2);
            return n2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void reset() throws IOException {
            synchronized (this) {
                int n = this.markPos;
                if (n != -1) {
                    this.byteBuffer.position(n);
                    return;
                }
                IOException iOException = new IOException("Cannot reset to unset mark position");
                throw iOException;
            }
        }

        @Override
        public long skip(long l) throws IOException {
            if (!this.byteBuffer.hasRemaining()) {
                return -1L;
            }
            l = Math.min(l, (long)this.available());
            ByteBuffer byteBuffer = this.byteBuffer;
            byteBuffer.position((int)((long)byteBuffer.position() + l));
            return l;
        }
    }

    static final class SafeArray {
        final byte[] data;
        final int limit;
        final int offset;

        SafeArray(byte[] byArray, int n, int n2) {
            this.data = byArray;
            this.offset = n;
            this.limit = n2;
        }
    }
}

