/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.ByteCollection;
import com.carrotsearch.hppc.ByteLookupContainer;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.predicates.BytePredicate;
import java.util.Arrays;
import java.util.Iterator;

abstract class AbstractByteCollection
implements ByteCollection {
    AbstractByteCollection() {
    }

    @Override
    public int removeAll(final ByteLookupContainer byteLookupContainer) {
        return this.removeAll(new BytePredicate(){

            @Override
            public boolean apply(byte by) {
                return byteLookupContainer.contains(by);
            }
        });
    }

    @Override
    public int retainAll(final ByteLookupContainer byteLookupContainer) {
        return this.removeAll(new BytePredicate(){

            @Override
            public boolean apply(byte by) {
                return byteLookupContainer.contains(by) ^ true;
            }
        });
    }

    @Override
    public int retainAll(final BytePredicate bytePredicate) {
        return this.removeAll(new BytePredicate(){

            @Override
            public boolean apply(byte by) {
                return bytePredicate.apply(by) ^ true;
            }
        });
    }

    @Override
    public byte[] toArray() {
        byte[] byArray = new byte[this.size()];
        Iterator<ByteCursor> iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            byArray[n] = iterator.next().value;
            ++n;
        }
        return byArray;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

