/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.CharCollection;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import java.util.Arrays;
import java.util.Iterator;

abstract class AbstractCharCollection
implements CharCollection {
    AbstractCharCollection() {
    }

    @Override
    public int removeAll(final CharLookupContainer charLookupContainer) {
        return this.removeAll(new CharPredicate(){

            @Override
            public boolean apply(char c) {
                return charLookupContainer.contains(c);
            }
        });
    }

    @Override
    public int retainAll(final CharLookupContainer charLookupContainer) {
        return this.removeAll(new CharPredicate(){

            @Override
            public boolean apply(char c) {
                return charLookupContainer.contains(c) ^ true;
            }
        });
    }

    @Override
    public int retainAll(final CharPredicate charPredicate) {
        return this.removeAll(new CharPredicate(){

            @Override
            public boolean apply(char c) {
                return charPredicate.apply(c) ^ true;
            }
        });
    }

    @Override
    public char[] toArray() {
        char[] cArray = new char[this.size()];
        Iterator<CharCursor> iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            cArray[n] = iterator.next().value;
            ++n;
        }
        return cArray;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

