/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.DoubleCollection;
import com.carrotsearch.hppc.DoubleLookupContainer;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import java.util.Arrays;
import java.util.Iterator;

abstract class AbstractDoubleCollection
implements DoubleCollection {
    AbstractDoubleCollection() {
    }

    @Override
    public int removeAll(final DoubleLookupContainer doubleLookupContainer) {
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double d) {
                return doubleLookupContainer.contains(d);
            }
        });
    }

    @Override
    public int retainAll(final DoubleLookupContainer doubleLookupContainer) {
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double d) {
                return doubleLookupContainer.contains(d) ^ true;
            }
        });
    }

    @Override
    public int retainAll(final DoublePredicate doublePredicate) {
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double d) {
                return doublePredicate.apply(d) ^ true;
            }
        });
    }

    @Override
    public double[] toArray() {
        double[] dArray = new double[this.size()];
        Iterator<DoubleCursor> iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            dArray[n] = iterator.next().value;
            ++n;
        }
        return dArray;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

