/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.FloatCollection;
import com.carrotsearch.hppc.FloatLookupContainer;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import java.util.Arrays;
import java.util.Iterator;

abstract class AbstractFloatCollection
implements FloatCollection {
    AbstractFloatCollection() {
    }

    @Override
    public int removeAll(final FloatLookupContainer floatLookupContainer) {
        return this.removeAll(new FloatPredicate(){

            @Override
            public boolean apply(float f) {
                return floatLookupContainer.contains(f);
            }
        });
    }

    @Override
    public int retainAll(final FloatLookupContainer floatLookupContainer) {
        return this.removeAll(new FloatPredicate(){

            @Override
            public boolean apply(float f) {
                return floatLookupContainer.contains(f) ^ true;
            }
        });
    }

    @Override
    public int retainAll(final FloatPredicate floatPredicate) {
        return this.removeAll(new FloatPredicate(){

            @Override
            public boolean apply(float f) {
                return floatPredicate.apply(f) ^ true;
            }
        });
    }

    @Override
    public float[] toArray() {
        float[] fArray = new float[this.size()];
        Iterator<FloatCursor> iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            fArray[n] = iterator.next().value;
            ++n;
        }
        return fArray;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

