/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.IntCollection;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.IntPredicate;
import java.util.Arrays;
import java.util.Iterator;

abstract class AbstractIntCollection
implements IntCollection {
    AbstractIntCollection() {
    }

    @Override
    public int removeAll(final IntLookupContainer intLookupContainer) {
        return this.removeAll(new IntPredicate(){

            @Override
            public boolean apply(int n) {
                return intLookupContainer.contains(n);
            }
        });
    }

    @Override
    public int retainAll(final IntLookupContainer intLookupContainer) {
        return this.removeAll(new IntPredicate(){

            @Override
            public boolean apply(int n) {
                return intLookupContainer.contains(n) ^ true;
            }
        });
    }

    @Override
    public int retainAll(final IntPredicate intPredicate) {
        return this.removeAll(new IntPredicate(){

            @Override
            public boolean apply(int n) {
                return intPredicate.apply(n) ^ true;
            }
        });
    }

    @Override
    public int[] toArray() {
        int[] nArray = new int[this.size()];
        Iterator<IntCursor> iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            nArray[n] = iterator.next().value;
            ++n;
        }
        return nArray;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

