/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.LongCollection;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.predicates.LongPredicate;
import java.util.Arrays;
import java.util.Iterator;

abstract class AbstractLongCollection
implements LongCollection {
    AbstractLongCollection() {
    }

    @Override
    public int removeAll(final LongLookupContainer longLookupContainer) {
        return this.removeAll(new LongPredicate(){

            @Override
            public boolean apply(long l) {
                return longLookupContainer.contains(l);
            }
        });
    }

    @Override
    public int retainAll(final LongLookupContainer longLookupContainer) {
        return this.removeAll(new LongPredicate(){

            @Override
            public boolean apply(long l) {
                return longLookupContainer.contains(l) ^ true;
            }
        });
    }

    @Override
    public int retainAll(final LongPredicate longPredicate) {
        return this.removeAll(new LongPredicate(){

            @Override
            public boolean apply(long l) {
                return longPredicate.apply(l) ^ true;
            }
        });
    }

    @Override
    public long[] toArray() {
        long[] lArray = new long[this.size()];
        Iterator<LongCursor> iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            lArray[n] = iterator.next().value;
            ++n;
        }
        return lArray;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

