/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.ObjectCollection;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;

abstract class AbstractObjectCollection<KType>
implements ObjectCollection<KType> {
    AbstractObjectCollection() {
    }

    protected boolean equals(Object object, Object object2) {
        boolean bl = object == object2 || object != null && object.equals(object2);
        return bl;
    }

    @Override
    public int removeAll(final ObjectLookupContainer<? super KType> objectLookupContainer) {
        return this.removeAll(new ObjectPredicate<KType>(){

            @Override
            public boolean apply(KType KType) {
                return objectLookupContainer.contains(KType);
            }
        });
    }

    @Override
    public int retainAll(final ObjectLookupContainer<? super KType> objectLookupContainer) {
        return this.removeAll(new ObjectPredicate<KType>(){

            @Override
            public boolean apply(KType KType) {
                return objectLookupContainer.contains(KType) ^ true;
            }
        });
    }

    @Override
    public int retainAll(final ObjectPredicate<? super KType> objectPredicate) {
        return this.removeAll(new ObjectPredicate<KType>(){

            @Override
            public boolean apply(KType KType) {
                return objectPredicate.apply(KType) ^ true;
            }
        });
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        Iterator iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = iterator.next().value;
            ++n;
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(Class<T> objectArray) {
        objectArray = (Object[])Array.newInstance(objectArray, this.size());
        Iterator iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = iterator.next().value;
            ++n;
        }
        return objectArray;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

