/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.ShortCollection;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import java.util.Arrays;
import java.util.Iterator;

abstract class AbstractShortCollection
implements ShortCollection {
    AbstractShortCollection() {
    }

    @Override
    public int removeAll(final ShortLookupContainer shortLookupContainer) {
        return this.removeAll(new ShortPredicate(){

            @Override
            public boolean apply(short s) {
                return shortLookupContainer.contains(s);
            }
        });
    }

    @Override
    public int retainAll(final ShortLookupContainer shortLookupContainer) {
        return this.removeAll(new ShortPredicate(){

            @Override
            public boolean apply(short s) {
                return shortLookupContainer.contains(s) ^ true;
            }
        });
    }

    @Override
    public int retainAll(final ShortPredicate shortPredicate) {
        return this.removeAll(new ShortPredicate(){

            @Override
            public boolean apply(short s) {
                return shortPredicate.apply(s) ^ true;
            }
        });
    }

    @Override
    public short[] toArray() {
        short[] sArray = new short[this.size()];
        Iterator<ShortCursor> iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            sArray[n] = iterator.next().value;
            ++n;
        }
        return sArray;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

