/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

public final class BitMixer {
    private static final int PHI_C32 = -1640531527;
    private static final long PHI_C64 = -7046029254386353131L;

    public static int mix(byte by) {
        return by * -1640531527;
    }

    public static int mix(byte by, int n) {
        return (by ^ n) * -1640531527;
    }

    public static int mix(char c) {
        return BitMixer.mixPhi(c);
    }

    public static int mix(char c, int n) {
        return BitMixer.mixPhi(c ^ n);
    }

    public static int mix(double d) {
        return (int)BitMixer.mix64(Double.doubleToLongBits(d));
    }

    public static int mix(double d, int n) {
        return (int)BitMixer.mix64(Double.doubleToLongBits(d) ^ (long)n);
    }

    public static int mix(float f) {
        return BitMixer.mix32(Float.floatToIntBits(f));
    }

    public static int mix(float f, int n) {
        return BitMixer.mix32(Float.floatToIntBits(f) ^ n);
    }

    public static int mix(int n) {
        return BitMixer.mix32(n);
    }

    public static int mix(int n, int n2) {
        return BitMixer.mix32(n ^ n2);
    }

    public static int mix(long l) {
        return (int)BitMixer.mix64(l);
    }

    public static int mix(long l, int n) {
        return (int)BitMixer.mix64(l ^ (long)n);
    }

    public static int mix(Object object) {
        int n = object == null ? 0 : BitMixer.mix32(object.hashCode());
        return n;
    }

    public static int mix(Object object, int n) {
        n = object == null ? 0 : BitMixer.mix32(object.hashCode() ^ n);
        return n;
    }

    public static int mix(short s) {
        return BitMixer.mixPhi(s);
    }

    public static int mix(short s, int n) {
        return BitMixer.mixPhi(s ^ n);
    }

    public static int mix32(int n) {
        n = (n ^ n >>> 16) * -2048144789;
        n = (n ^ n >>> 13) * -1028477387;
        return n ^ n >>> 16;
    }

    public static long mix64(long l) {
        l = (l ^ l >>> 32) * 5536775847593249645L;
        l = (l ^ l >>> 29) * -282946459933713943L;
        return l ^ l >>> 32;
    }

    public static int mixPhi(byte by) {
        by = (byte)(by * -1640531527);
        return by ^ by >>> 16;
    }

    public static int mixPhi(char c) {
        c = (char)(c * -1640531527);
        return c ^ c >>> 16;
    }

    public static int mixPhi(double d) {
        long l = Double.doubleToLongBits(d) * -7046029254386353131L;
        return (int)(l ^ l >>> 32);
    }

    public static int mixPhi(float f) {
        int n = Float.floatToIntBits(f) * -1640531527;
        return n ^ n >>> 16;
    }

    public static int mixPhi(int n) {
        return (n *= -1640531527) ^ n >>> 16;
    }

    public static int mixPhi(long l) {
        return (int)((l *= -7046029254386353131L) ^ l >>> 32);
    }

    public static int mixPhi(Object object) {
        int n = object == null ? 0 : object.hashCode() * -1640531527;
        return n ^ n >>> 16;
    }

    public static int mixPhi(short s) {
        s = (short)(s * -1640531527);
        return s ^ s >>> 16;
    }
}

