/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitSetIterator;
import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.IntProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BitSet
implements Cloneable {
    private static final long DEFAULT_NUM_BITS = 64L;
    public long[] bits;
    public int wlen;

    public BitSet() {
        this(64L);
    }

    public BitSet(long l) {
        long[] lArray = new long[BitSet.bits2words(l)];
        this.bits = lArray;
        this.wlen = lArray.length;
    }

    public BitSet(long[] lArray, int n) {
        this.bits = lArray;
        this.wlen = n;
    }

    public static long andNotCount(BitSet bitSet, BitSet bitSet2) {
        long l = BitUtil.pop_andnot(bitSet.bits, bitSet2.bits, 0, Math.min(bitSet.wlen, bitSet2.wlen));
        int n = bitSet.wlen;
        int n2 = bitSet2.wlen;
        long l2 = l;
        if (n > n2) {
            l2 = l + BitUtil.pop_array(bitSet.bits, n2, n - n2);
        }
        return l2;
    }

    public static int bits2words(long l) {
        return (int)((l - 1L >>> 6) + 1L);
    }

    public static int getNextSize(int n) {
        int n2 = n < 9 ? 3 : 6;
        return (n >> 3) + n2 + n;
    }

    public static long[] grow(long[] lArray, int n) {
        if (lArray.length < n) {
            long[] lArray2 = new long[BitSet.getNextSize(n)];
            System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
            return lArray2;
        }
        return lArray;
    }

    public static long intersectionCount(BitSet bitSet, BitSet bitSet2) {
        return BitUtil.pop_intersect(bitSet.bits, bitSet2.bits, 0, Math.min(bitSet.wlen, bitSet2.wlen));
    }

    public static BitSet newInstance() {
        return new BitSet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long unionCount(BitSet bitSet, BitSet bitSet2) {
        long l;
        long l2 = BitUtil.pop_union(bitSet.bits, bitSet2.bits, 0, Math.min(bitSet.wlen, bitSet2.wlen));
        int n = bitSet.wlen;
        int n2 = bitSet2.wlen;
        if (n < n2) {
            l = BitUtil.pop_array(bitSet2.bits, n, n2 - n);
            return l2 + l;
        }
        l = l2;
        if (n <= n2) return l;
        l = BitUtil.pop_array(bitSet.bits, n2, n - n2);
        return l2 + l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long xorCount(BitSet bitSet, BitSet bitSet2) {
        long l;
        long l2 = BitUtil.pop_xor(bitSet.bits, bitSet2.bits, 0, Math.min(bitSet.wlen, bitSet2.wlen));
        int n = bitSet.wlen;
        int n2 = bitSet2.wlen;
        if (n < n2) {
            l = BitUtil.pop_array(bitSet2.bits, n, n2 - n);
            return l2 + l;
        }
        l = l2;
        if (n <= n2) return l;
        l = BitUtil.pop_array(bitSet.bits, n2, n - n2);
        return l2 + l;
    }

    public void and(BitSet bitSet) {
        this.intersect(bitSet);
    }

    public void andNot(BitSet bitSet) {
        this.remove(bitSet);
    }

    public IntLookupContainer asIntLookupContainer() {
        return new IntLookupContainer(){

            private int getCurrentCardinality() {
                long l = BitSet.this.cardinality();
                if (l <= Integer.MAX_VALUE) {
                    return (int)l;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Bitset is larger than maximum positive integer: ");
                stringBuilder.append(l);
                throw new RuntimeException(stringBuilder.toString());
            }

            @Override
            public boolean contains(int n) {
                boolean bl = n < 0 || BitSet.this.get(n);
                return bl;
            }

            @Override
            public <T extends IntPredicate> T forEach(T t) {
                int n;
                BitSetIterator bitSetIterator = BitSet.this.iterator();
                while ((n = bitSetIterator.nextSetBit()) >= 0 && t.apply(n)) {
                }
                return t;
            }

            @Override
            public <T extends IntProcedure> T forEach(T t) {
                int n;
                BitSetIterator bitSetIterator = BitSet.this.iterator();
                while ((n = bitSetIterator.nextSetBit()) >= 0) {
                    t.apply(n);
                }
                return t;
            }

            @Override
            public boolean isEmpty() {
                return BitSet.this.isEmpty();
            }

            @Override
            public Iterator<IntCursor> iterator() {
                return new Iterator<IntCursor>(){
                    private final IntCursor cursor;
                    private long nextBitSet;
                    {
                        this.nextBitSet = BitSet.this.nextSetBit(0);
                        this.cursor = new IntCursor();
                    }

                    @Override
                    public boolean hasNext() {
                        boolean bl = this.nextBitSet >= 0L;
                        return bl;
                    }

                    @Override
                    public IntCursor next() {
                        long l = this.nextBitSet;
                        if (l >= 0L) {
                            if (l <= Integer.MAX_VALUE) {
                                int n;
                                this.nextBitSet = BitSet.this.nextSetBit(1L + l);
                                IntCursor intCursor = this.cursor;
                                intCursor.value = n = (int)l;
                                intCursor.index = n;
                                return this.cursor;
                            }
                            throw new RuntimeException("BitSet range larger than maximum positive integer.");
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return this.getCurrentCardinality();
            }

            @Override
            public int[] toArray() {
                int[] nArray = new int[this.getCurrentCardinality()];
                BitSetIterator bitSetIterator = BitSet.this.iterator();
                int n = bitSetIterator.nextSetBit();
                int n2 = 0;
                while (n >= 0) {
                    nArray[n2] = n;
                    n = bitSetIterator.nextSetBit();
                    ++n2;
                }
                return nArray;
            }
        };
    }

    public LongLookupContainer asLongLookupContainer() {
        return new LongLookupContainer(){

            private int getCurrentCardinality() {
                long l = BitSet.this.cardinality();
                if (l <= Integer.MAX_VALUE) {
                    return (int)l;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Bitset is larger than maximum positive integer: ");
                stringBuilder.append(l);
                throw new RuntimeException(stringBuilder.toString());
            }

            @Override
            public boolean contains(long l) {
                boolean bl = l < 0L || BitSet.this.get(l);
                return bl;
            }

            @Override
            public <T extends LongPredicate> T forEach(T t) {
                BitSet bitSet = BitSet.this;
                long l = bitSet.nextSetBit(0L);
                while (l >= 0L && t.apply(l)) {
                    l = bitSet.nextSetBit(l + 1L);
                }
                return t;
            }

            @Override
            public <T extends LongProcedure> T forEach(T t) {
                BitSet bitSet = BitSet.this;
                long l = bitSet.nextSetBit(0L);
                while (l >= 0L) {
                    t.apply(l);
                    l = bitSet.nextSetBit(l + 1L);
                }
                return t;
            }

            @Override
            public boolean isEmpty() {
                return BitSet.this.isEmpty();
            }

            @Override
            public Iterator<LongCursor> iterator() {
                return new Iterator<LongCursor>(){
                    private final LongCursor cursor;
                    private long nextBitSet;
                    {
                        this.nextBitSet = BitSet.this.nextSetBit(0);
                        this.cursor = new LongCursor();
                    }

                    @Override
                    public boolean hasNext() {
                        boolean bl = this.nextBitSet >= 0L;
                        return bl;
                    }

                    @Override
                    public LongCursor next() {
                        long l = this.nextBitSet;
                        if (l >= 0L) {
                            this.nextBitSet = BitSet.this.nextSetBit(1L + l);
                            this.cursor.index = (int)l;
                            this.cursor.value = l;
                            return this.cursor;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return this.getCurrentCardinality();
            }

            @Override
            public long[] toArray() {
                long[] lArray = new long[this.getCurrentCardinality()];
                BitSet bitSet = BitSet.this;
                long l = bitSet.nextSetBit(0L);
                int n = 0;
                while (l >= 0L) {
                    lArray[n] = l;
                    l = bitSet.nextSetBit(l + 1L);
                    ++n;
                }
                return lArray;
            }
        };
    }

    public long capacity() {
        return this.bits.length << 6;
    }

    public long cardinality() {
        return BitUtil.pop_array(this.bits, 0, this.wlen);
    }

    public void clear() {
        Arrays.fill(this.bits, 0L);
        this.wlen = 0;
    }

    public void clear(int n, int n2) {
        if (n2 <= n) {
            return;
        }
        int n3 = n >> 6;
        int n4 = this.wlen;
        if (n3 >= n4) {
            return;
        }
        int n5 = n2 - 1 >> 6;
        n2 = -n2;
        long l = -1L << n;
        long l2 = -1L >>> n2;
        if (n3 == n5) {
            long[] lArray = this.bits;
            lArray[n3] = (l2 | l) & lArray[n3];
            return;
        }
        long[] lArray = this.bits;
        lArray[n3] = l & lArray[n3];
        n = Math.min(n4, n5);
        Arrays.fill(this.bits, n3 + 1, n, 0L);
        if (n5 < this.wlen) {
            lArray = this.bits;
            lArray[n5] = l2 & lArray[n5];
        }
    }

    public void clear(long l) {
        int n = (int)(l >> 6);
        if (n >= this.wlen) {
            return;
        }
        int n2 = (int)l;
        long[] lArray = this.bits;
        lArray[n] = 1L << (n2 & 0x3F) & lArray[n];
    }

    public void clear(long l, long l2) {
        if (l2 <= l) {
            return;
        }
        int n = (int)(l >> 6);
        int n2 = this.wlen;
        if (n >= n2) {
            return;
        }
        int n3 = (int)(l2 - 1L >> 6);
        int n4 = (int)l;
        int n5 = (int)(-l2);
        l = -1L << n4;
        l2 = -1L >>> n5;
        if (n == n3) {
            long[] lArray = this.bits;
            lArray[n] = (l | l2) & lArray[n];
            return;
        }
        long[] lArray = this.bits;
        lArray[n] = l & lArray[n];
        n4 = Math.min(n2, n3);
        Arrays.fill(this.bits, n + 1, n4, 0L);
        if (n3 < this.wlen) {
            lArray = this.bits;
            lArray[n3] = lArray[n3] & l2;
        }
    }

    public Object clone() {
        try {
            BitSet bitSet = (BitSet)super.clone();
            bitSet.bits = (long[])bitSet.bits.clone();
            return bitSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public void ensureCapacity(long l) {
        this.ensureCapacityWords(BitSet.bits2words(l));
    }

    public void ensureCapacityWords(int n) {
        long[] lArray = this.bits;
        if (lArray.length < n) {
            this.bits = BitSet.grow(lArray, n);
        }
    }

    public boolean equals(Object object) {
        int n;
        int n2;
        Object object2;
        Object object3;
        if (this == object) {
            return true;
        }
        if (!(object instanceof BitSet)) {
            return false;
        }
        object = (BitSet)object;
        if (((BitSet)object).wlen > this.wlen) {
            object3 = this;
            object2 = object;
        } else {
            object2 = this;
            object3 = object;
        }
        for (n2 = ((BitSet)object2).wlen - 1; n2 >= (n = ((BitSet)object3).wlen); --n2) {
            if (((BitSet)object2).bits[n2] == 0L) continue;
            return false;
        }
        for (n2 = n - 1; n2 >= 0; --n2) {
            if (((BitSet)object2).bits[n2] == ((BitSet)object3).bits[n2]) continue;
            return false;
        }
        return true;
    }

    protected int expandingWordNum(long l) {
        int n = (int)(l >> 6);
        if (n >= this.wlen) {
            this.ensureCapacity(l + 1L);
            this.wlen = n + 1;
        }
        return n;
    }

    public void flip(long l) {
        int n = this.expandingWordNum(l);
        int n2 = (int)l;
        long[] lArray = this.bits;
        lArray[n] = 1L << (n2 & 0x3F) ^ lArray[n];
    }

    public void flip(long l, long l2) {
        if (l2 <= l) {
            return;
        }
        int n = (int)(l >> 6);
        int n2 = this.expandingWordNum(l2 - 1L);
        l = -1L << (int)l;
        l2 = -1L >>> (int)(-l2);
        if (n == n2) {
            long[] lArray = this.bits;
            lArray[n] = l & l2 ^ lArray[n];
            return;
        }
        long[] lArray = this.bits;
        lArray[n] = l ^ lArray[n];
        while (++n < n2) {
            lArray = this.bits;
            lArray[n] = lArray[n];
        }
        lArray = this.bits;
        lArray[n2] = lArray[n2] ^ l2;
    }

    public boolean flipAndGet(int n) {
        int n2 = n >> 6;
        long l = 1L << (n & 0x3F);
        long[] lArray = this.bits;
        lArray[n2] = lArray[n2] ^ l;
        boolean bl = (lArray[n2] & l) != 0L;
        return bl;
    }

    public boolean flipAndGet(long l) {
        int n = (int)(l >> 6);
        l = 1L << ((int)l & 0x3F);
        long[] lArray = this.bits;
        lArray[n] = lArray[n] ^ l;
        boolean bl = (l & lArray[n]) != 0L;
        return bl;
    }

    public boolean get(int n) {
        int n2 = n >> 6;
        long[] lArray = this.bits;
        int n3 = lArray.length;
        boolean bl = false;
        if (n2 >= n3) {
            return false;
        }
        if ((lArray[n2] & 1L << (n & 0x3F)) != 0L) {
            bl = true;
        }
        return bl;
    }

    public boolean get(long l) {
        int n = (int)(l >> 6);
        long[] lArray = this.bits;
        int n2 = lArray.length;
        boolean bl = false;
        if (n >= n2) {
            return false;
        }
        if ((1L << ((int)l & 0x3F) & lArray[n]) != 0L) {
            bl = true;
        }
        return bl;
    }

    public boolean getAndSet(int n) {
        long[] lArray = this.bits;
        int n2 = n >> 6;
        long l = 1L << (n & 0x3F);
        boolean bl = (lArray[n2] & l) != 0L;
        lArray[n2] = l | lArray[n2];
        return bl;
    }

    public boolean getAndSet(long l) {
        long[] lArray = this.bits;
        int n = (int)(l >> 6);
        boolean bl = (lArray[n] & (l = 1L << ((int)l & 0x3F))) != 0L;
        lArray[n] = l | lArray[n];
        return bl;
    }

    public int hashCode() {
        int n = this.bits.length;
        long l = 0L;
        while (--n >= 0) {
            l ^= this.bits[n];
            l = l >>> 63 | l << 1;
        }
        return (int)(l >> 32 ^ l) - 1737092556;
    }

    public void intersect(BitSet object) {
        int n = Math.min(this.wlen, ((BitSet)object).wlen);
        long[] lArray = this.bits;
        object = ((BitSet)object).bits;
        int n2 = n;
        while (--n2 >= 0) {
            lArray[n2] = lArray[n2] & object[n2];
        }
        n2 = this.wlen;
        if (n2 > n) {
            Arrays.fill(this.bits, n, n2, 0L);
        }
        this.wlen = n;
    }

    public boolean intersects(BitSet object) {
        int n;
        int n2 = Math.min(this.wlen, ((BitSet)object).wlen);
        long[] lArray = this.bits;
        object = ((BitSet)object).bits;
        while ((n = n2 - 1) >= 0) {
            n2 = n;
            if ((lArray[n] & object[n]) == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        boolean bl = this.cardinality() == 0L;
        return bl;
    }

    public BitSetIterator iterator() {
        return new BitSetIterator(this.bits, this.wlen);
    }

    public long length() {
        this.trimTrailingZeros();
        int n = this.wlen;
        if (n == 0) {
            return 0L;
        }
        return ((long)n - 1L << 6) + (long)(64 - Long.numberOfLeadingZeros(this.bits[n - 1]));
    }

    public int nextSetBit(int n) {
        int n2 = n >> 6;
        if (n2 >= this.wlen) {
            return -1;
        }
        int n3 = n & 0x3F;
        long l = this.bits[n2] >> n3;
        n = n2;
        if (l != 0L) {
            return (n2 << 6) + n3 + Long.numberOfTrailingZeros(l);
        }
        while ((n2 = n + 1) < this.wlen) {
            l = this.bits[n2];
            n = n2;
            if (l == 0L) continue;
            return (n2 << 6) + Long.numberOfTrailingZeros(l);
        }
        return -1;
    }

    public long nextSetBit(long l) {
        int n = (int)(l >>> 6);
        if (n >= this.wlen) {
            return -1L;
        }
        int n2 = (int)l & 0x3F;
        l = this.bits[n] >>> n2;
        int n3 = n;
        if (l != 0L) {
            return ((long)n << 6) + (long)(n2 + Long.numberOfTrailingZeros(l));
        }
        while ((n = n3 + 1) < this.wlen) {
            l = this.bits[n];
            n3 = n;
            if (l == 0L) continue;
            return ((long)n << 6) + (long)Long.numberOfTrailingZeros(l);
        }
        return -1L;
    }

    public void or(BitSet bitSet) {
        this.union(bitSet);
    }

    public void remove(BitSet object) {
        int n = Math.min(this.wlen, ((BitSet)object).wlen);
        long[] lArray = this.bits;
        object = ((BitSet)object).bits;
        while (--n >= 0) {
            lArray[n] = lArray[n] & object[n];
        }
    }

    public void set(long l) {
        int n = this.expandingWordNum(l);
        int n2 = (int)l;
        long[] lArray = this.bits;
        lArray[n] = 1L << (n2 & 0x3F) | lArray[n];
    }

    public void set(long l, long l2) {
        if (l2 <= l) {
            return;
        }
        int n = (int)(l >> 6);
        int n2 = this.expandingWordNum(l2 - 1L);
        l = -1L << (int)l;
        l2 = -1L >>> (int)(-l2);
        if (n == n2) {
            long[] lArray = this.bits;
            lArray[n] = l & l2 | lArray[n];
            return;
        }
        long[] lArray = this.bits;
        lArray[n] = l | lArray[n];
        Arrays.fill(lArray, n + 1, n2, -1L);
        lArray = this.bits;
        lArray[n2] = lArray[n2] | l2;
    }

    public long size() {
        return this.capacity();
    }

    public String toString() {
        long l = this.nextSetBit(0);
        if (l < 0L) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append(Long.toString(l));
        while ((l = this.nextSetBit(l + 1L)) >= 0L) {
            stringBuilder.append(", ");
            stringBuilder.append(Long.toString(l));
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public void trimTrailingZeros() {
        int n;
        for (n = this.wlen - 1; n >= 0 && this.bits[n] == 0L; --n) {
        }
        this.wlen = n + 1;
    }

    public void union(BitSet bitSet) {
        int n = Math.max(this.wlen, bitSet.wlen);
        this.ensureCapacityWords(n);
        long[] lArray = this.bits;
        long[] lArray2 = bitSet.bits;
        int n2 = Math.min(this.wlen, bitSet.wlen);
        while (--n2 >= 0) {
            lArray[n2] = lArray[n2] | lArray2[n2];
        }
        n2 = this.wlen;
        if (n2 < n) {
            System.arraycopy(lArray2, n2, lArray, n2, n - n2);
        }
        this.wlen = n;
    }

    public void xor(BitSet bitSet) {
        int n = Math.max(this.wlen, bitSet.wlen);
        this.ensureCapacityWords(n);
        long[] lArray = this.bits;
        long[] lArray2 = bitSet.bits;
        int n2 = Math.min(this.wlen, bitSet.wlen);
        while (--n2 >= 0) {
            lArray[n2] = lArray[n2] ^ lArray2[n2];
        }
        n2 = this.wlen;
        if (n2 < n) {
            System.arraycopy(lArray2, n2, lArray, n2, n - n2);
        }
        this.wlen = n;
    }
}

