/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractByteCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.ByteArrayList;
import com.carrotsearch.hppc.ByteContainer;
import com.carrotsearch.hppc.ByteDeque;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.predicates.BytePredicate;
import com.carrotsearch.hppc.procedures.ByteProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ByteArrayDeque
extends AbstractByteCollection
implements ByteDeque,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public byte[] buffer = ByteArrayList.EMPTY_ARRAY;
    public int head;
    protected final ArraySizingStrategy resizer;
    public int tail;

    public ByteArrayDeque() {
        this(4);
    }

    public ByteArrayDeque(int n) {
        this(n, new BoundedProportionalArraySizingStrategy());
    }

    public ByteArrayDeque(int n, ArraySizingStrategy arraySizingStrategy) {
        this.resizer = arraySizingStrategy;
        this.ensureCapacity(n);
    }

    public ByteArrayDeque(ByteContainer byteContainer) {
        this(byteContainer.size());
        this.addLast(byteContainer);
    }

    private void descendingForEach(BytePredicate bytePredicate, int n, int n2) {
        int n3;
        if (n == n2) {
            return;
        }
        byte[] byArray = this.buffer;
        while (bytePredicate.apply(byArray[n3 = ByteArrayDeque.oneLeft(n2, byArray.length)])) {
            n2 = n3;
            if (n3 != n) continue;
        }
    }

    private void descendingForEach(ByteProcedure byteProcedure, int n, int n2) {
        int n3;
        if (n == n2) {
            return;
        }
        byte[] byArray = this.buffer;
        do {
            n3 = ByteArrayDeque.oneLeft(n2, byArray.length);
            byteProcedure.apply(byArray[n3]);
            n2 = n3;
        } while (n3 != n);
    }

    private void forEach(ByteProcedure byteProcedure, int n, int n2) {
        byte[] byArray = this.buffer;
        while (n != n2) {
            byteProcedure.apply(byArray[n]);
            n = ByteArrayDeque.oneRight(n, byArray.length);
        }
    }

    public static ByteArrayDeque from(byte ... byArray) {
        ByteArrayDeque byteArrayDeque = new ByteArrayDeque(byArray.length);
        byteArrayDeque.addLast(byArray);
        return byteArrayDeque;
    }

    protected static int oneLeft(int n, int n2) {
        if (n >= 1) {
            return n - 1;
        }
        return n2 - 1;
    }

    protected static int oneRight(int n, int n2) {
        int n3;
        n = n3 = n + 1;
        if (n3 == n2) {
            n = 0;
        }
        return n;
    }

    public int addFirst(ByteContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.addFirst(((ByteCursor)object.next()).value);
        }
        return n;
    }

    public int addFirst(Iterable<? extends ByteCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.addFirst(((ByteCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void addFirst(byte by) {
        int n;
        int n2 = n = ByteArrayDeque.oneLeft(this.head, this.buffer.length);
        if (n == this.tail) {
            this.ensureBufferSpace(1);
            n2 = ByteArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        byte[] byArray = this.buffer;
        this.head = n2;
        byArray[n2] = by;
    }

    public final void addFirst(byte ... byArray) {
        this.ensureBufferSpace(byArray.length);
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            this.addFirst(byArray[i]);
        }
    }

    public int addLast(ByteContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.addLast(((ByteCursor)object.next()).value);
        }
        return n;
    }

    public int addLast(Iterable<? extends ByteCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.addLast(((ByteCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void addLast(byte by) {
        int n;
        int n2 = n = ByteArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == n) {
            this.ensureBufferSpace(1);
            n2 = ByteArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = by;
        this.tail = n2;
    }

    public final void addLast(byte ... byArray) {
        this.ensureBufferSpace(1);
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            this.addLast(byArray[i]);
        }
    }

    public int bufferIndexOf(byte by) {
        int n = this.tail;
        int n2 = this.buffer.length;
        int n3 = this.head;
        while (n3 != n) {
            if (this.buffer[n3] == by) {
                return n3;
            }
            n3 = ByteArrayDeque.oneRight(n3, n2);
        }
        return -1;
    }

    @Override
    public void clear() {
        int n = this.head;
        int n2 = this.tail;
        if (n < n2) {
            Arrays.fill(this.buffer, n, n2, (byte)0);
        } else {
            Arrays.fill(this.buffer, 0, n2, (byte)0);
            byte[] byArray = this.buffer;
            Arrays.fill(byArray, this.head, byArray.length, (byte)0);
        }
        this.tail = 0;
        this.head = 0;
    }

    public ByteArrayDeque clone() {
        try {
            ByteArrayDeque byteArrayDeque = (ByteArrayDeque)super.clone();
            byteArrayDeque.buffer = (byte[])this.buffer.clone();
            return byteArrayDeque;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(byte by) {
        int n = this.head;
        int n2 = this.tail;
        byte[] byArray = this.buffer;
        while (n != n2) {
            if (byArray[n] == by) {
                return true;
            }
            n = ByteArrayDeque.oneRight(n, byArray.length);
        }
        return false;
    }

    @Override
    public <T extends BytePredicate> T descendingForEach(T t) {
        this.descendingForEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public <T extends ByteProcedure> T descendingForEach(T t) {
        this.descendingForEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public Iterator<ByteCursor> descendingIterator() {
        return new DescendingValueIterator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void ensureBufferSpace(int n) {
        int n2 = this.buffer.length;
        int n3 = this.size();
        if (n3 + n < n2) return;
        n = this.resizer.grow(n2, n3 + 1, n);
        try {
            byte[] byArray = new byte[n];
            if (n2 > 0) {
                this.toArray(byArray);
                this.tail = n3;
                this.head = 0;
            }
            this.buffer = byArray;
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new BufferAllocationException("Not enough memory to allocate new buffers: %,d -> %,d", (Throwable)outOfMemoryError, n2, n);
        }
    }

    @Override
    public void ensureCapacity(int n) {
        this.ensureBufferSpace(n - this.size());
    }

    protected boolean equalElements(ByteArrayDeque object) {
        int n = this.size();
        int n2 = ((ByteArrayDeque)object).size();
        boolean bl = false;
        if (n2 != n) {
            return false;
        }
        Iterator<ByteCursor> iterator = this.iterator();
        object = ((ByteArrayDeque)object).iterator();
        while (iterator.hasNext() && object.hasNext()) {
            if (((ByteCursor)object.next()).value == iterator.next().value) continue;
            return false;
        }
        boolean bl2 = bl;
        if (!iterator.hasNext()) {
            bl2 = bl;
            if (!object.hasNext()) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ByteArrayDeque)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends BytePredicate> T forEach(T t) {
        int n = this.head;
        int n2 = this.tail;
        byte[] byArray = this.buffer;
        while (n != n2 && t.apply(byArray[n])) {
            n = ByteArrayDeque.oneRight(n, byArray.length);
        }
        return t;
    }

    @Override
    public <T extends ByteProcedure> T forEach(T t) {
        this.forEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public byte getFirst() {
        return this.buffer[this.head];
    }

    @Override
    public byte getLast() {
        byte[] byArray = this.buffer;
        return byArray[ByteArrayDeque.oneLeft(this.tail, byArray.length)];
    }

    public int hashCode() {
        int n = this.head;
        int n2 = this.tail;
        byte[] byArray = this.buffer;
        int n3 = 1;
        while (n != n2) {
            n3 = n3 * 31 + BitMixer.mix(this.buffer[n]);
            n = ByteArrayDeque.oneRight(n, byArray.length);
        }
        return n3;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<ByteCursor> iterator() {
        return new ValueIterator();
    }

    public int lastBufferIndexOf(byte by) {
        int n;
        int n2 = this.buffer.length;
        int n3 = ByteArrayDeque.oneLeft(this.head, n2);
        int n4 = this.tail;
        while ((n = ByteArrayDeque.oneLeft(n4, n2)) != n3) {
            n4 = n;
            if (this.buffer[n] != by) continue;
            return n;
        }
        return -1;
    }

    @Override
    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = ByteArrayList.EMPTY_ARRAY;
        this.ensureBufferSpace(0);
    }

    @Override
    public int removeAll(byte by) {
        int n;
        int n2 = this.tail;
        int n3 = this.buffer.length;
        int n4 = n = this.head;
        int n5 = 0;
        while (n != n2) {
            byte[] byArray = this.buffer;
            if (byArray[n] == by) {
                byArray[n] = (byte)0;
                ++n5;
            } else {
                if (n4 != n) {
                    byArray[n4] = byArray[n];
                    byArray[n] = (byte)0;
                }
                n4 = ByteArrayDeque.oneRight(n4, n3);
            }
            n = ByteArrayDeque.oneRight(n, n3);
        }
        this.tail = n4;
        return n5;
    }

    /*
     * Loose catch block
     */
    @Override
    public int removeAll(BytePredicate bytePredicate) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        byte[] byArray;
        block10: {
            int n6;
            byArray = this.buffer;
            n5 = this.tail;
            n4 = byArray.length;
            int n7 = n6 = this.head;
            n3 = 0;
            while (true) {
                n2 = n6;
                n = n7;
                if (n6 == n5) break block10;
                n2 = n7;
                if (!bytePredicate.apply(byArray[n6])) break block11;
                break;
            }
            catch (Throwable throwable) {
                while (n6 != n5) {
                    if (n2 != n6) {
                        byArray[n2] = byArray[n6];
                        byArray[n6] = (byte)0;
                    }
                    n2 = ByteArrayDeque.oneRight(n2, n4);
                    n6 = ByteArrayDeque.oneRight(n6, n4);
                }
                this.tail = n2;
                throw throwable;
            }
            {
                block12: {
                    block11: {
                        byArray[n6] = (byte)0;
                        ++n3;
                        break block12;
                    }
                    if (n7 != n6) {
                        byArray[n7] = byArray[n6];
                        byArray[n6] = (byte)0;
                    }
                    n2 = n7;
                    n7 = ByteArrayDeque.oneRight(n7, n4);
                }
                n2 = n7;
                n6 = n = ByteArrayDeque.oneRight(n6, n4);
                continue;
            }
        }
        while (n2 != n5) {
            if (n != n2) {
                byArray[n] = byArray[n2];
                byArray[n2] = (byte)0;
            }
            n = ByteArrayDeque.oneRight(n, n4);
            n2 = ByteArrayDeque.oneRight(n2, n4);
        }
        this.tail = n;
        return n3;
    }

    public void removeAtBufferIndex(int n) {
        int n2;
        byte[] byArray = this.buffer;
        int n3 = byArray.length;
        int n4 = n3 - 1;
        int n5 = this.head;
        int n6 = this.tail;
        int n7 = Math.abs(n - n5) % n3;
        if (n7 < (n2 = Math.abs(n6 - n) % n3)) {
            if (n >= n5) {
                System.arraycopy(byArray, n5, byArray, n5 + 1, n7);
            } else {
                System.arraycopy(byArray, 0, byArray, 1, n);
                byArray[0] = byArray[n4];
                System.arraycopy(byArray, n5, byArray, n5 + 1, n4 - n5);
            }
            byArray[n5] = (byte)0;
            this.head = ByteArrayDeque.oneRight(n5, n3);
        } else {
            if (n < n6) {
                System.arraycopy(byArray, n + 1, byArray, n, n2);
            } else {
                System.arraycopy(byArray, n + 1, byArray, n, n4 - n);
                byArray[n4] = byArray[0];
                System.arraycopy(byArray, 1, byArray, 0, n6);
            }
            byArray[n6] = (byte)0;
            this.tail = ByteArrayDeque.oneLeft(n6, n3);
        }
    }

    @Override
    public byte removeFirst() {
        byte[] byArray = this.buffer;
        int n = this.head;
        byte by = byArray[n];
        byArray[n] = (byte)0;
        this.head = ByteArrayDeque.oneRight(n, byArray.length);
        return by;
    }

    @Override
    public int removeFirst(byte by) {
        int n = this.bufferIndexOf(by);
        if (n >= 0) {
            this.removeAtBufferIndex(n);
        }
        return n;
    }

    @Override
    public byte removeLast() {
        int n;
        this.tail = n = ByteArrayDeque.oneLeft(this.tail, this.buffer.length);
        byte[] byArray = this.buffer;
        byte by = byArray[n];
        byArray[n] = (byte)0;
        return by;
    }

    @Override
    public int removeLast(byte by) {
        int n = this.lastBufferIndexOf(by);
        if (n >= 0) {
            this.removeAtBufferIndex(n);
        }
        return n;
    }

    @Override
    public int size() {
        int n = this.head;
        int n2 = this.tail;
        if (n <= n2) {
            return n2 - n;
        }
        return n2 - n + this.buffer.length;
    }

    @Override
    public byte[] toArray() {
        return this.toArray(new byte[this.size()]);
    }

    public byte[] toArray(byte[] byArray) {
        int n = this.head;
        int n2 = this.tail;
        if (n < n2) {
            System.arraycopy(this.buffer, n, byArray, 0, this.size());
        } else if (n > n2) {
            byte[] byArray2 = this.buffer;
            n2 = byArray2.length - n;
            System.arraycopy(byArray2, n, byArray, 0, n2);
            System.arraycopy(this.buffer, 0, byArray, n2, this.tail);
        }
        return byArray;
    }

    private final class DescendingValueIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor;
        private int remaining;

        public DescendingValueIterator() {
            ByteCursor byteCursor;
            this.cursor = byteCursor = new ByteCursor();
            byteCursor.index = ByteArrayDeque.this.tail;
            this.remaining = ByteArrayDeque.this.size();
        }

        @Override
        protected ByteCursor fetch() {
            int n = this.remaining;
            if (n == 0) {
                return (ByteCursor)this.done();
            }
            this.remaining = n - 1;
            ByteCursor byteCursor = this.cursor;
            byte[] byArray = ByteArrayDeque.this.buffer;
            ByteCursor byteCursor2 = this.cursor;
            byteCursor2.index = n = ByteArrayDeque.oneLeft(byteCursor2.index, ByteArrayDeque.this.buffer.length);
            byteCursor.value = byArray[n];
            return this.cursor;
        }
    }

    private final class ValueIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor;
        private int remaining;

        public ValueIterator() {
            ByteCursor byteCursor;
            this.cursor = byteCursor = new ByteCursor();
            byteCursor.index = ByteArrayDeque.oneLeft(ByteArrayDeque.this.head, ByteArrayDeque.this.buffer.length);
            this.remaining = ByteArrayDeque.this.size();
        }

        @Override
        protected ByteCursor fetch() {
            int n = this.remaining;
            if (n == 0) {
                return (ByteCursor)this.done();
            }
            this.remaining = n - 1;
            ByteCursor byteCursor = this.cursor;
            byte[] byArray = ByteArrayDeque.this.buffer;
            ByteCursor byteCursor2 = this.cursor;
            byteCursor2.index = n = ByteArrayDeque.oneRight(byteCursor2.index, ByteArrayDeque.this.buffer.length);
            byteCursor.value = byArray[n];
            return this.cursor;
        }
    }
}

