/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractByteCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.ByteContainer;
import com.carrotsearch.hppc.ByteIndexedContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.predicates.BytePredicate;
import com.carrotsearch.hppc.procedures.ByteProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ByteArrayList
extends AbstractByteCollection
implements ByteIndexedContainer,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public static final byte[] EMPTY_ARRAY = new byte[0];
    public byte[] buffer = EMPTY_ARRAY;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public ByteArrayList() {
        this(4);
    }

    public ByteArrayList(int n) {
        this(n, new BoundedProportionalArraySizingStrategy());
    }

    public ByteArrayList(int n, ArraySizingStrategy arraySizingStrategy) {
        this.resizer = arraySizingStrategy;
        this.ensureCapacity(n);
    }

    public ByteArrayList(ByteContainer byteContainer) {
        this(byteContainer.size());
        this.addAll(byteContainer);
    }

    public static ByteArrayList from(byte ... byArray) {
        ByteArrayList byteArrayList = new ByteArrayList(byArray.length);
        byteArrayList.add(byArray);
        return byteArrayList;
    }

    @Override
    public void add(byte by) {
        this.ensureBufferSpace(1);
        byte[] byArray = this.buffer;
        int n = this.elementsCount;
        this.elementsCount = n + 1;
        byArray[n] = by;
    }

    public void add(byte by, byte by2) {
        int n;
        this.ensureBufferSpace(2);
        byte[] byArray = this.buffer;
        int n2 = this.elementsCount;
        this.elementsCount = n = n2 + 1;
        byArray[n2] = by;
        this.elementsCount = n + 1;
        byArray[n] = by2;
    }

    public final void add(byte ... byArray) {
        this.add(byArray, 0, byArray.length);
    }

    public void add(byte[] byArray, int n, int n2) {
        this.ensureBufferSpace(n2);
        System.arraycopy(byArray, n, this.buffer, this.elementsCount, n2);
        this.elementsCount += n2;
    }

    public int addAll(ByteContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.add(((ByteCursor)object.next()).value);
        }
        return n;
    }

    public int addAll(Iterable<? extends ByteCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.add(((ByteCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, (byte)0);
        this.elementsCount = 0;
    }

    public ByteArrayList clone() {
        try {
            ByteArrayList byteArrayList = (ByteArrayList)super.clone();
            byteArrayList.buffer = (byte[])this.buffer.clone();
            return byteArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(byte by) {
        boolean bl = this.indexOf(by) >= 0;
        return bl;
    }

    protected void ensureBufferSpace(int n) {
        int n2 = this.elementsCount;
        byte[] byArray = this.buffer;
        int n3 = byArray == null ? 0 : byArray.length;
        if (n2 + n > n3) {
            n = this.resizer.grow(n3, n2, n);
            this.buffer = Arrays.copyOf(this.buffer, n);
        }
    }

    @Override
    public void ensureCapacity(int n) {
        byte[] byArray = this.buffer;
        int n2 = byArray == null ? 0 : byArray.length;
        if (n > n2) {
            this.ensureBufferSpace(n - this.size());
        }
    }

    protected boolean equalElements(ByteArrayList byteArrayList) {
        int n = this.size();
        if (byteArrayList.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byteArrayList.get(i) == this.get(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ByteArrayList)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends BytePredicate> T forEach(T t) {
        return this.forEach(t, 0, this.size());
    }

    public <T extends BytePredicate> T forEach(T t, int n, int n2) {
        byte[] byArray = this.buffer;
        while (n < n2 && t.apply(byArray[n])) {
            ++n;
        }
        return t;
    }

    @Override
    public <T extends ByteProcedure> T forEach(T t) {
        return this.forEach(t, 0, this.size());
    }

    public <T extends ByteProcedure> T forEach(T t, int n, int n2) {
        byte[] byArray = this.buffer;
        while (n < n2) {
            t.apply(byArray[n]);
            ++n;
        }
        return t;
    }

    @Override
    public byte get(int n) {
        return this.buffer[n];
    }

    public int hashCode() {
        int n = this.elementsCount;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + BitMixer.mix(this.buffer[i]);
        }
        return n2;
    }

    @Override
    public int indexOf(byte by) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (this.buffer[i] != by) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void insert(int n, byte by) {
        this.ensureBufferSpace(1);
        byte[] byArray = this.buffer;
        System.arraycopy(byArray, n, byArray, n + 1, this.elementsCount - n);
        this.buffer[n] = by;
        ++this.elementsCount;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.elementsCount == 0;
        return bl;
    }

    @Override
    public Iterator<ByteCursor> iterator() {
        return new ValueIterator(this.buffer, this.size());
    }

    @Override
    public int lastIndexOf(byte by) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (this.buffer[i] != by) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void release() {
        this.buffer = EMPTY_ARRAY;
        this.elementsCount = 0;
    }

    @Override
    public byte remove(int n) {
        byte[] byArray = this.buffer;
        byte by = byArray[n];
        int n2 = n + 1;
        int n3 = this.elementsCount;
        if (n2 < n3) {
            System.arraycopy(byArray, n2, byArray, n, n3 - n - 1);
        }
        this.elementsCount = n = this.elementsCount - 1;
        this.buffer[n] = (byte)0;
        return by;
    }

    @Override
    public int removeAll(byte by) {
        int n;
        int n2 = 0;
        for (int i = 0; i < (n = this.elementsCount); ++i) {
            byte[] byArray = this.buffer;
            if (byArray[i] == by) {
                byArray[i] = (byte)0;
                continue;
            }
            if (n2 != i) {
                byArray[n2] = byArray[i];
                byArray[i] = (byte)0;
            }
            ++n2;
        }
        this.elementsCount = n2;
        return n - n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int removeAll(BytePredicate bytePredicate) {
        int n;
        int n2;
        byte[] byArray = this.buffer;
        int n3 = this.elementsCount;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            block9: {
                n2 = ++n4;
                n = ++n5;
                if (n4 >= n3) break;
                try {
                    if (!bytePredicate.apply(byArray[n4])) break block9;
                }
                catch (Throwable throwable) {
                    while (true) {
                        if (n4 >= n3) {
                            this.elementsCount = n5;
                            throw throwable;
                        }
                        if (n5 != n4) {
                            byArray[n5] = byArray[n4];
                            byArray[n4] = (byte)0;
                        }
                        ++n5;
                        ++n4;
                    }
                }
                byArray[n4] = (byte)0;
                continue;
            }
            if (n5 == n4) continue;
            byArray[n5] = byArray[n4];
            byArray[n4] = (byte)0;
        }
        while (true) {
            if (n2 >= n3) {
                this.elementsCount = n;
                return n3 - n;
            }
            if (n != n2) {
                byArray[n] = byArray[n2];
                byArray[n2] = (byte)0;
            }
            ++n;
            ++n2;
        }
    }

    @Override
    public int removeFirst(byte by) {
        int n = this.indexOf(by);
        if (n >= 0) {
            this.remove(n);
        }
        return n;
    }

    @Override
    public int removeLast(byte by) {
        int n = this.lastIndexOf(by);
        if (n >= 0) {
            this.remove(n);
        }
        return n;
    }

    @Override
    public void removeRange(int n, int n2) {
        byte[] byArray = this.buffer;
        System.arraycopy(byArray, n2, byArray, n, this.elementsCount - n2);
        n = n2 - n;
        this.elementsCount = n2 = this.elementsCount - n;
        Arrays.fill(this.buffer, n2, n + n2, (byte)0);
    }

    public void resize(int n) {
        byte[] byArray = this.buffer;
        if (n <= byArray.length) {
            int n2 = this.elementsCount;
            if (n < n2) {
                Arrays.fill(byArray, n, n2, (byte)0);
            } else {
                Arrays.fill(byArray, n2, n, (byte)0);
            }
        } else {
            this.ensureCapacity(n);
        }
        this.elementsCount = n;
    }

    @Override
    public byte set(int n, byte by) {
        byte[] byArray = this.buffer;
        byte by2 = byArray[n];
        byArray[n] = by;
        return by2;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public byte[] toArray() {
        return Arrays.copyOf(this.buffer, this.elementsCount);
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    static final class ValueIterator
    extends AbstractIterator<ByteCursor> {
        private final byte[] buffer;
        private final ByteCursor cursor;
        private final int size;

        public ValueIterator(byte[] byArray, int n) {
            ByteCursor byteCursor;
            this.cursor = byteCursor = new ByteCursor();
            byteCursor.index = -1;
            this.size = n;
            this.buffer = byArray;
        }

        @Override
        protected ByteCursor fetch() {
            int n;
            if (this.cursor.index + 1 == this.size) {
                return (ByteCursor)this.done();
            }
            ByteCursor byteCursor = this.cursor;
            byte[] byArray = this.buffer;
            byteCursor.index = n = byteCursor.index + 1;
            byteCursor.value = byArray[n];
            return this.cursor;
        }
    }
}

