/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.CharArrayList;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharDeque;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.procedures.CharProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class CharArrayDeque
extends AbstractCharCollection
implements CharDeque,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public char[] buffer = CharArrayList.EMPTY_ARRAY;
    public int head;
    protected final ArraySizingStrategy resizer;
    public int tail;

    public CharArrayDeque() {
        this(4);
    }

    public CharArrayDeque(int n) {
        this(n, new BoundedProportionalArraySizingStrategy());
    }

    public CharArrayDeque(int n, ArraySizingStrategy arraySizingStrategy) {
        this.resizer = arraySizingStrategy;
        this.ensureCapacity(n);
    }

    public CharArrayDeque(CharContainer charContainer) {
        this(charContainer.size());
        this.addLast(charContainer);
    }

    private void descendingForEach(CharPredicate charPredicate, int n, int n2) {
        int n3;
        if (n == n2) {
            return;
        }
        char[] cArray = this.buffer;
        while (charPredicate.apply(cArray[n3 = CharArrayDeque.oneLeft(n2, cArray.length)])) {
            n2 = n3;
            if (n3 != n) continue;
        }
    }

    private void descendingForEach(CharProcedure charProcedure, int n, int n2) {
        int n3;
        if (n == n2) {
            return;
        }
        char[] cArray = this.buffer;
        do {
            n3 = CharArrayDeque.oneLeft(n2, cArray.length);
            charProcedure.apply(cArray[n3]);
            n2 = n3;
        } while (n3 != n);
    }

    private void forEach(CharProcedure charProcedure, int n, int n2) {
        char[] cArray = this.buffer;
        while (n != n2) {
            charProcedure.apply(cArray[n]);
            n = CharArrayDeque.oneRight(n, cArray.length);
        }
    }

    public static CharArrayDeque from(char ... cArray) {
        CharArrayDeque charArrayDeque = new CharArrayDeque(cArray.length);
        charArrayDeque.addLast(cArray);
        return charArrayDeque;
    }

    protected static int oneLeft(int n, int n2) {
        if (n >= 1) {
            return n - 1;
        }
        return n2 - 1;
    }

    protected static int oneRight(int n, int n2) {
        int n3;
        n = n3 = n + 1;
        if (n3 == n2) {
            n = 0;
        }
        return n;
    }

    public int addFirst(CharContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.addFirst(((CharCursor)object.next()).value);
        }
        return n;
    }

    public int addFirst(Iterable<? extends CharCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.addFirst(((CharCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void addFirst(char c) {
        int n;
        int n2 = n = CharArrayDeque.oneLeft(this.head, this.buffer.length);
        if (n == this.tail) {
            this.ensureBufferSpace(1);
            n2 = CharArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        char[] cArray = this.buffer;
        this.head = n2;
        cArray[n2] = c;
    }

    public final void addFirst(char ... cArray) {
        this.ensureBufferSpace(cArray.length);
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            this.addFirst(cArray[i]);
        }
    }

    public int addLast(CharContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.addLast(((CharCursor)object.next()).value);
        }
        return n;
    }

    public int addLast(Iterable<? extends CharCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.addLast(((CharCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void addLast(char c) {
        int n;
        int n2 = n = CharArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == n) {
            this.ensureBufferSpace(1);
            n2 = CharArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = c;
        this.tail = n2;
    }

    public final void addLast(char ... cArray) {
        this.ensureBufferSpace(1);
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            this.addLast(cArray[i]);
        }
    }

    public int bufferIndexOf(char c) {
        int n = this.tail;
        int n2 = this.buffer.length;
        int n3 = this.head;
        while (n3 != n) {
            if (this.buffer[n3] == c) {
                return n3;
            }
            n3 = CharArrayDeque.oneRight(n3, n2);
        }
        return -1;
    }

    @Override
    public void clear() {
        int n = this.head;
        int n2 = this.tail;
        if (n < n2) {
            Arrays.fill(this.buffer, n, n2, '\u0000');
        } else {
            Arrays.fill(this.buffer, 0, n2, '\u0000');
            char[] cArray = this.buffer;
            Arrays.fill(cArray, this.head, cArray.length, '\u0000');
        }
        this.tail = 0;
        this.head = 0;
    }

    public CharArrayDeque clone() {
        try {
            CharArrayDeque charArrayDeque = (CharArrayDeque)super.clone();
            charArrayDeque.buffer = (char[])this.buffer.clone();
            return charArrayDeque;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(char c) {
        int n = this.head;
        int n2 = this.tail;
        char[] cArray = this.buffer;
        while (n != n2) {
            if (cArray[n] == c) {
                return true;
            }
            n = CharArrayDeque.oneRight(n, cArray.length);
        }
        return false;
    }

    @Override
    public <T extends CharPredicate> T descendingForEach(T t) {
        this.descendingForEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public <T extends CharProcedure> T descendingForEach(T t) {
        this.descendingForEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public Iterator<CharCursor> descendingIterator() {
        return new DescendingValueIterator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void ensureBufferSpace(int n) {
        int n2 = this.buffer.length;
        int n3 = this.size();
        if (n3 + n < n2) return;
        n = this.resizer.grow(n2, n3 + 1, n);
        try {
            char[] cArray = new char[n];
            if (n2 > 0) {
                this.toArray(cArray);
                this.tail = n3;
                this.head = 0;
            }
            this.buffer = cArray;
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new BufferAllocationException("Not enough memory to allocate new buffers: %,d -> %,d", (Throwable)outOfMemoryError, n2, n);
        }
    }

    @Override
    public void ensureCapacity(int n) {
        this.ensureBufferSpace(n - this.size());
    }

    protected boolean equalElements(CharArrayDeque object) {
        int n = this.size();
        int n2 = ((CharArrayDeque)object).size();
        boolean bl = false;
        if (n2 != n) {
            return false;
        }
        Iterator<CharCursor> iterator = this.iterator();
        object = ((CharArrayDeque)object).iterator();
        while (iterator.hasNext() && object.hasNext()) {
            if (((CharCursor)object.next()).value == iterator.next().value) continue;
            return false;
        }
        boolean bl2 = bl;
        if (!iterator.hasNext()) {
            bl2 = bl;
            if (!object.hasNext()) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((CharArrayDeque)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends CharPredicate> T forEach(T t) {
        int n = this.head;
        int n2 = this.tail;
        char[] cArray = this.buffer;
        while (n != n2 && t.apply(cArray[n])) {
            n = CharArrayDeque.oneRight(n, cArray.length);
        }
        return t;
    }

    @Override
    public <T extends CharProcedure> T forEach(T t) {
        this.forEach(t, this.head, this.tail);
        return t;
    }

    @Override
    public char getFirst() {
        return this.buffer[this.head];
    }

    @Override
    public char getLast() {
        char[] cArray = this.buffer;
        return cArray[CharArrayDeque.oneLeft(this.tail, cArray.length)];
    }

    public int hashCode() {
        int n = this.head;
        int n2 = this.tail;
        char[] cArray = this.buffer;
        int n3 = 1;
        while (n != n2) {
            n3 = n3 * 31 + BitMixer.mix(this.buffer[n]);
            n = CharArrayDeque.oneRight(n, cArray.length);
        }
        return n3;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<CharCursor> iterator() {
        return new ValueIterator();
    }

    public int lastBufferIndexOf(char c) {
        int n;
        int n2 = this.buffer.length;
        int n3 = CharArrayDeque.oneLeft(this.head, n2);
        int n4 = this.tail;
        while ((n = CharArrayDeque.oneLeft(n4, n2)) != n3) {
            n4 = n;
            if (this.buffer[n] != c) continue;
            return n;
        }
        return -1;
    }

    @Override
    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = CharArrayList.EMPTY_ARRAY;
        this.ensureBufferSpace(0);
    }

    @Override
    public int removeAll(char c) {
        int n;
        int n2 = this.tail;
        int n3 = this.buffer.length;
        int n4 = n = this.head;
        int n5 = 0;
        while (n != n2) {
            char[] cArray = this.buffer;
            if (cArray[n] == c) {
                cArray[n] = (char)0;
                ++n5;
            } else {
                if (n4 != n) {
                    cArray[n4] = cArray[n];
                    cArray[n] = (char)0;
                }
                n4 = CharArrayDeque.oneRight(n4, n3);
            }
            n = CharArrayDeque.oneRight(n, n3);
        }
        this.tail = n4;
        return n5;
    }

    /*
     * Loose catch block
     */
    @Override
    public int removeAll(CharPredicate charPredicate) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        char[] cArray;
        block10: {
            int n6;
            cArray = this.buffer;
            n5 = this.tail;
            n4 = cArray.length;
            int n7 = n6 = this.head;
            n3 = 0;
            while (true) {
                n2 = n6;
                n = n7;
                if (n6 == n5) break block10;
                n2 = n7;
                if (!charPredicate.apply(cArray[n6])) break block11;
                break;
            }
            catch (Throwable throwable) {
                while (n6 != n5) {
                    if (n2 != n6) {
                        cArray[n2] = cArray[n6];
                        cArray[n6] = (char)0;
                    }
                    n2 = CharArrayDeque.oneRight(n2, n4);
                    n6 = CharArrayDeque.oneRight(n6, n4);
                }
                this.tail = n2;
                throw throwable;
            }
            {
                block12: {
                    block11: {
                        cArray[n6] = (char)0;
                        ++n3;
                        break block12;
                    }
                    if (n7 != n6) {
                        cArray[n7] = cArray[n6];
                        cArray[n6] = (char)0;
                    }
                    n2 = n7;
                    n7 = CharArrayDeque.oneRight(n7, n4);
                }
                n2 = n7;
                n6 = n = CharArrayDeque.oneRight(n6, n4);
                continue;
            }
        }
        while (n2 != n5) {
            if (n != n2) {
                cArray[n] = cArray[n2];
                cArray[n2] = (char)0;
            }
            n = CharArrayDeque.oneRight(n, n4);
            n2 = CharArrayDeque.oneRight(n2, n4);
        }
        this.tail = n;
        return n3;
    }

    public void removeAtBufferIndex(int n) {
        int n2;
        char[] cArray = this.buffer;
        int n3 = cArray.length;
        int n4 = n3 - 1;
        int n5 = this.head;
        int n6 = this.tail;
        int n7 = Math.abs(n - n5) % n3;
        if (n7 < (n2 = Math.abs(n6 - n) % n3)) {
            if (n >= n5) {
                System.arraycopy(cArray, n5, cArray, n5 + 1, n7);
            } else {
                System.arraycopy(cArray, 0, cArray, 1, n);
                cArray[0] = cArray[n4];
                System.arraycopy(cArray, n5, cArray, n5 + 1, n4 - n5);
            }
            cArray[n5] = (char)0;
            this.head = CharArrayDeque.oneRight(n5, n3);
        } else {
            if (n < n6) {
                System.arraycopy(cArray, n + 1, cArray, n, n2);
            } else {
                System.arraycopy(cArray, n + 1, cArray, n, n4 - n);
                cArray[n4] = cArray[0];
                System.arraycopy(cArray, 1, cArray, 0, n6);
            }
            cArray[n6] = (char)0;
            this.tail = CharArrayDeque.oneLeft(n6, n3);
        }
    }

    @Override
    public char removeFirst() {
        char[] cArray = this.buffer;
        int n = this.head;
        char c = cArray[n];
        cArray[n] = (char)0;
        this.head = CharArrayDeque.oneRight(n, cArray.length);
        return c;
    }

    @Override
    public int removeFirst(char c) {
        int n = this.bufferIndexOf(c);
        if (n >= 0) {
            this.removeAtBufferIndex(n);
        }
        return n;
    }

    @Override
    public char removeLast() {
        int n;
        this.tail = n = CharArrayDeque.oneLeft(this.tail, this.buffer.length);
        char[] cArray = this.buffer;
        char c = cArray[n];
        cArray[n] = (char)0;
        return c;
    }

    @Override
    public int removeLast(char c) {
        int n = this.lastBufferIndexOf(c);
        if (n >= 0) {
            this.removeAtBufferIndex(n);
        }
        return n;
    }

    @Override
    public int size() {
        int n = this.head;
        int n2 = this.tail;
        if (n <= n2) {
            return n2 - n;
        }
        return n2 - n + this.buffer.length;
    }

    @Override
    public char[] toArray() {
        return this.toArray(new char[this.size()]);
    }

    public char[] toArray(char[] cArray) {
        int n = this.head;
        int n2 = this.tail;
        if (n < n2) {
            System.arraycopy(this.buffer, n, cArray, 0, this.size());
        } else if (n > n2) {
            char[] cArray2 = this.buffer;
            n2 = cArray2.length - n;
            System.arraycopy(cArray2, n, cArray, 0, n2);
            System.arraycopy(this.buffer, 0, cArray, n2, this.tail);
        }
        return cArray;
    }

    private final class DescendingValueIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor;
        private int remaining;

        public DescendingValueIterator() {
            CharCursor charCursor;
            this.cursor = charCursor = new CharCursor();
            charCursor.index = CharArrayDeque.this.tail;
            this.remaining = CharArrayDeque.this.size();
        }

        @Override
        protected CharCursor fetch() {
            int n = this.remaining;
            if (n == 0) {
                return (CharCursor)this.done();
            }
            this.remaining = n - 1;
            CharCursor charCursor = this.cursor;
            char[] cArray = CharArrayDeque.this.buffer;
            CharCursor charCursor2 = this.cursor;
            charCursor2.index = n = CharArrayDeque.oneLeft(charCursor2.index, CharArrayDeque.this.buffer.length);
            charCursor.value = cArray[n];
            return this.cursor;
        }
    }

    private final class ValueIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor;
        private int remaining;

        public ValueIterator() {
            CharCursor charCursor;
            this.cursor = charCursor = new CharCursor();
            charCursor.index = CharArrayDeque.oneLeft(CharArrayDeque.this.head, CharArrayDeque.this.buffer.length);
            this.remaining = CharArrayDeque.this.size();
        }

        @Override
        protected CharCursor fetch() {
            int n = this.remaining;
            if (n == 0) {
                return (CharCursor)this.done();
            }
            this.remaining = n - 1;
            CharCursor charCursor = this.cursor;
            char[] cArray = CharArrayDeque.this.buffer;
            CharCursor charCursor2 = this.cursor;
            charCursor2.index = n = CharArrayDeque.oneRight(charCursor2.index, CharArrayDeque.this.buffer.length);
            charCursor.value = cArray[n];
            return this.cursor;
        }
    }
}

