/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharIndexedContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.procedures.CharProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class CharArrayList
extends AbstractCharCollection
implements CharIndexedContainer,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public static final char[] EMPTY_ARRAY = new char[0];
    public char[] buffer = EMPTY_ARRAY;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public CharArrayList() {
        this(4);
    }

    public CharArrayList(int n) {
        this(n, new BoundedProportionalArraySizingStrategy());
    }

    public CharArrayList(int n, ArraySizingStrategy arraySizingStrategy) {
        this.resizer = arraySizingStrategy;
        this.ensureCapacity(n);
    }

    public CharArrayList(CharContainer charContainer) {
        this(charContainer.size());
        this.addAll(charContainer);
    }

    public static CharArrayList from(char ... cArray) {
        CharArrayList charArrayList = new CharArrayList(cArray.length);
        charArrayList.add(cArray);
        return charArrayList;
    }

    @Override
    public void add(char c) {
        this.ensureBufferSpace(1);
        char[] cArray = this.buffer;
        int n = this.elementsCount;
        this.elementsCount = n + 1;
        cArray[n] = c;
    }

    public void add(char c, char c2) {
        int n;
        this.ensureBufferSpace(2);
        char[] cArray = this.buffer;
        int n2 = this.elementsCount;
        this.elementsCount = n = n2 + 1;
        cArray[n2] = c;
        this.elementsCount = n + 1;
        cArray[n] = c2;
    }

    public final void add(char ... cArray) {
        this.add(cArray, 0, cArray.length);
    }

    public void add(char[] cArray, int n, int n2) {
        this.ensureBufferSpace(n2);
        System.arraycopy(cArray, n, this.buffer, this.elementsCount, n2);
        this.elementsCount += n2;
    }

    public int addAll(CharContainer object) {
        int n = object.size();
        this.ensureBufferSpace(n);
        object = object.iterator();
        while (object.hasNext()) {
            this.add(((CharCursor)object.next()).value);
        }
        return n;
    }

    public int addAll(Iterable<? extends CharCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            this.add(((CharCursor)object.next()).value);
            ++n;
        }
        return n;
    }

    @Override
    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, '\u0000');
        this.elementsCount = 0;
    }

    public CharArrayList clone() {
        try {
            CharArrayList charArrayList = (CharArrayList)super.clone();
            charArrayList.buffer = (char[])this.buffer.clone();
            return charArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(char c) {
        boolean bl = this.indexOf(c) >= 0;
        return bl;
    }

    protected void ensureBufferSpace(int n) {
        int n2 = this.elementsCount;
        char[] cArray = this.buffer;
        int n3 = cArray == null ? 0 : cArray.length;
        if (n2 + n > n3) {
            n = this.resizer.grow(n3, n2, n);
            this.buffer = Arrays.copyOf(this.buffer, n);
        }
    }

    @Override
    public void ensureCapacity(int n) {
        char[] cArray = this.buffer;
        int n2 = cArray == null ? 0 : cArray.length;
        if (n > n2) {
            this.ensureBufferSpace(n - this.size());
        }
    }

    protected boolean equalElements(CharArrayList charArrayList) {
        int n = this.size();
        if (charArrayList.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (charArrayList.get(i) == this.get(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((CharArrayList)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends CharPredicate> T forEach(T t) {
        return this.forEach(t, 0, this.size());
    }

    public <T extends CharPredicate> T forEach(T t, int n, int n2) {
        char[] cArray = this.buffer;
        while (n < n2 && t.apply(cArray[n])) {
            ++n;
        }
        return t;
    }

    @Override
    public <T extends CharProcedure> T forEach(T t) {
        return this.forEach(t, 0, this.size());
    }

    public <T extends CharProcedure> T forEach(T t, int n, int n2) {
        char[] cArray = this.buffer;
        while (n < n2) {
            t.apply(cArray[n]);
            ++n;
        }
        return t;
    }

    @Override
    public char get(int n) {
        return this.buffer[n];
    }

    public int hashCode() {
        int n = this.elementsCount;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + BitMixer.mix(this.buffer[i]);
        }
        return n2;
    }

    @Override
    public int indexOf(char c) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (this.buffer[i] != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void insert(int n, char c) {
        this.ensureBufferSpace(1);
        char[] cArray = this.buffer;
        System.arraycopy(cArray, n, cArray, n + 1, this.elementsCount - n);
        this.buffer[n] = c;
        ++this.elementsCount;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.elementsCount == 0;
        return bl;
    }

    @Override
    public Iterator<CharCursor> iterator() {
        return new ValueIterator(this.buffer, this.size());
    }

    @Override
    public int lastIndexOf(char c) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (this.buffer[i] != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void release() {
        this.buffer = EMPTY_ARRAY;
        this.elementsCount = 0;
    }

    @Override
    public char remove(int n) {
        char[] cArray = this.buffer;
        char c = cArray[n];
        int n2 = n + 1;
        int n3 = this.elementsCount;
        if (n2 < n3) {
            System.arraycopy(cArray, n2, cArray, n, n3 - n - 1);
        }
        this.elementsCount = n = this.elementsCount - 1;
        this.buffer[n] = (char)0;
        return c;
    }

    @Override
    public int removeAll(char c) {
        int n;
        int n2 = 0;
        for (int i = 0; i < (n = this.elementsCount); ++i) {
            char[] cArray = this.buffer;
            if (cArray[i] == c) {
                cArray[i] = (char)0;
                continue;
            }
            if (n2 != i) {
                cArray[n2] = cArray[i];
                cArray[i] = (char)0;
            }
            ++n2;
        }
        this.elementsCount = n2;
        return n - n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int removeAll(CharPredicate charPredicate) {
        int n;
        int n2;
        char[] cArray = this.buffer;
        int n3 = this.elementsCount;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            block9: {
                n2 = ++n4;
                n = ++n5;
                if (n4 >= n3) break;
                try {
                    if (!charPredicate.apply(cArray[n4])) break block9;
                }
                catch (Throwable throwable) {
                    while (true) {
                        if (n4 >= n3) {
                            this.elementsCount = n5;
                            throw throwable;
                        }
                        if (n5 != n4) {
                            cArray[n5] = cArray[n4];
                            cArray[n4] = (char)0;
                        }
                        ++n5;
                        ++n4;
                    }
                }
                cArray[n4] = (char)0;
                continue;
            }
            if (n5 == n4) continue;
            cArray[n5] = cArray[n4];
            cArray[n4] = (char)0;
        }
        while (true) {
            if (n2 >= n3) {
                this.elementsCount = n;
                return n3 - n;
            }
            if (n != n2) {
                cArray[n] = cArray[n2];
                cArray[n2] = (char)0;
            }
            ++n;
            ++n2;
        }
    }

    @Override
    public int removeFirst(char c) {
        int n = this.indexOf(c);
        if (n >= 0) {
            this.remove(n);
        }
        return n;
    }

    @Override
    public int removeLast(char c) {
        int n = this.lastIndexOf(c);
        if (n >= 0) {
            this.remove(n);
        }
        return n;
    }

    @Override
    public void removeRange(int n, int n2) {
        char[] cArray = this.buffer;
        System.arraycopy(cArray, n2, cArray, n, this.elementsCount - n2);
        n = n2 - n;
        this.elementsCount = n2 = this.elementsCount - n;
        Arrays.fill(this.buffer, n2, n + n2, '\u0000');
    }

    public void resize(int n) {
        char[] cArray = this.buffer;
        if (n <= cArray.length) {
            int n2 = this.elementsCount;
            if (n < n2) {
                Arrays.fill(cArray, n, n2, '\u0000');
            } else {
                Arrays.fill(cArray, n2, n, '\u0000');
            }
        } else {
            this.ensureCapacity(n);
        }
        this.elementsCount = n;
    }

    @Override
    public char set(int n, char c) {
        char[] cArray = this.buffer;
        char c2 = cArray[n];
        cArray[n] = c;
        return c2;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public char[] toArray() {
        return Arrays.copyOf(this.buffer, this.elementsCount);
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    static final class ValueIterator
    extends AbstractIterator<CharCursor> {
        private final char[] buffer;
        private final CharCursor cursor;
        private final int size;

        public ValueIterator(char[] cArray, int n) {
            CharCursor charCursor;
            this.cursor = charCursor = new CharCursor();
            charCursor.index = -1;
            this.size = n;
            this.buffer = cArray;
        }

        @Override
        protected CharCursor fetch() {
            int n;
            if (this.cursor.index + 1 == this.size) {
                return (CharCursor)this.done();
            }
            CharCursor charCursor = this.cursor;
            char[] cArray = this.buffer;
            charCursor.index = n = charCursor.index + 1;
            charCursor.value = cArray[n];
            return this.cursor;
        }
    }
}

