/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractByteCollection;
import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.ByteCollection;
import com.carrotsearch.hppc.CharBufferVisualizer;
import com.carrotsearch.hppc.CharByteAssociativeContainer;
import com.carrotsearch.hppc.CharByteMap;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.cursors.CharByteCursor;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.predicates.BytePredicate;
import com.carrotsearch.hppc.predicates.CharBytePredicate;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.procedures.ByteProcedure;
import com.carrotsearch.hppc.procedures.CharByteProcedure;
import com.carrotsearch.hppc.procedures.CharProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class CharByteHashMap
implements CharByteMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public char[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public byte[] values;

    public CharByteHashMap() {
        this(4);
    }

    public CharByteHashMap(int n) {
        this(n, 0.75);
    }

    public CharByteHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public CharByteHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public CharByteHashMap(CharByteAssociativeContainer charByteAssociativeContainer) {
        this(charByteAssociativeContainer.size());
        this.putAll(charByteAssociativeContainer);
    }

    public static CharByteHashMap from(char[] cArray, byte[] byArray) {
        if (cArray.length == byArray.length) {
            CharByteHashMap charByteHashMap = new CharByteHashMap(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                charByteHashMap.put(cArray[i], byArray[i]);
            }
            return charByteHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public byte addTo(char c, byte by) {
        return this.putOrAdd(c, by, by);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        char[] cArray = this.keys;
        byte[] byArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new char[n3];
            this.values = new byte[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = cArray;
            this.values = byArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, char c, byte by) {
        char[] cArray = this.keys;
        byte[] byArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        cArray[n] = c;
        byArray[n] = by;
        this.rehash(cArray, byArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, '\u0000');
    }

    public CharByteHashMap clone() {
        try {
            CharByteHashMap charByteHashMap = (CharByteHashMap)super.clone();
            charByteHashMap.keys = (char[])this.keys.clone();
            charByteHashMap.values = (byte[])this.values.clone();
            charByteHashMap.hasEmptyKey = charByteHashMap.hasEmptyKey;
            charByteHashMap.orderMixer = this.orderMixer.clone();
            return charByteHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(char c) {
        char c2;
        if (c == '\u0000') {
            return this.hasEmptyKey;
        }
        char[] cArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(c);
        while ((c2 = cArray[n2 &= n]) != '\u0000') {
            if (c2 == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            char[] cArray = this.keys;
            byte[] byArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (cArray != null && !this.isEmpty()) {
                this.rehash(cArray, byArray);
            }
        }
    }

    protected boolean equalElements(CharByteHashMap object) {
        if (((CharByteHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((CharByteHashMap)object).iterator();
        while (object.hasNext()) {
            CharByteCursor charByteCursor = (CharByteCursor)object.next();
            char c = charByteCursor.key;
            if (this.containsKey(c) && this.get(c) == charByteCursor.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((CharByteHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends CharBytePredicate> T forEach(T t) {
        char[] cArray = this.keys;
        byte[] byArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply('\u0000', byArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (cArray[i] == '\u0000' || t.apply(cArray[i], byArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends CharByteProcedure> T forEach(T t) {
        char[] cArray = this.keys;
        byte[] byArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply('\u0000', byArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (cArray[n] != '\u0000') {
                t.apply(cArray[n], byArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public byte get(char c) {
        char c2;
        int n = 0;
        if (c == '\u0000') {
            int n2 = n;
            if (this.hasEmptyKey) {
                n2 = n = this.values[this.mask + 1];
            }
            return (byte)n2;
        }
        char[] cArray = this.keys;
        int n3 = this.mask;
        n = this.hashKey(c);
        while ((c2 = cArray[n &= n3]) != '\u0000') {
            if (c2 == c) {
                return this.values[n];
            }
            ++n;
        }
        return 0;
    }

    @Override
    public byte getOrDefault(char c, byte by) {
        char c2;
        if (c == '\u0000') {
            if (this.hasEmptyKey) {
                byte by2;
                by = by2 = this.values[this.mask + 1];
            }
            return by;
        }
        char[] cArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(c);
        while ((c2 = cArray[n2 &= n]) != '\u0000') {
            if (c2 == c) {
                return this.values[n2];
            }
            ++n2;
        }
        return by;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (CharByteCursor charByteCursor : this) {
            n += BitMixer.mix(charByteCursor.key) + BitMixer.mix(charByteCursor.value);
        }
        return n;
    }

    protected int hashKey(char c) {
        return BitMixer.mix(c, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public byte indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, char c, byte by) {
        if (c == '\u0000') {
            this.values[n] = by;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, c, by);
            } else {
                this.keys[n] = c;
                this.values[n] = by;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(char c) {
        int n;
        int n2 = this.mask;
        if (c == '\u0000') {
            boolean bl = this.hasEmptyKey;
            int n3 = n2 + 1;
            if (!bl) {
                // empty if block
            }
            return n3;
        }
        char[] cArray = this.keys;
        int n4 = this.hashKey(c);
        while ((n4 = cArray[n = n4 & n2]) != 0) {
            if (n4 == c) {
                return n;
            }
            n4 = n + 1;
        }
        return n;
    }

    @Override
    public byte indexReplace(int n, byte by) {
        byte[] byArray = this.values;
        byte by2 = byArray[n];
        byArray[n] = by;
        return by2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<CharByteCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public byte put(char c, byte by) {
        int n;
        int n2 = this.mask;
        if (c == '\u0000') {
            this.hasEmptyKey = true;
            byte[] byArray = this.values;
            int n3 = n2 + 1;
            byte by2 = byArray[n3];
            byArray[n3] = by;
            return by2;
        }
        Object[] objectArray = this.keys;
        int n4 = this.hashKey(c);
        while ((n4 = objectArray[n = n4 & n2]) != 0) {
            if (n4 == c) {
                objectArray = this.values;
                byte by3 = objectArray[n];
                objectArray[n] = (char)by;
                return by3;
            }
            n4 = n + 1;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n, c, by);
        } else {
            objectArray[n] = c;
            this.values[n] = by;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(CharByteAssociativeContainer object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            CharByteCursor charByteCursor = (CharByteCursor)object.next();
            this.put(charByteCursor.key, charByteCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends CharByteCursor> object) {
        int n = this.size();
        Iterator<? extends CharByteCursor> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((CharByteCursor)object).key, ((CharByteCursor)object).value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(char c, byte by) {
        int n = this.indexOf(c);
        if (!this.indexExists(n)) {
            this.indexInsert(n, c, by);
            return true;
        }
        return false;
    }

    @Override
    public byte putOrAdd(char c, byte by, byte by2) {
        int n = this.indexOf(c);
        if (this.indexExists(n)) {
            by = (byte)(this.values[n] + by2);
            this.indexReplace(n, by);
        } else {
            this.indexInsert(n, c, by);
        }
        return by;
    }

    protected void rehash(char[] cArray, byte[] byArray) {
        int n;
        char[] cArray2 = this.keys;
        byte[] byArray2 = this.values;
        int n2 = this.mask;
        int n3 = cArray.length - 1;
        cArray2[cArray2.length - 1] = cArray[n3];
        byArray2[byArray2.length - 1] = byArray[n3];
        while ((n = n3 - 1) >= 0) {
            char c = cArray[n];
            n3 = n;
            if (c == '\u0000') continue;
            n3 = this.hashKey(c);
            while (cArray2[n3 &= n2] != '\u0000') {
                ++n3;
            }
            cArray2[n3] = c;
            byArray2[n3] = byArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public byte remove(char c) {
        char c2;
        int n = this.mask;
        if (c == '\u0000') {
            this.hasEmptyKey = false;
            byte[] byArray = this.values;
            int n2 = n + 1;
            byte by = byArray[n2];
            byArray[n2] = (byte)0;
            return by;
        }
        char[] cArray = this.keys;
        int n3 = this.hashKey(c);
        while ((c2 = cArray[n3 &= n]) != '\u0000') {
            if (c2 == c) {
                byte by = this.values[n3];
                this.shiftConflictingKeys(n3);
                return by;
            }
            ++n3;
        }
        return 0;
    }

    @Override
    public int removeAll(CharContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof CharLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains('\u0000')) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = (byte)0;
            }
            char[] cArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                char c = cArray[n2];
                if (c != '\u0000' && object.contains(c)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((CharCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(CharBytePredicate charBytePredicate) {
        int n;
        byte[] byArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && charBytePredicate.apply('\u0000', (byArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = (byte)0;
        }
        char[] cArray = this.keys;
        byArray = this.values;
        while (n4 <= n3) {
            char c = cArray[n4];
            if (c != '\u0000' && charBytePredicate.apply(c, byArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(CharPredicate charPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && charPredicate.apply('\u0000')) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = (byte)0;
        }
        char[] cArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            char c = cArray[n2];
            if (c != '\u0000' && charPredicate.apply(c)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        char[] cArray = this.keys;
        byte[] byArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            char c;
            int n4;
            int n5 = 0;
            do {
                if ((c = cArray[n4 = n + (n3 = n5 + 1) & n2]) == '\u0000') {
                    cArray[n] = (char)0;
                    byArray[n] = (byte)0;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(c) & n2) < n3);
            cArray[n] = c;
            byArray[n] = byArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<CharByteCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            CharByteCursor charByteCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(charByteCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(charByteCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public ByteCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return CharBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<CharByteCursor> {
        private final CharByteCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = CharByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharByteCursor();
        }

        @Override
        protected CharByteCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharByteHashMap.this.keys;
                    int n2 = this.slot;
                    n = cArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.key = (char)n;
                        this.cursor.value = CharByteHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && CharByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = (char)0;
                this.cursor.value = CharByteHashMap.this.values[this.max];
                return this.cursor;
            }
            return (CharByteCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final CharByteHashMap owner;

        public KeysContainer() {
            this.owner = CharByteHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(char c) {
            return this.owner.containsKey(c);
        }

        @Override
        public <T extends CharPredicate> T forEach(final T t) {
            this.owner.forEach(new CharBytePredicate(){

                @Override
                public boolean apply(char c, byte by) {
                    return t.apply(c);
                }
            });
            return t;
        }

        @Override
        public <T extends CharProcedure> T forEach(final T t) {
            this.owner.forEach(new CharByteProcedure(){

                @Override
                public void apply(char c, byte by) {
                    t.apply(c);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(char c) {
            if (this.owner.containsKey(c)) {
                this.owner.remove(c);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(CharPredicate charPredicate) {
            return this.owner.removeAll(charPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = CharByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharCursor();
        }

        @Override
        protected CharCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharByteHashMap.this.keys;
                    int n2 = this.slot;
                    n = cArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.value = (char)n;
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && CharByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = (char)0;
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractByteCollection {
        private final CharByteHashMap owner;

        private ValuesContainer() {
            this.owner = CharByteHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(byte by) {
            Iterator<CharByteCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != by) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends BytePredicate> T forEach(T t) {
            Iterator<CharByteCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends ByteProcedure> T forEach(T t) {
            Iterator<CharByteCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final byte by) {
            return this.owner.removeAll(new CharBytePredicate(){

                @Override
                public boolean apply(char c, byte by2) {
                    boolean bl = by2 == by;
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final BytePredicate bytePredicate) {
            return this.owner.removeAll(new CharBytePredicate(){

                @Override
                public boolean apply(char c, byte by) {
                    return bytePredicate.apply(by);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = CharByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ByteCursor();
        }

        @Override
        protected ByteCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharByteHashMap.this.keys;
                    n = this.slot;
                    if (cArray[n] != '\u0000') {
                        this.cursor.index = n;
                        this.cursor.value = CharByteHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && CharByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = CharByteHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ByteCursor)this.done();
        }
    }
}

