/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.CharByteHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class CharByteScatterMap
extends CharByteHashMap {
    public CharByteScatterMap() {
        this(4);
    }

    public CharByteScatterMap(int n) {
        this(n, 0.75);
    }

    public CharByteScatterMap(int n, double d) {
        super(n, d, HashOrderMixing.none());
    }

    public static CharByteScatterMap from(char[] cArray, byte[] byArray) {
        if (cArray.length == byArray.length) {
            CharByteScatterMap charByteScatterMap = new CharByteScatterMap(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                charByteScatterMap.put(cArray[i], byArray[i]);
            }
            return charByteScatterMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    protected int hashKey(char c) {
        return BitMixer.mixPhi(c);
    }
}

