/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractDoubleCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.CharBufferVisualizer;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharDoubleAssociativeContainer;
import com.carrotsearch.hppc.CharDoubleMap;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.DoubleCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.CharDoubleCursor;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.predicates.CharDoublePredicate;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.procedures.CharDoubleProcedure;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.DoubleProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class CharDoubleHashMap
implements CharDoubleMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public char[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public double[] values;

    public CharDoubleHashMap() {
        this(4);
    }

    public CharDoubleHashMap(int n) {
        this(n, 0.75);
    }

    public CharDoubleHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public CharDoubleHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public CharDoubleHashMap(CharDoubleAssociativeContainer charDoubleAssociativeContainer) {
        this(charDoubleAssociativeContainer.size());
        this.putAll(charDoubleAssociativeContainer);
    }

    public static CharDoubleHashMap from(char[] cArray, double[] dArray) {
        if (cArray.length == dArray.length) {
            CharDoubleHashMap charDoubleHashMap = new CharDoubleHashMap(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                charDoubleHashMap.put(cArray[i], dArray[i]);
            }
            return charDoubleHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public double addTo(char c, double d) {
        return this.putOrAdd(c, d, d);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        char[] cArray = this.keys;
        double[] dArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new char[n3];
            this.values = new double[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = cArray;
            this.values = dArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, char c, double d) {
        char[] cArray = this.keys;
        double[] dArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        cArray[n] = c;
        dArray[n] = d;
        this.rehash(cArray, dArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, '\u0000');
    }

    public CharDoubleHashMap clone() {
        try {
            CharDoubleHashMap charDoubleHashMap = (CharDoubleHashMap)super.clone();
            charDoubleHashMap.keys = (char[])this.keys.clone();
            charDoubleHashMap.values = (double[])this.values.clone();
            charDoubleHashMap.hasEmptyKey = charDoubleHashMap.hasEmptyKey;
            charDoubleHashMap.orderMixer = this.orderMixer.clone();
            return charDoubleHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(char c) {
        char c2;
        if (c == '\u0000') {
            return this.hasEmptyKey;
        }
        char[] cArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(c);
        while ((c2 = cArray[n2 &= n]) != '\u0000') {
            if (c2 == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            char[] cArray = this.keys;
            double[] dArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (cArray != null && !this.isEmpty()) {
                this.rehash(cArray, dArray);
            }
        }
    }

    protected boolean equalElements(CharDoubleHashMap object) {
        if (((CharDoubleHashMap)object).size() != this.size()) {
            return false;
        }
        Iterator<CharDoubleCursor> iterator = ((CharDoubleHashMap)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            char c = ((CharDoubleCursor)object).key;
            if (this.containsKey(c) && Double.doubleToLongBits(this.get(c)) == Double.doubleToLongBits(((CharDoubleCursor)object).value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((CharDoubleHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends CharDoublePredicate> T forEach(T t) {
        char[] cArray = this.keys;
        double[] dArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply('\u0000', dArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (cArray[i] == '\u0000' || t.apply(cArray[i], dArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends CharDoubleProcedure> T forEach(T t) {
        char[] cArray = this.keys;
        double[] dArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply('\u0000', dArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (cArray[n] != '\u0000') {
                t.apply(cArray[n], dArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public double get(char c) {
        int n;
        double d = 0.0;
        if (c == '\u0000') {
            if (this.hasEmptyKey) {
                d = this.values[this.mask + 1];
            }
            return d;
        }
        char[] cArray = this.keys;
        int n2 = this.mask;
        int n3 = this.hashKey(c);
        while ((n3 = cArray[n = n3 & n2]) != 0) {
            if (n3 == c) {
                return this.values[n];
            }
            n3 = n + 1;
        }
        return 0.0;
    }

    @Override
    public double getOrDefault(char c, double d) {
        int n;
        if (c == '\u0000') {
            if (this.hasEmptyKey) {
                d = this.values[this.mask + 1];
            }
            return d;
        }
        char[] cArray = this.keys;
        int n2 = this.mask;
        int n3 = this.hashKey(c);
        while ((n3 = cArray[n = n3 & n2]) != 0) {
            if (n3 == c) {
                return this.values[n];
            }
            n3 = n + 1;
        }
        return d;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (CharDoubleCursor charDoubleCursor : this) {
            n += BitMixer.mix(charDoubleCursor.key) + BitMixer.mix(charDoubleCursor.value);
        }
        return n;
    }

    protected int hashKey(char c) {
        return BitMixer.mix(c, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public double indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, char c, double d) {
        if (c == '\u0000') {
            this.values[n] = d;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, c, d);
            } else {
                this.keys[n] = c;
                this.values[n] = d;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(char c) {
        int n;
        int n2 = this.mask;
        if (c == '\u0000') {
            boolean bl = this.hasEmptyKey;
            int n3 = n2 + 1;
            if (!bl) {
                // empty if block
            }
            return n3;
        }
        char[] cArray = this.keys;
        int n4 = this.hashKey(c);
        while ((n4 = cArray[n = n4 & n2]) != 0) {
            if (n4 == c) {
                return n;
            }
            n4 = n + 1;
        }
        return n;
    }

    @Override
    public double indexReplace(int n, double d) {
        double[] dArray = this.values;
        double d2 = dArray[n];
        dArray[n] = d;
        return d2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<CharDoubleCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public double put(char c, double d) {
        char c2;
        int n = this.mask;
        if (c == '\u0000') {
            this.hasEmptyKey = true;
            double[] dArray = this.values;
            int n2 = n + 1;
            double d2 = dArray[n2];
            dArray[n2] = d;
            return d2;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(c);
        while ((c2 = objectArray[n3 &= n]) != '\u0000') {
            if (c2 == c) {
                objectArray = this.values;
                char c3 = objectArray[n3];
                objectArray[n3] = (char)d;
                return c3;
            }
            ++n3;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n3, c, d);
        } else {
            objectArray[n3] = c;
            this.values[n3] = d;
        }
        ++this.assigned;
        return 0.0;
    }

    @Override
    public int putAll(CharDoubleAssociativeContainer object) {
        int n = this.size();
        Iterator<CharDoubleCursor> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((CharDoubleCursor)object).key, ((CharDoubleCursor)object).value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends CharDoubleCursor> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            CharDoubleCursor charDoubleCursor = (CharDoubleCursor)object.next();
            this.put(charDoubleCursor.key, charDoubleCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(char c, double d) {
        int n = this.indexOf(c);
        if (!this.indexExists(n)) {
            this.indexInsert(n, c, d);
            return true;
        }
        return false;
    }

    @Override
    public double putOrAdd(char c, double d, double d2) {
        int n = this.indexOf(c);
        if (this.indexExists(n)) {
            d = this.values[n] + d2;
            this.indexReplace(n, d);
        } else {
            this.indexInsert(n, c, d);
        }
        return d;
    }

    protected void rehash(char[] cArray, double[] dArray) {
        int n;
        char[] cArray2 = this.keys;
        double[] dArray2 = this.values;
        int n2 = this.mask;
        int n3 = cArray.length - 1;
        cArray2[cArray2.length - 1] = cArray[n3];
        dArray2[dArray2.length - 1] = dArray[n3];
        while ((n = n3 - 1) >= 0) {
            char c = cArray[n];
            n3 = n;
            if (c == '\u0000') continue;
            n3 = this.hashKey(c);
            while (cArray2[n3 &= n2] != '\u0000') {
                ++n3;
            }
            cArray2[n3] = c;
            dArray2[n3] = dArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public double remove(char c) {
        int n;
        int n2 = this.mask;
        if (c == '\u0000') {
            this.hasEmptyKey = false;
            double[] dArray = this.values;
            int n3 = n2 + 1;
            double d = dArray[n3];
            dArray[n3] = 0.0;
            return d;
        }
        char[] cArray = this.keys;
        int n4 = this.hashKey(c);
        while ((n4 = cArray[n = n4 & n2]) != 0) {
            if (n4 == c) {
                double d = this.values[n];
                this.shiftConflictingKeys(n);
                return d;
            }
            n4 = n + 1;
        }
        return 0.0;
    }

    @Override
    public int removeAll(CharContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof CharLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains('\u0000')) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0.0;
            }
            char[] cArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                char c = cArray[n2];
                if (c != '\u0000' && object.contains(c)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((CharCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(CharDoublePredicate charDoublePredicate) {
        int n;
        double[] dArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && charDoublePredicate.apply('\u0000', (dArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = 0.0;
        }
        char[] cArray = this.keys;
        dArray = this.values;
        while (n4 <= n3) {
            char c = cArray[n4];
            if (c != '\u0000' && charDoublePredicate.apply(c, dArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(CharPredicate charPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && charPredicate.apply('\u0000')) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0.0;
        }
        char[] cArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            char c = cArray[n2];
            if (c != '\u0000' && charPredicate.apply(c)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        char[] cArray = this.keys;
        double[] dArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            char c;
            int n4;
            int n5 = 0;
            do {
                if ((c = cArray[n4 = n + (n3 = n5 + 1) & n2]) == '\u0000') {
                    cArray[n] = (char)0;
                    dArray[n] = 0.0;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(c) & n2) < n3);
            cArray[n] = c;
            dArray[n] = dArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<CharDoubleCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            CharDoubleCursor charDoubleCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(charDoubleCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(charDoubleCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public DoubleCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return CharBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<CharDoubleCursor> {
        private final CharDoubleCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = CharDoubleHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharDoubleCursor();
        }

        @Override
        protected CharDoubleCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharDoubleHashMap.this.keys;
                    int n2 = this.slot;
                    n = cArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.key = (char)n;
                        this.cursor.value = CharDoubleHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && CharDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = (char)0;
                this.cursor.value = CharDoubleHashMap.this.values[this.max];
                return this.cursor;
            }
            return (CharDoubleCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final CharDoubleHashMap owner;

        public KeysContainer() {
            this.owner = CharDoubleHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(char c) {
            return this.owner.containsKey(c);
        }

        @Override
        public <T extends CharPredicate> T forEach(final T t) {
            this.owner.forEach(new CharDoublePredicate(){

                @Override
                public boolean apply(char c, double d) {
                    return t.apply(c);
                }
            });
            return t;
        }

        @Override
        public <T extends CharProcedure> T forEach(final T t) {
            this.owner.forEach(new CharDoubleProcedure(){

                @Override
                public void apply(char c, double d) {
                    t.apply(c);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(char c) {
            if (this.owner.containsKey(c)) {
                this.owner.remove(c);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(CharPredicate charPredicate) {
            return this.owner.removeAll(charPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = CharDoubleHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharCursor();
        }

        @Override
        protected CharCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharDoubleHashMap.this.keys;
                    n = this.slot;
                    char c = cArray[n];
                    if (c != '\u0000') {
                        this.cursor.index = n;
                        this.cursor.value = c;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && CharDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = (char)0;
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractDoubleCollection {
        private final CharDoubleHashMap owner;

        private ValuesContainer() {
            this.owner = CharDoubleHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(double d) {
            Iterator<CharDoubleCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (Double.doubleToLongBits(iterator.next().value) != Double.doubleToLongBits(d)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T t) {
            Iterator<CharDoubleCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T t) {
            Iterator<CharDoubleCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final double d) {
            return this.owner.removeAll(new CharDoublePredicate(){

                @Override
                public boolean apply(char c, double d2) {
                    boolean bl = Double.doubleToLongBits(d2) == Double.doubleToLongBits(d);
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final DoublePredicate doublePredicate) {
            return this.owner.removeAll(new CharDoublePredicate(){

                @Override
                public boolean apply(char c, double d) {
                    return doublePredicate.apply(d);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = CharDoubleHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new DoubleCursor();
        }

        @Override
        protected DoubleCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharDoubleHashMap.this.keys;
                    n = this.slot;
                    if (cArray[n] != '\u0000') {
                        this.cursor.index = n;
                        this.cursor.value = CharDoubleHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && CharDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = CharDoubleHashMap.this.values[this.max];
                return this.cursor;
            }
            return (DoubleCursor)this.done();
        }
    }
}

