/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.CharDoubleHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class CharDoubleScatterMap
extends CharDoubleHashMap {
    public CharDoubleScatterMap() {
        this(4);
    }

    public CharDoubleScatterMap(int n) {
        this(n, 0.75);
    }

    public CharDoubleScatterMap(int n, double d) {
        super(n, d, HashOrderMixing.none());
    }

    public static CharDoubleScatterMap from(char[] cArray, double[] dArray) {
        if (cArray.length == dArray.length) {
            CharDoubleScatterMap charDoubleScatterMap = new CharDoubleScatterMap(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                charDoubleScatterMap.put(cArray[i], dArray[i]);
            }
            return charDoubleScatterMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    protected int hashKey(char c) {
        return BitMixer.mixPhi(c);
    }
}

