/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractFloatCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.CharBufferVisualizer;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharFloatAssociativeContainer;
import com.carrotsearch.hppc.CharFloatMap;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.FloatCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.CharFloatCursor;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.predicates.CharFloatPredicate;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import com.carrotsearch.hppc.procedures.CharFloatProcedure;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.FloatProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class CharFloatHashMap
implements CharFloatMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public char[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public float[] values;

    public CharFloatHashMap() {
        this(4);
    }

    public CharFloatHashMap(int n) {
        this(n, 0.75);
    }

    public CharFloatHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public CharFloatHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public CharFloatHashMap(CharFloatAssociativeContainer charFloatAssociativeContainer) {
        this(charFloatAssociativeContainer.size());
        this.putAll(charFloatAssociativeContainer);
    }

    public static CharFloatHashMap from(char[] cArray, float[] fArray) {
        if (cArray.length == fArray.length) {
            CharFloatHashMap charFloatHashMap = new CharFloatHashMap(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                charFloatHashMap.put(cArray[i], fArray[i]);
            }
            return charFloatHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public float addTo(char c, float f) {
        return this.putOrAdd(c, f, f);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        char[] cArray = this.keys;
        float[] fArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new char[n3];
            this.values = new float[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = cArray;
            this.values = fArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, char c, float f) {
        char[] cArray = this.keys;
        float[] fArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        cArray[n] = c;
        fArray[n] = f;
        this.rehash(cArray, fArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, '\u0000');
    }

    public CharFloatHashMap clone() {
        try {
            CharFloatHashMap charFloatHashMap = (CharFloatHashMap)super.clone();
            charFloatHashMap.keys = (char[])this.keys.clone();
            charFloatHashMap.values = (float[])this.values.clone();
            charFloatHashMap.hasEmptyKey = charFloatHashMap.hasEmptyKey;
            charFloatHashMap.orderMixer = this.orderMixer.clone();
            return charFloatHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(char c) {
        char c2;
        if (c == '\u0000') {
            return this.hasEmptyKey;
        }
        char[] cArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(c);
        while ((c2 = cArray[n2 &= n]) != '\u0000') {
            if (c2 == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            char[] cArray = this.keys;
            float[] fArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (cArray != null && !this.isEmpty()) {
                this.rehash(cArray, fArray);
            }
        }
    }

    protected boolean equalElements(CharFloatHashMap object) {
        if (((CharFloatHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((CharFloatHashMap)object).iterator();
        while (object.hasNext()) {
            CharFloatCursor charFloatCursor = (CharFloatCursor)object.next();
            char c = charFloatCursor.key;
            if (this.containsKey(c) && Float.floatToIntBits(this.get(c)) == Float.floatToIntBits(charFloatCursor.value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((CharFloatHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends CharFloatPredicate> T forEach(T t) {
        char[] cArray = this.keys;
        float[] fArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply('\u0000', fArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (cArray[i] == '\u0000' || t.apply(cArray[i], fArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends CharFloatProcedure> T forEach(T t) {
        char[] cArray = this.keys;
        float[] fArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply('\u0000', fArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (cArray[n] != '\u0000') {
                t.apply(cArray[n], fArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public float get(char c) {
        char c2;
        float f = 0.0f;
        if (c == '\u0000') {
            if (this.hasEmptyKey) {
                f = this.values[this.mask + 1];
            }
            return f;
        }
        char[] cArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(c);
        while ((c2 = cArray[n2 &= n]) != '\u0000') {
            if (c2 == c) {
                return this.values[n2];
            }
            ++n2;
        }
        return 0.0f;
    }

    @Override
    public float getOrDefault(char c, float f) {
        char c2;
        if (c == '\u0000') {
            if (this.hasEmptyKey) {
                f = this.values[this.mask + 1];
            }
            return f;
        }
        char[] cArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(c);
        while ((c2 = cArray[n2 &= n]) != '\u0000') {
            if (c2 == c) {
                return this.values[n2];
            }
            ++n2;
        }
        return f;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (CharFloatCursor charFloatCursor : this) {
            n += BitMixer.mix(charFloatCursor.key) + BitMixer.mix(charFloatCursor.value);
        }
        return n;
    }

    protected int hashKey(char c) {
        return BitMixer.mix(c, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public float indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, char c, float f) {
        if (c == '\u0000') {
            this.values[n] = f;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, c, f);
            } else {
                this.keys[n] = c;
                this.values[n] = f;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(char c) {
        char c2;
        int n = this.mask;
        if (c == '\u0000') {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        char[] cArray = this.keys;
        int n3 = this.hashKey(c);
        while ((c2 = cArray[n3 &= n]) != '\u0000') {
            if (c2 == c) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public float indexReplace(int n, float f) {
        float[] fArray = this.values;
        float f2 = fArray[n];
        fArray[n] = f;
        return f2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<CharFloatCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public float put(char c, float f) {
        char c2;
        int n = this.mask;
        if (c == '\u0000') {
            this.hasEmptyKey = true;
            float[] fArray = this.values;
            int n2 = n + 1;
            float f2 = fArray[n2];
            fArray[n2] = f;
            return f2;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(c);
        while ((c2 = objectArray[n3 &= n]) != '\u0000') {
            if (c2 == c) {
                objectArray = this.values;
                char c3 = objectArray[n3];
                objectArray[n3] = (char)f;
                return c3;
            }
            ++n3;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n3, c, f);
        } else {
            objectArray[n3] = c;
            this.values[n3] = f;
        }
        ++this.assigned;
        return 0.0f;
    }

    @Override
    public int putAll(CharFloatAssociativeContainer object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            CharFloatCursor charFloatCursor = (CharFloatCursor)object.next();
            this.put(charFloatCursor.key, charFloatCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends CharFloatCursor> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            CharFloatCursor charFloatCursor = (CharFloatCursor)object.next();
            this.put(charFloatCursor.key, charFloatCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(char c, float f) {
        int n = this.indexOf(c);
        if (!this.indexExists(n)) {
            this.indexInsert(n, c, f);
            return true;
        }
        return false;
    }

    @Override
    public float putOrAdd(char c, float f, float f2) {
        int n = this.indexOf(c);
        if (this.indexExists(n)) {
            f = this.values[n] + f2;
            this.indexReplace(n, f);
        } else {
            this.indexInsert(n, c, f);
        }
        return f;
    }

    protected void rehash(char[] cArray, float[] fArray) {
        int n;
        char[] cArray2 = this.keys;
        float[] fArray2 = this.values;
        int n2 = this.mask;
        int n3 = cArray.length - 1;
        cArray2[cArray2.length - 1] = cArray[n3];
        fArray2[fArray2.length - 1] = fArray[n3];
        while ((n = n3 - 1) >= 0) {
            char c = cArray[n];
            n3 = n;
            if (c == '\u0000') continue;
            n3 = this.hashKey(c);
            while (cArray2[n3 &= n2] != '\u0000') {
                ++n3;
            }
            cArray2[n3] = c;
            fArray2[n3] = fArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public float remove(char c) {
        int n;
        int n2 = this.mask;
        if (c == '\u0000') {
            this.hasEmptyKey = false;
            float[] fArray = this.values;
            int n3 = n2 + 1;
            float f = fArray[n3];
            fArray[n3] = 0.0f;
            return f;
        }
        char[] cArray = this.keys;
        int n4 = this.hashKey(c);
        while ((n4 = cArray[n = n4 & n2]) != 0) {
            if (n4 == c) {
                float f = this.values[n];
                this.shiftConflictingKeys(n);
                return f;
            }
            n4 = n + 1;
        }
        return 0.0f;
    }

    @Override
    public int removeAll(CharContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof CharLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains('\u0000')) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0.0f;
            }
            char[] cArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                char c = cArray[n2];
                if (c != '\u0000' && object.contains(c)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((CharCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(CharFloatPredicate charFloatPredicate) {
        int n;
        Object[] objectArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && charFloatPredicate.apply('\u0000', (objectArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = 0.0f;
        }
        objectArray = this.keys;
        float[] fArray = this.values;
        while (n4 <= n3) {
            float f = objectArray[n4];
            if (f != false && charFloatPredicate.apply((char)f, fArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(CharPredicate charPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && charPredicate.apply('\u0000')) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0.0f;
        }
        char[] cArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            char c = cArray[n2];
            if (c != '\u0000' && charPredicate.apply(c)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        char[] cArray = this.keys;
        float[] fArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            char c;
            int n4;
            int n5 = 0;
            do {
                if ((c = cArray[n4 = n + (n3 = n5 + 1) & n2]) == '\u0000') {
                    cArray[n] = (char)0;
                    fArray[n] = 0.0f;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(c) & n2) < n3);
            cArray[n] = c;
            fArray[n] = fArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<CharFloatCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            CharFloatCursor charFloatCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(charFloatCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(charFloatCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public FloatCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return CharBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<CharFloatCursor> {
        private final CharFloatCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = CharFloatHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharFloatCursor();
        }

        @Override
        protected CharFloatCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharFloatHashMap.this.keys;
                    int n2 = this.slot;
                    n = cArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.key = (char)n;
                        this.cursor.value = CharFloatHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && CharFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = (char)0;
                this.cursor.value = CharFloatHashMap.this.values[this.max];
                return this.cursor;
            }
            return (CharFloatCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final CharFloatHashMap owner;

        public KeysContainer() {
            this.owner = CharFloatHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(char c) {
            return this.owner.containsKey(c);
        }

        @Override
        public <T extends CharPredicate> T forEach(final T t) {
            this.owner.forEach(new CharFloatPredicate(){

                @Override
                public boolean apply(char c, float f) {
                    return t.apply(c);
                }
            });
            return t;
        }

        @Override
        public <T extends CharProcedure> T forEach(final T t) {
            this.owner.forEach(new CharFloatProcedure(){

                @Override
                public void apply(char c, float f) {
                    t.apply(c);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(char c) {
            if (this.owner.containsKey(c)) {
                this.owner.remove(c);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(CharPredicate charPredicate) {
            return this.owner.removeAll(charPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = CharFloatHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharCursor();
        }

        @Override
        protected CharCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharFloatHashMap.this.keys;
                    n = this.slot;
                    char c = cArray[n];
                    if (c != '\u0000') {
                        this.cursor.index = n;
                        this.cursor.value = c;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && CharFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = (char)0;
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractFloatCollection {
        private final CharFloatHashMap owner;

        private ValuesContainer() {
            this.owner = CharFloatHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(float f) {
            Iterator<CharFloatCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (Float.floatToIntBits(iterator.next().value) != Float.floatToIntBits(f)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T t) {
            Iterator<CharFloatCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T t) {
            Iterator<CharFloatCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<FloatCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final float f) {
            return this.owner.removeAll(new CharFloatPredicate(){

                @Override
                public boolean apply(char c, float f2) {
                    boolean bl = Float.floatToIntBits(f2) == Float.floatToIntBits(f);
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final FloatPredicate floatPredicate) {
            return this.owner.removeAll(new CharFloatPredicate(){

                @Override
                public boolean apply(char c, float f) {
                    return floatPredicate.apply(f);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = CharFloatHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new FloatCursor();
        }

        @Override
        protected FloatCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharFloatHashMap.this.keys;
                    n = this.slot;
                    if (cArray[n] != '\u0000') {
                        this.cursor.index = n;
                        this.cursor.value = CharFloatHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && CharFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = CharFloatHashMap.this.values[this.max];
                return this.cursor;
            }
            return (FloatCursor)this.done();
        }
    }
}

