/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.CharFloatHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class CharFloatScatterMap
extends CharFloatHashMap {
    public CharFloatScatterMap() {
        this(4);
    }

    public CharFloatScatterMap(int n) {
        this(n, 0.75);
    }

    public CharFloatScatterMap(int n, double d) {
        super(n, d, HashOrderMixing.none());
    }

    public static CharFloatScatterMap from(char[] cArray, float[] fArray) {
        if (cArray.length == fArray.length) {
            CharFloatScatterMap charFloatScatterMap = new CharFloatScatterMap(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                charFloatScatterMap.put(cArray[i], fArray[i]);
            }
            return charFloatScatterMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    protected int hashKey(char c) {
        return BitMixer.mixPhi(c);
    }
}

