/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.CharBufferVisualizer;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.CharSet;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.procedures.CharProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class CharHashSet
extends AbstractCharCollection
implements CharLookupContainer,
CharSet,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public char[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;

    public CharHashSet() {
        this(4, 0.75);
    }

    public CharHashSet(int n) {
        this(n, 0.75);
    }

    public CharHashSet(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public CharHashSet(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public CharHashSet(CharContainer charContainer) {
        this(charContainer.size());
        this.addAll(charContainer);
    }

    public static CharHashSet from(char ... cArray) {
        CharHashSet charHashSet = new CharHashSet(cArray.length);
        charHashSet.addAll(cArray);
        return charHashSet;
    }

    private boolean sameKeys(CharSet object) {
        if (object.size() != this.size()) {
            return false;
        }
        object = object.iterator();
        while (object.hasNext()) {
            if (this.contains(((CharCursor)object.next()).value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(char c) {
        int n;
        if (c == '\u0000') {
            boolean bl = this.hasEmptyKey;
            this.hasEmptyKey = true;
            return bl ^ true;
        }
        char[] cArray = this.keys;
        int n2 = this.mask;
        int n3 = this.hashKey(c);
        while ((n3 = cArray[n = n3 & n2]) != 0) {
            if (n3 == c) {
                return false;
            }
            n3 = n + 1;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n, c);
        } else {
            cArray[n] = c;
        }
        ++this.assigned;
        return true;
    }

    public int addAll(CharContainer charContainer) {
        this.ensureCapacity(charContainer.size());
        return this.addAll((Iterable<? extends CharCursor>)charContainer);
    }

    public int addAll(Iterable<? extends CharCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            if (!this.add(((CharCursor)object.next()).value)) continue;
            ++n;
        }
        return n;
    }

    public final int addAll(char ... cArray) {
        this.ensureCapacity(cArray.length);
        int n = cArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = n2;
            if (this.add(cArray[i])) {
                n3 = n2 + 1;
            }
            n2 = n3;
        }
        return n2;
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        char[] cArray = this.keys;
        try {
            this.keys = new char[n + 1];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = cArray;
            n2 = this.keys == null ? 0 : this.size();
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, n2, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, char c) {
        char[] cArray = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        cArray[n] = c;
        this.rehash(cArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, '\u0000');
    }

    public CharHashSet clone() {
        try {
            CharHashSet charHashSet = (CharHashSet)super.clone();
            charHashSet.keys = (char[])this.keys.clone();
            charHashSet.hasEmptyKey = charHashSet.hasEmptyKey;
            charHashSet.orderMixer = this.orderMixer.clone();
            return charHashSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(char c) {
        int n;
        if (c == '\u0000') {
            return this.hasEmptyKey;
        }
        char[] cArray = this.keys;
        int n2 = this.mask;
        int n3 = this.hashKey(c);
        while ((n3 = cArray[n = n3 & n2]) != 0) {
            if (n3 == c) {
                return true;
            }
            n3 = n + 1;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            char[] cArray = this.keys;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (cArray != null && !this.isEmpty()) {
                this.rehash(cArray);
            }
        }
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.sameKeys((CharSet)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends CharPredicate> T forEach(T t) {
        char c;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply('\u0000')) {
            return t;
        }
        char[] cArray = this.keys;
        int n = this.mask;
        for (int i = 0; i <= n && ((c = cArray[i]) == '\u0000' || t.apply(c)); ++i) {
        }
        return t;
    }

    @Override
    public <T extends CharProcedure> T forEach(T t) {
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply('\u0000');
        }
        char[] cArray = this.keys;
        int n2 = this.mask;
        while (n <= n2) {
            char c = cArray[n];
            if (c != '\u0000') {
                t.apply(c);
            }
            ++n;
        }
        return t;
    }

    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        char[] cArray = this.keys;
        for (int i = this.mask; i >= 0; --i) {
            char c = cArray[i];
            int n2 = n;
            if (c != '\u0000') {
                n2 = n + BitMixer.mix(c);
            }
            n = n2;
        }
        return n;
    }

    protected int hashKey(char c) {
        return BitMixer.mix(c, this.keyMixer);
    }

    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    public char indexGet(int n) {
        return this.keys[n];
    }

    public void indexInsert(int n, char c) {
        if (c == '\u0000') {
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, c);
            } else {
                this.keys[n] = c;
            }
            ++this.assigned;
        }
    }

    public int indexOf(char c) {
        int n;
        int n2 = this.mask;
        if (c == '\u0000') {
            boolean bl = this.hasEmptyKey;
            int n3 = n2 + 1;
            if (!bl) {
                // empty if block
            }
            return n3;
        }
        char[] cArray = this.keys;
        int n4 = this.hashKey(c);
        while ((n4 = cArray[n = n4 & n2]) != 0) {
            if (n4 == c) {
                return n;
            }
            n4 = n + 1;
        }
        return n;
    }

    public char indexReplace(int n, char c) {
        char[] cArray = this.keys;
        char c2 = cArray[n];
        cArray[n] = c;
        return c2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<CharCursor> iterator() {
        return new EntryIterator();
    }

    protected void rehash(char[] cArray) {
        int n;
        char[] cArray2 = this.keys;
        int n2 = this.mask;
        int n3 = cArray.length - 1;
        while ((n = n3 - 1) >= 0) {
            char c = cArray[n];
            n3 = n;
            if (c == '\u0000') continue;
            n3 = this.hashKey(c);
            while (cArray2[n3 &= n2] != '\u0000') {
                ++n3;
            }
            cArray2[n3] = c;
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.ensureCapacity(4);
    }

    public boolean remove(char c) {
        int n;
        if (c == '\u0000') {
            boolean bl = this.hasEmptyKey;
            this.hasEmptyKey = false;
            return bl;
        }
        char[] cArray = this.keys;
        int n2 = this.mask;
        int n3 = this.hashKey(c);
        while ((n3 = cArray[n = n3 & n2]) != 0) {
            if (n3 == c) {
                this.shiftConflictingKeys(n);
                return true;
            }
            n3 = n + 1;
        }
        return false;
    }

    @Override
    public int removeAll(char c) {
        return this.remove(c) ? 1 : 0;
    }

    @Override
    public int removeAll(CharPredicate charPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && charPredicate.apply('\u0000')) {
            this.hasEmptyKey = false;
        }
        char[] cArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            char c = cArray[n2];
            if (c != '\u0000' && charPredicate.apply(c)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        char[] cArray = this.keys;
        int n2 = this.mask;
        while (true) {
            int n3;
            char c;
            int n4;
            int n5 = 0;
            do {
                if ((c = cArray[n4 = n + (n3 = n5 + 1) & n2]) == '\u0000') {
                    cArray[n] = (char)0;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(c) & n2) < n3);
            cArray[n] = c;
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    @Override
    public char[] toArray() {
        int n;
        char[] cArray = new char[this.size()];
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl) {
            cArray[0] = (char)0;
            n = 1;
        } else {
            n = 0;
        }
        char[] cArray2 = this.keys;
        int n3 = this.mask;
        int n4 = n;
        while (n2 <= n3) {
            char c = cArray2[n2];
            n = n4;
            if (c != '\u0000') {
                cArray[n4] = c;
                n = n4 + 1;
            }
            ++n2;
            n4 = n;
        }
        return cArray;
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return CharBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    protected final class EntryIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = CharHashSet.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharCursor();
        }

        @Override
        protected CharCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharHashSet.this.keys;
                    n = this.slot;
                    char c = cArray[n];
                    if (c != '\u0000') {
                        this.cursor.index = n;
                        this.cursor.value = c;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && CharHashSet.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = (char)0;
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }
}

