/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.CharBufferVisualizer;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharIntAssociativeContainer;
import com.carrotsearch.hppc.CharIntMap;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.IntCollection;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.CharIntCursor;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.CharIntPredicate;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.CharIntProcedure;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class CharIntHashMap
implements CharIntMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public char[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public int[] values;

    public CharIntHashMap() {
        this(4);
    }

    public CharIntHashMap(int n) {
        this(n, 0.75);
    }

    public CharIntHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public CharIntHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public CharIntHashMap(CharIntAssociativeContainer charIntAssociativeContainer) {
        this(charIntAssociativeContainer.size());
        this.putAll(charIntAssociativeContainer);
    }

    public static CharIntHashMap from(char[] cArray, int[] nArray) {
        if (cArray.length == nArray.length) {
            CharIntHashMap charIntHashMap = new CharIntHashMap(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                charIntHashMap.put(cArray[i], nArray[i]);
            }
            return charIntHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public int addTo(char c, int n) {
        return this.putOrAdd(c, n, n);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        char[] cArray = this.keys;
        int[] nArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new char[n3];
            this.values = new int[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = cArray;
            this.values = nArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, char c, int n2) {
        char[] cArray = this.keys;
        int[] nArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        cArray[n] = c;
        nArray[n] = n2;
        this.rehash(cArray, nArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, '\u0000');
    }

    public CharIntHashMap clone() {
        try {
            CharIntHashMap charIntHashMap = (CharIntHashMap)super.clone();
            charIntHashMap.keys = (char[])this.keys.clone();
            charIntHashMap.values = (int[])this.values.clone();
            charIntHashMap.hasEmptyKey = charIntHashMap.hasEmptyKey;
            charIntHashMap.orderMixer = this.orderMixer.clone();
            return charIntHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(char c) {
        char c2;
        if (c == '\u0000') {
            return this.hasEmptyKey;
        }
        char[] cArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(c);
        while ((c2 = cArray[n2 &= n]) != '\u0000') {
            if (c2 == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            char[] cArray = this.keys;
            int[] nArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (cArray != null && !this.isEmpty()) {
                this.rehash(cArray, nArray);
            }
        }
    }

    protected boolean equalElements(CharIntHashMap object) {
        if (((CharIntHashMap)object).size() != this.size()) {
            return false;
        }
        Iterator<CharIntCursor> iterator = ((CharIntHashMap)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            char c = ((CharIntCursor)object).key;
            if (this.containsKey(c) && this.get(c) == ((CharIntCursor)object).value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((CharIntHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends CharIntPredicate> T forEach(T t) {
        char[] cArray = this.keys;
        int[] nArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply('\u0000', nArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (cArray[i] == '\u0000' || t.apply(cArray[i], nArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends CharIntProcedure> T forEach(T t) {
        char[] cArray = this.keys;
        int[] nArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply('\u0000', nArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (cArray[n] != '\u0000') {
                t.apply(cArray[n], nArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public int get(char n) {
        int n2;
        int n3 = 0;
        if (n == 0) {
            if (this.hasEmptyKey) {
                n3 = this.values[this.mask + 1];
            }
            return n3;
        }
        char[] cArray = this.keys;
        int n4 = this.mask;
        n3 = this.hashKey((char)n);
        while ((n3 = cArray[n2 = n3 & n4]) != 0) {
            if (n3 == n) {
                return this.values[n2];
            }
            n3 = n2 + 1;
        }
        return 0;
    }

    @Override
    public int getOrDefault(char c, int n) {
        int n2;
        if (c == '\u0000') {
            if (this.hasEmptyKey) {
                n = this.values[this.mask + 1];
            }
            return n;
        }
        char[] cArray = this.keys;
        int n3 = this.mask;
        int n4 = this.hashKey(c);
        while ((n4 = cArray[n2 = n4 & n3]) != 0) {
            if (n4 == c) {
                return this.values[n2];
            }
            n4 = n2 + 1;
        }
        return n;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (CharIntCursor charIntCursor : this) {
            n += BitMixer.mix(charIntCursor.key) + BitMixer.mix(charIntCursor.value);
        }
        return n;
    }

    protected int hashKey(char c) {
        return BitMixer.mix(c, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public int indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, char c, int n2) {
        if (c == '\u0000') {
            this.values[n] = n2;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, c, n2);
            } else {
                this.keys[n] = c;
                this.values[n] = n2;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(char c) {
        int n;
        int n2 = this.mask;
        if (c == '\u0000') {
            boolean bl = this.hasEmptyKey;
            int n3 = n2 + 1;
            if (!bl) {
                // empty if block
            }
            return n3;
        }
        char[] cArray = this.keys;
        int n4 = this.hashKey(c);
        while ((n4 = cArray[n = n4 & n2]) != 0) {
            if (n4 == c) {
                return n;
            }
            n4 = n + 1;
        }
        return n;
    }

    @Override
    public int indexReplace(int n, int n2) {
        int[] nArray = this.values;
        int n3 = nArray[n];
        nArray[n] = n2;
        return n3;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<CharIntCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public int put(char c, int n) {
        char c2;
        int n2 = this.mask;
        if (c == '\u0000') {
            this.hasEmptyKey = true;
            int[] nArray = this.values;
            int n3 = n2 + 1;
            n2 = nArray[n3];
            nArray[n3] = n;
            return n2;
        }
        Object[] objectArray = this.keys;
        int n4 = this.hashKey(c);
        while ((c2 = objectArray[n4 &= n2]) != '\u0000') {
            if (c2 == c) {
                objectArray = this.values;
                n2 = objectArray[n4];
                objectArray[n4] = n;
                return n2;
            }
            ++n4;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n4, c, n);
        } else {
            objectArray[n4] = c;
            this.values[n4] = n;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(CharIntAssociativeContainer object) {
        int n = this.size();
        Iterator<CharIntCursor> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((CharIntCursor)object).key, ((CharIntCursor)object).value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends CharIntCursor> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            CharIntCursor charIntCursor = (CharIntCursor)object.next();
            this.put(charIntCursor.key, charIntCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(char c, int n) {
        int n2 = this.indexOf(c);
        if (!this.indexExists(n2)) {
            this.indexInsert(n2, c, n);
            return true;
        }
        return false;
    }

    @Override
    public int putOrAdd(char c, int n, int n2) {
        int n3 = this.indexOf(c);
        if (this.indexExists(n3)) {
            n = this.values[n3] + n2;
            this.indexReplace(n3, n);
        } else {
            this.indexInsert(n3, c, n);
        }
        return n;
    }

    protected void rehash(char[] cArray, int[] nArray) {
        int n;
        char[] cArray2 = this.keys;
        int[] nArray2 = this.values;
        int n2 = this.mask;
        int n3 = cArray.length - 1;
        cArray2[cArray2.length - 1] = cArray[n3];
        nArray2[nArray2.length - 1] = nArray[n3];
        while ((n = n3 - 1) >= 0) {
            char c = cArray[n];
            n3 = n;
            if (c == '\u0000') continue;
            n3 = this.hashKey(c);
            while (cArray2[n3 &= n2] != '\u0000') {
                ++n3;
            }
            cArray2[n3] = c;
            nArray2[n3] = nArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int remove(char c) {
        char c2;
        int n = this.mask;
        if (c == '\u0000') {
            this.hasEmptyKey = false;
            int[] nArray = this.values;
            int n2 = n + 1;
            n = nArray[n2];
            nArray[n2] = 0;
            return n;
        }
        char[] cArray = this.keys;
        int n3 = this.hashKey(c);
        while ((c2 = cArray[n3 &= n]) != '\u0000') {
            if (c2 == c) {
                n = this.values[n3];
                this.shiftConflictingKeys(n3);
                return n;
            }
            ++n3;
        }
        return 0;
    }

    @Override
    public int removeAll(CharContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof CharLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains('\u0000')) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0;
            }
            char[] cArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                char c = cArray[n2];
                if (c != '\u0000' && object.contains(c)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((CharCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(CharIntPredicate charIntPredicate) {
        int n;
        int[] nArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && charIntPredicate.apply('\u0000', (nArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = 0;
        }
        char[] cArray = this.keys;
        nArray = this.values;
        while (n4 <= n3) {
            char c = cArray[n4];
            if (c != '\u0000' && charIntPredicate.apply(c, nArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(CharPredicate charPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && charPredicate.apply('\u0000')) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0;
        }
        char[] cArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            char c = cArray[n2];
            if (c != '\u0000' && charPredicate.apply(c)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        char[] cArray = this.keys;
        int[] nArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            char c;
            int n4;
            int n5 = 0;
            do {
                if ((c = cArray[n4 = n + (n3 = n5 + 1) & n2]) == '\u0000') {
                    cArray[n] = (char)0;
                    nArray[n] = 0;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(c) & n2) < n3);
            cArray[n] = c;
            nArray[n] = nArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<CharIntCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            CharIntCursor charIntCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(charIntCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(charIntCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public IntCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return CharBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<CharIntCursor> {
        private final CharIntCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = CharIntHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharIntCursor();
        }

        @Override
        protected CharIntCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharIntHashMap.this.keys;
                    n = this.slot;
                    char c = cArray[n];
                    if (c != '\u0000') {
                        this.cursor.index = n;
                        this.cursor.key = c;
                        this.cursor.value = CharIntHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && CharIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = (char)0;
                this.cursor.value = CharIntHashMap.this.values[this.max];
                return this.cursor;
            }
            return (CharIntCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final CharIntHashMap owner;

        public KeysContainer() {
            this.owner = CharIntHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(char c) {
            return this.owner.containsKey(c);
        }

        @Override
        public <T extends CharPredicate> T forEach(final T t) {
            this.owner.forEach(new CharIntPredicate(){

                @Override
                public boolean apply(char c, int n) {
                    return t.apply(c);
                }
            });
            return t;
        }

        @Override
        public <T extends CharProcedure> T forEach(final T t) {
            this.owner.forEach(new CharIntProcedure(){

                @Override
                public void apply(char c, int n) {
                    t.apply(c);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(char c) {
            if (this.owner.containsKey(c)) {
                this.owner.remove(c);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(CharPredicate charPredicate) {
            return this.owner.removeAll(charPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = CharIntHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharCursor();
        }

        @Override
        protected CharCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharIntHashMap.this.keys;
                    n = this.slot;
                    char c = cArray[n];
                    if (c != '\u0000') {
                        this.cursor.index = n;
                        this.cursor.value = c;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && CharIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = (char)0;
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractIntCollection {
        private final CharIntHashMap owner;

        private ValuesContainer() {
            this.owner = CharIntHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(int n) {
            Iterator<CharIntCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != n) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntPredicate> T forEach(T t) {
            Iterator<CharIntCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends IntProcedure> T forEach(T t) {
            Iterator<CharIntCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final int n) {
            return this.owner.removeAll(new CharIntPredicate(){

                @Override
                public boolean apply(char c, int n2) {
                    boolean bl = n2 == n;
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final IntPredicate intPredicate) {
            return this.owner.removeAll(new CharIntPredicate(){

                @Override
                public boolean apply(char c, int n) {
                    return intPredicate.apply(n);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = CharIntHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntCursor();
        }

        @Override
        protected IntCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharIntHashMap.this.keys;
                    n = this.slot;
                    if (cArray[n] != '\u0000') {
                        this.cursor.index = n;
                        this.cursor.value = CharIntHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && CharIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = CharIntHashMap.this.values[this.max];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }
}

