/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.CharIntHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class CharIntScatterMap
extends CharIntHashMap {
    public CharIntScatterMap() {
        this(4);
    }

    public CharIntScatterMap(int n) {
        this(n, 0.75);
    }

    public CharIntScatterMap(int n, double d) {
        super(n, d, HashOrderMixing.none());
    }

    public static CharIntScatterMap from(char[] cArray, int[] nArray) {
        if (cArray.length == nArray.length) {
            CharIntScatterMap charIntScatterMap = new CharIntScatterMap(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                charIntScatterMap.put(cArray[i], nArray[i]);
            }
            return charIntScatterMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    protected int hashKey(char c) {
        return BitMixer.mixPhi(c);
    }
}

