/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.CharBufferVisualizer;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharLongAssociativeContainer;
import com.carrotsearch.hppc.CharLongMap;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.LongCollection;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.CharLongCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.predicates.CharLongPredicate;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.CharLongProcedure;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class CharLongHashMap
implements CharLongMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public char[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public long[] values;

    public CharLongHashMap() {
        this(4);
    }

    public CharLongHashMap(int n) {
        this(n, 0.75);
    }

    public CharLongHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public CharLongHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public CharLongHashMap(CharLongAssociativeContainer charLongAssociativeContainer) {
        this(charLongAssociativeContainer.size());
        this.putAll(charLongAssociativeContainer);
    }

    public static CharLongHashMap from(char[] cArray, long[] lArray) {
        if (cArray.length == lArray.length) {
            CharLongHashMap charLongHashMap = new CharLongHashMap(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                charLongHashMap.put(cArray[i], lArray[i]);
            }
            return charLongHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public long addTo(char c, long l) {
        return this.putOrAdd(c, l, l);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        char[] cArray = this.keys;
        long[] lArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new char[n3];
            this.values = new long[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = cArray;
            this.values = lArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, char c, long l) {
        char[] cArray = this.keys;
        long[] lArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        cArray[n] = c;
        lArray[n] = l;
        this.rehash(cArray, lArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, '\u0000');
    }

    public CharLongHashMap clone() {
        try {
            CharLongHashMap charLongHashMap = (CharLongHashMap)super.clone();
            charLongHashMap.keys = (char[])this.keys.clone();
            charLongHashMap.values = (long[])this.values.clone();
            charLongHashMap.hasEmptyKey = charLongHashMap.hasEmptyKey;
            charLongHashMap.orderMixer = this.orderMixer.clone();
            return charLongHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(char c) {
        char c2;
        if (c == '\u0000') {
            return this.hasEmptyKey;
        }
        char[] cArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(c);
        while ((c2 = cArray[n2 &= n]) != '\u0000') {
            if (c2 == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            char[] cArray = this.keys;
            long[] lArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (cArray != null && !this.isEmpty()) {
                this.rehash(cArray, lArray);
            }
        }
    }

    protected boolean equalElements(CharLongHashMap object) {
        if (((CharLongHashMap)object).size() != this.size()) {
            return false;
        }
        Iterator<CharLongCursor> iterator = ((CharLongHashMap)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            char c = ((CharLongCursor)object).key;
            if (this.containsKey(c) && this.get(c) == ((CharLongCursor)object).value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((CharLongHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends CharLongPredicate> T forEach(T t) {
        char[] cArray = this.keys;
        long[] lArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply('\u0000', lArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (cArray[i] == '\u0000' || t.apply(cArray[i], lArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends CharLongProcedure> T forEach(T t) {
        char[] cArray = this.keys;
        long[] lArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply('\u0000', lArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (cArray[n] != '\u0000') {
                t.apply(cArray[n], lArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public long get(char c) {
        int n;
        long l = 0L;
        if (c == '\u0000') {
            if (this.hasEmptyKey) {
                l = this.values[this.mask + 1];
            }
            return l;
        }
        char[] cArray = this.keys;
        int n2 = this.mask;
        int n3 = this.hashKey(c);
        while ((n3 = cArray[n = n3 & n2]) != 0) {
            if (n3 == c) {
                return this.values[n];
            }
            n3 = n + 1;
        }
        return 0L;
    }

    @Override
    public long getOrDefault(char c, long l) {
        int n;
        if (c == '\u0000') {
            if (this.hasEmptyKey) {
                l = this.values[this.mask + 1];
            }
            return l;
        }
        char[] cArray = this.keys;
        int n2 = this.mask;
        int n3 = this.hashKey(c);
        while ((n3 = cArray[n = n3 & n2]) != 0) {
            if (n3 == c) {
                return this.values[n];
            }
            n3 = n + 1;
        }
        return l;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (CharLongCursor charLongCursor : this) {
            n += BitMixer.mix(charLongCursor.key) + BitMixer.mix(charLongCursor.value);
        }
        return n;
    }

    protected int hashKey(char c) {
        return BitMixer.mix(c, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public long indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, char c, long l) {
        if (c == '\u0000') {
            this.values[n] = l;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, c, l);
            } else {
                this.keys[n] = c;
                this.values[n] = l;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(char c) {
        int n;
        int n2 = this.mask;
        if (c == '\u0000') {
            boolean bl = this.hasEmptyKey;
            int n3 = n2 + 1;
            if (!bl) {
                // empty if block
            }
            return n3;
        }
        char[] cArray = this.keys;
        int n4 = this.hashKey(c);
        while ((n4 = cArray[n = n4 & n2]) != 0) {
            if (n4 == c) {
                return n;
            }
            n4 = n + 1;
        }
        return n;
    }

    @Override
    public long indexReplace(int n, long l) {
        long[] lArray = this.values;
        long l2 = lArray[n];
        lArray[n] = l;
        return l2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<CharLongCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public long put(char c, long l) {
        char c2;
        int n = this.mask;
        if (c == '\u0000') {
            this.hasEmptyKey = true;
            long[] lArray = this.values;
            int n2 = n + 1;
            long l2 = lArray[n2];
            lArray[n2] = l;
            return l2;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(c);
        while ((c2 = objectArray[n3 &= n]) != '\u0000') {
            if (c2 == c) {
                objectArray = this.values;
                char c3 = objectArray[n3];
                objectArray[n3] = (char)l;
                return c3;
            }
            ++n3;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n3, c, l);
        } else {
            objectArray[n3] = c;
            this.values[n3] = l;
        }
        ++this.assigned;
        return 0L;
    }

    @Override
    public int putAll(CharLongAssociativeContainer object) {
        int n = this.size();
        Iterator<CharLongCursor> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((CharLongCursor)object).key, ((CharLongCursor)object).value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends CharLongCursor> object) {
        int n = this.size();
        Iterator<? extends CharLongCursor> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((CharLongCursor)object).key, ((CharLongCursor)object).value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(char c, long l) {
        int n = this.indexOf(c);
        if (!this.indexExists(n)) {
            this.indexInsert(n, c, l);
            return true;
        }
        return false;
    }

    @Override
    public long putOrAdd(char c, long l, long l2) {
        int n = this.indexOf(c);
        if (this.indexExists(n)) {
            l = this.values[n] + l2;
            this.indexReplace(n, l);
        } else {
            this.indexInsert(n, c, l);
        }
        return l;
    }

    protected void rehash(char[] cArray, long[] lArray) {
        int n;
        char[] cArray2 = this.keys;
        long[] lArray2 = this.values;
        int n2 = this.mask;
        int n3 = cArray.length - 1;
        cArray2[cArray2.length - 1] = cArray[n3];
        lArray2[lArray2.length - 1] = lArray[n3];
        while ((n = n3 - 1) >= 0) {
            char c = cArray[n];
            n3 = n;
            if (c == '\u0000') continue;
            n3 = this.hashKey(c);
            while (cArray2[n3 &= n2] != '\u0000') {
                ++n3;
            }
            cArray2[n3] = c;
            lArray2[n3] = lArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public long remove(char c) {
        int n;
        int n2 = this.mask;
        if (c == '\u0000') {
            this.hasEmptyKey = false;
            long[] lArray = this.values;
            int n3 = n2 + 1;
            long l = lArray[n3];
            lArray[n3] = 0L;
            return l;
        }
        char[] cArray = this.keys;
        int n4 = this.hashKey(c);
        while ((n4 = cArray[n = n4 & n2]) != 0) {
            if (n4 == c) {
                long l = this.values[n];
                this.shiftConflictingKeys(n);
                return l;
            }
            n4 = n + 1;
        }
        return 0L;
    }

    @Override
    public int removeAll(CharContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof CharLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains('\u0000')) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0L;
            }
            char[] cArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                char c = cArray[n2];
                if (c != '\u0000' && object.contains(c)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((CharCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(CharLongPredicate charLongPredicate) {
        int n;
        Object[] objectArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && charLongPredicate.apply('\u0000', (objectArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = 0L;
        }
        objectArray = this.keys;
        long[] lArray = this.values;
        while (n4 <= n3) {
            long l = objectArray[n4];
            if (l != false && charLongPredicate.apply((char)l, lArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(CharPredicate charPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && charPredicate.apply('\u0000')) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0L;
        }
        char[] cArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            char c = cArray[n2];
            if (c != '\u0000' && charPredicate.apply(c)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        char[] cArray = this.keys;
        long[] lArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            char c;
            int n4;
            int n5 = 0;
            do {
                if ((c = cArray[n4 = n + (n3 = n5 + 1) & n2]) == '\u0000') {
                    cArray[n] = (char)0;
                    lArray[n] = 0L;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(c) & n2) < n3);
            cArray[n] = c;
            lArray[n] = lArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<CharLongCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            CharLongCursor charLongCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(charLongCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(charLongCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public LongCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return CharBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<CharLongCursor> {
        private final CharLongCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = CharLongHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharLongCursor();
        }

        @Override
        protected CharLongCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharLongHashMap.this.keys;
                    n = this.slot;
                    char c = cArray[n];
                    if (c != '\u0000') {
                        this.cursor.index = n;
                        this.cursor.key = c;
                        this.cursor.value = CharLongHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && CharLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = (char)0;
                this.cursor.value = CharLongHashMap.this.values[this.max];
                return this.cursor;
            }
            return (CharLongCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final CharLongHashMap owner;

        public KeysContainer() {
            this.owner = CharLongHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(char c) {
            return this.owner.containsKey(c);
        }

        @Override
        public <T extends CharPredicate> T forEach(final T t) {
            this.owner.forEach(new CharLongPredicate(){

                @Override
                public boolean apply(char c, long l) {
                    return t.apply(c);
                }
            });
            return t;
        }

        @Override
        public <T extends CharProcedure> T forEach(final T t) {
            this.owner.forEach(new CharLongProcedure(){

                @Override
                public void apply(char c, long l) {
                    t.apply(c);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(char c) {
            if (this.owner.containsKey(c)) {
                this.owner.remove(c);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(CharPredicate charPredicate) {
            return this.owner.removeAll(charPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = CharLongHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharCursor();
        }

        @Override
        protected CharCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharLongHashMap.this.keys;
                    n = this.slot;
                    char c = cArray[n];
                    if (c != '\u0000') {
                        this.cursor.index = n;
                        this.cursor.value = c;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && CharLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = (char)0;
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractLongCollection {
        private final CharLongHashMap owner;

        private ValuesContainer() {
            this.owner = CharLongHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(long l) {
            Iterator<CharLongCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != l) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends LongPredicate> T forEach(T t) {
            Iterator<CharLongCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends LongProcedure> T forEach(T t) {
            Iterator<CharLongCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final long l) {
            return this.owner.removeAll(new CharLongPredicate(){

                @Override
                public boolean apply(char c, long l2) {
                    boolean bl = l2 == l;
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final LongPredicate longPredicate) {
            return this.owner.removeAll(new CharLongPredicate(){

                @Override
                public boolean apply(char c, long l) {
                    return longPredicate.apply(l);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = CharLongHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongCursor();
        }

        @Override
        protected LongCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharLongHashMap.this.keys;
                    n = this.slot;
                    if (cArray[n] != '\u0000') {
                        this.cursor.index = n;
                        this.cursor.value = CharLongHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && CharLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = CharLongHashMap.this.values[this.max];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }
}

