/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.CharBufferVisualizer;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.CharObjectAssociativeContainer;
import com.carrotsearch.hppc.CharObjectMap;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.ObjectCollection;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.CharObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.predicates.CharObjectPredicate;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.CharObjectProcedure;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public class CharObjectHashMap<VType>
implements CharObjectMap<VType>,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public char[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public Object[] values;

    public CharObjectHashMap() {
        this(4);
    }

    public CharObjectHashMap(int n) {
        this(n, 0.75);
    }

    public CharObjectHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public CharObjectHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public CharObjectHashMap(CharObjectAssociativeContainer<? extends VType> charObjectAssociativeContainer) {
        this(charObjectAssociativeContainer.size());
        this.putAll(charObjectAssociativeContainer);
    }

    public static <VType> CharObjectHashMap<VType> from(char[] cArray, VType[] VTypeArray) {
        if (cArray.length == VTypeArray.length) {
            CharObjectHashMap<VType> charObjectHashMap = new CharObjectHashMap<VType>(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                charObjectHashMap.put(cArray[i], VTypeArray[i]);
            }
            return charObjectHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        char[] cArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new char[n3];
            this.values = new Object[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = cArray;
            this.values = objectArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, char c, VType VType) {
        char[] cArray = this.keys;
        Object[] objectArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        cArray[n] = c;
        objectArray[n] = VType;
        this.rehash(cArray, objectArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, '\u0000');
        Arrays.fill(this.values, null);
    }

    public CharObjectHashMap<VType> clone() {
        try {
            CharObjectHashMap charObjectHashMap = (CharObjectHashMap)super.clone();
            charObjectHashMap.keys = (char[])this.keys.clone();
            charObjectHashMap.values = (Object[])this.values.clone();
            charObjectHashMap.hasEmptyKey = charObjectHashMap.hasEmptyKey;
            charObjectHashMap.orderMixer = this.orderMixer.clone();
            return charObjectHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(char c) {
        char c2;
        if (c == '\u0000') {
            return this.hasEmptyKey;
        }
        char[] cArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(c);
        while ((c2 = cArray[n2 &= n]) != '\u0000') {
            if (c2 == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            char[] cArray = this.keys;
            Object[] objectArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (cArray != null && !this.isEmpty()) {
                this.rehash(cArray, objectArray);
            }
        }
    }

    protected boolean equalElements(CharObjectHashMap<?> object) {
        if (((CharObjectHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((CharObjectHashMap)object).iterator();
        while (object.hasNext()) {
            CharObjectCursor charObjectCursor = (CharObjectCursor)object.next();
            char c = charObjectCursor.key;
            if (this.containsKey(c) && Objects.equals(this.get(c), charObjectCursor.value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((CharObjectHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends CharObjectPredicate<? super VType>> T forEach(T t) {
        char[] cArray = this.keys;
        Object[] objectArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply('\u0000', (Object)objectArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (cArray[i] == '\u0000' || t.apply(cArray[i], (Object)objectArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends CharObjectProcedure<? super VType>> T forEach(T t) {
        char[] cArray = this.keys;
        Object[] objectArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply('\u0000', (Object)objectArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (cArray[n] != '\u0000') {
                t.apply(cArray[n], (Object)objectArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public VType get(char c) {
        int n;
        Object object = null;
        if (c == '\u0000') {
            if (this.hasEmptyKey) {
                object = this.values[this.mask + 1];
            }
            return (VType)object;
        }
        object = this.keys;
        int n2 = this.mask;
        int n3 = this.hashKey(c);
        while ((n3 = object[n = n3 & n2]) != 0) {
            if (n3 == c) {
                return (VType)this.values[n];
            }
            n3 = n + 1;
        }
        return null;
    }

    @Override
    public VType getOrDefault(char c, VType object) {
        char c2;
        if (c == '\u0000') {
            if (this.hasEmptyKey) {
                object = this.values[this.mask + 1];
            }
            return object;
        }
        char[] cArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(c);
        while ((c2 = cArray[n2 &= n]) != '\u0000') {
            if (c2 == c) {
                return (VType)this.values[n2];
            }
            ++n2;
        }
        return object;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (CharObjectCursor<VType> charObjectCursor : this) {
            n += BitMixer.mix(charObjectCursor.key) + BitMixer.mix(charObjectCursor.value);
        }
        return n;
    }

    protected int hashKey(char c) {
        return BitMixer.mix(c, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public VType indexGet(int n) {
        return (VType)this.values[n];
    }

    @Override
    public void indexInsert(int n, char c, VType VType) {
        if (c == '\u0000') {
            this.values[n] = VType;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, c, VType);
            } else {
                this.keys[n] = c;
                this.values[n] = VType;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(char c) {
        char c2;
        int n = this.mask;
        if (c == '\u0000') {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        char[] cArray = this.keys;
        int n3 = this.hashKey(c);
        while ((c2 = cArray[n3 &= n]) != '\u0000') {
            if (c2 == c) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public VType indexReplace(int n, VType VType) {
        Object[] objectArray = this.values;
        Object object = objectArray[n];
        objectArray[n] = VType;
        return (VType)object;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<CharObjectCursor<VType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public VType put(char c, VType VType) {
        int n;
        int n2 = this.mask;
        if (c == '\u0000') {
            this.hasEmptyKey = true;
            Object[] objectArray = this.values;
            int n3 = n2 + 1;
            Object object = objectArray[n3];
            objectArray[n3] = VType;
            return (VType)object;
        }
        Object[] objectArray = this.keys;
        int n4 = this.hashKey(c);
        while ((n4 = objectArray[n = n4 & n2]) != 0) {
            if (n4 == c) {
                objectArray = this.values;
                char c2 = objectArray[n];
                objectArray[n] = (char)VType;
                return c2;
            }
            n4 = n + 1;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n, c, VType);
        } else {
            objectArray[n] = c;
            this.values[n] = VType;
        }
        ++this.assigned;
        return null;
    }

    @Override
    public int putAll(CharObjectAssociativeContainer<? extends VType> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            CharObjectCursor charObjectCursor = (CharObjectCursor)object.next();
            this.put(charObjectCursor.key, charObjectCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends CharObjectCursor<? extends VType>> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            CharObjectCursor charObjectCursor = (CharObjectCursor)object.next();
            this.put(charObjectCursor.key, charObjectCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(char c, VType VType) {
        int n = this.indexOf(c);
        if (!this.indexExists(n)) {
            this.indexInsert(n, c, VType);
            return true;
        }
        return false;
    }

    protected void rehash(char[] cArray, VType[] VTypeArray) {
        int n;
        char[] cArray2 = this.keys;
        Object[] objectArray = this.values;
        int n2 = this.mask;
        int n3 = cArray.length - 1;
        cArray2[cArray2.length - 1] = cArray[n3];
        objectArray[objectArray.length - 1] = VTypeArray[n3];
        while ((n = n3 - 1) >= 0) {
            char c = cArray[n];
            n3 = n;
            if (c == '\u0000') continue;
            n3 = this.hashKey(c);
            while (cArray2[n3 &= n2] != '\u0000') {
                ++n3;
            }
            cArray2[n3] = c;
            objectArray[n3] = VTypeArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public VType remove(char c) {
        int n;
        int n2 = this.mask;
        if (c == '\u0000') {
            this.hasEmptyKey = false;
            Object[] objectArray = this.values;
            int n3 = n2 + 1;
            Object object = objectArray[n3];
            objectArray[n3] = null;
            return (VType)object;
        }
        Object object = this.keys;
        int n4 = this.hashKey(c);
        while ((n4 = object[n = n4 & n2]) != 0) {
            if (n4 == c) {
                object = this.values[n];
                this.shiftConflictingKeys(n);
                return (VType)object;
            }
            n4 = n + 1;
        }
        return null;
    }

    @Override
    public int removeAll(CharContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof CharLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains('\u0000')) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = null;
            }
            char[] cArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                char c = cArray[n2];
                if (c != '\u0000' && object.contains(c)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((CharCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(CharObjectPredicate<? super VType> charObjectPredicate) {
        int n;
        Object[] objectArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && charObjectPredicate.apply('\u0000', (objectArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = null;
        }
        objectArray = this.keys;
        Object[] objectArray2 = this.values;
        while (n4 <= n3) {
            Object object = objectArray[n4];
            if (object != false && charObjectPredicate.apply((char)object, objectArray2[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(CharPredicate charPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && charPredicate.apply('\u0000')) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = null;
        }
        char[] cArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            char c = cArray[n2];
            if (c != '\u0000' && charPredicate.apply(c)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        char[] cArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            char c;
            int n4;
            int n5 = 0;
            do {
                if ((c = cArray[n4 = n + (n3 = n5 + 1) & n2]) == '\u0000') {
                    cArray[n] = (char)0;
                    objectArray[n] = null;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(c) & n2) < n3);
            cArray[n] = c;
            objectArray[n] = objectArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<CharObjectCursor<VType>> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            CharObjectCursor<VType> charObjectCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(charObjectCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(charObjectCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public ObjectCollection<VType> values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return CharBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<CharObjectCursor<VType>> {
        private final CharObjectCursor<VType> cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = CharObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharObjectCursor();
        }

        @Override
        protected CharObjectCursor<VType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharObjectHashMap.this.keys;
                    int n2 = this.slot;
                    n = cArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.key = (char)n;
                        this.cursor.value = CharObjectHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && CharObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = (char)0;
                this.cursor.value = CharObjectHashMap.this.values[this.max];
                return this.cursor;
            }
            return (CharObjectCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final CharObjectHashMap<VType> owner;

        public KeysContainer() {
            this.owner = CharObjectHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(char c) {
            return this.owner.containsKey(c);
        }

        @Override
        public <T extends CharPredicate> T forEach(final T t) {
            this.owner.forEach(new CharObjectPredicate<VType>(){

                @Override
                public boolean apply(char c, VType VType) {
                    return t.apply(c);
                }
            });
            return t;
        }

        @Override
        public <T extends CharProcedure> T forEach(final T t) {
            this.owner.forEach(new CharObjectProcedure<VType>(){

                @Override
                public void apply(char c, VType VType) {
                    t.apply(c);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(char c) {
            if (this.owner.containsKey(c)) {
                this.owner.remove(c);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(CharPredicate charPredicate) {
            return this.owner.removeAll(charPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = CharObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharCursor();
        }

        @Override
        protected CharCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharObjectHashMap.this.keys;
                    n = this.slot;
                    char c = cArray[n];
                    if (c != '\u0000') {
                        this.cursor.index = n;
                        this.cursor.value = c;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && CharObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = (char)0;
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractObjectCollection<VType> {
        private final CharObjectHashMap<VType> owner;

        private ValuesContainer() {
            this.owner = CharObjectHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(VType VType) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (!Objects.equals(iterator.next().value, VType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ObjectPredicate<? super VType>> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends ObjectProcedure<? super VType>> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final ObjectPredicate<? super VType> objectPredicate) {
            return this.owner.removeAll(new CharObjectPredicate<VType>(){

                @Override
                public boolean apply(char c, VType VType) {
                    return objectPredicate.apply(VType);
                }
            });
        }

        @Override
        public int removeAll(final VType VType) {
            return this.owner.removeAll(new CharObjectPredicate<VType>(){

                @Override
                public boolean apply(char c, VType VType2) {
                    return Objects.equals(VType2, VType);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        private final ObjectCursor<VType> cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = CharObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCursor();
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharObjectHashMap.this.keys;
                    n = this.slot;
                    if (cArray[n] != '\u0000') {
                        this.cursor.index = n;
                        this.cursor.value = CharObjectHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && CharObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = CharObjectHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

