/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.CharBufferVisualizer;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.CharShortAssociativeContainer;
import com.carrotsearch.hppc.CharShortMap;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.ShortCollection;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.CharShortCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.CharShortPredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.CharShortProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class CharShortHashMap
implements CharShortMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public char[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public short[] values;

    public CharShortHashMap() {
        this(4);
    }

    public CharShortHashMap(int n) {
        this(n, 0.75);
    }

    public CharShortHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public CharShortHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public CharShortHashMap(CharShortAssociativeContainer charShortAssociativeContainer) {
        this(charShortAssociativeContainer.size());
        this.putAll(charShortAssociativeContainer);
    }

    public static CharShortHashMap from(char[] cArray, short[] sArray) {
        if (cArray.length == sArray.length) {
            CharShortHashMap charShortHashMap = new CharShortHashMap(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                charShortHashMap.put(cArray[i], sArray[i]);
            }
            return charShortHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public short addTo(char c, short s) {
        return this.putOrAdd(c, s, s);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        char[] cArray = this.keys;
        short[] sArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new char[n3];
            this.values = new short[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = cArray;
            this.values = sArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, char c, short s) {
        char[] cArray = this.keys;
        short[] sArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        cArray[n] = c;
        sArray[n] = s;
        this.rehash(cArray, sArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, '\u0000');
    }

    public CharShortHashMap clone() {
        try {
            CharShortHashMap charShortHashMap = (CharShortHashMap)super.clone();
            charShortHashMap.keys = (char[])this.keys.clone();
            charShortHashMap.values = (short[])this.values.clone();
            charShortHashMap.hasEmptyKey = charShortHashMap.hasEmptyKey;
            charShortHashMap.orderMixer = this.orderMixer.clone();
            return charShortHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(char c) {
        char c2;
        if (c == '\u0000') {
            return this.hasEmptyKey;
        }
        char[] cArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(c);
        while ((c2 = cArray[n2 &= n]) != '\u0000') {
            if (c2 == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            char[] cArray = this.keys;
            short[] sArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (cArray != null && !this.isEmpty()) {
                this.rehash(cArray, sArray);
            }
        }
    }

    protected boolean equalElements(CharShortHashMap object) {
        if (((CharShortHashMap)object).size() != this.size()) {
            return false;
        }
        Iterator<CharShortCursor> iterator = ((CharShortHashMap)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            char c = ((CharShortCursor)object).key;
            if (this.containsKey(c) && this.get(c) == ((CharShortCursor)object).value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((CharShortHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends CharShortPredicate> T forEach(T t) {
        char[] cArray = this.keys;
        short[] sArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply('\u0000', sArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (cArray[i] == '\u0000' || t.apply(cArray[i], sArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends CharShortProcedure> T forEach(T t) {
        char[] cArray = this.keys;
        short[] sArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply('\u0000', sArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (cArray[n] != '\u0000') {
                t.apply(cArray[n], sArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public short get(char c) {
        char c2;
        int n = 0;
        if (c == '\u0000') {
            int n2 = n;
            if (this.hasEmptyKey) {
                n2 = n = this.values[this.mask + 1];
            }
            return (short)n2;
        }
        char[] cArray = this.keys;
        int n3 = this.mask;
        n = this.hashKey(c);
        while ((c2 = cArray[n &= n3]) != '\u0000') {
            if (c2 == c) {
                return this.values[n];
            }
            ++n;
        }
        return 0;
    }

    @Override
    public short getOrDefault(char c, short s) {
        int n;
        if (c == '\u0000') {
            if (this.hasEmptyKey) {
                short s2;
                s = s2 = this.values[this.mask + 1];
            }
            return s;
        }
        char[] cArray = this.keys;
        int n2 = this.mask;
        int n3 = this.hashKey(c);
        while ((n3 = cArray[n = n3 & n2]) != 0) {
            if (n3 == c) {
                return this.values[n];
            }
            n3 = n + 1;
        }
        return s;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (CharShortCursor charShortCursor : this) {
            n += BitMixer.mix(charShortCursor.key) + BitMixer.mix(charShortCursor.value);
        }
        return n;
    }

    protected int hashKey(char c) {
        return BitMixer.mix(c, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public short indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, char c, short s) {
        if (c == '\u0000') {
            this.values[n] = s;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, c, s);
            } else {
                this.keys[n] = c;
                this.values[n] = s;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(char c) {
        int n;
        int n2 = this.mask;
        if (c == '\u0000') {
            boolean bl = this.hasEmptyKey;
            int n3 = n2 + 1;
            if (!bl) {
                // empty if block
            }
            return n3;
        }
        char[] cArray = this.keys;
        int n4 = this.hashKey(c);
        while ((n4 = cArray[n = n4 & n2]) != 0) {
            if (n4 == c) {
                return n;
            }
            n4 = n + 1;
        }
        return n;
    }

    @Override
    public short indexReplace(int n, short s) {
        short[] sArray = this.values;
        short s2 = sArray[n];
        sArray[n] = s;
        return s2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<CharShortCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public short put(char c, short s) {
        char c2;
        int n = this.mask;
        if (c == '\u0000') {
            this.hasEmptyKey = true;
            short[] sArray = this.values;
            int n2 = n + 1;
            short s2 = sArray[n2];
            sArray[n2] = s;
            return s2;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(c);
        while ((c2 = objectArray[n3 &= n]) != '\u0000') {
            if (c2 == c) {
                objectArray = this.values;
                char c3 = objectArray[n3];
                objectArray[n3] = s;
                return (short)c3;
            }
            ++n3;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n3, c, s);
        } else {
            objectArray[n3] = c;
            this.values[n3] = s;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(CharShortAssociativeContainer object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            CharShortCursor charShortCursor = (CharShortCursor)object.next();
            this.put(charShortCursor.key, charShortCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends CharShortCursor> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            CharShortCursor charShortCursor = (CharShortCursor)object.next();
            this.put(charShortCursor.key, charShortCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(char c, short s) {
        int n = this.indexOf(c);
        if (!this.indexExists(n)) {
            this.indexInsert(n, c, s);
            return true;
        }
        return false;
    }

    @Override
    public short putOrAdd(char c, short s, short s2) {
        int n = this.indexOf(c);
        if (this.indexExists(n)) {
            s = (short)(this.values[n] + s2);
            this.indexReplace(n, s);
        } else {
            this.indexInsert(n, c, s);
        }
        return s;
    }

    protected void rehash(char[] cArray, short[] sArray) {
        int n;
        char[] cArray2 = this.keys;
        short[] sArray2 = this.values;
        int n2 = this.mask;
        int n3 = cArray.length - 1;
        cArray2[cArray2.length - 1] = cArray[n3];
        sArray2[sArray2.length - 1] = sArray[n3];
        while ((n = n3 - 1) >= 0) {
            char c = cArray[n];
            n3 = n;
            if (c == '\u0000') continue;
            n3 = this.hashKey(c);
            while (cArray2[n3 &= n2] != '\u0000') {
                ++n3;
            }
            cArray2[n3] = c;
            sArray2[n3] = sArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public short remove(char c) {
        char c2;
        int n = this.mask;
        if (c == '\u0000') {
            this.hasEmptyKey = false;
            short[] sArray = this.values;
            int n2 = n + 1;
            short s = sArray[n2];
            sArray[n2] = (short)0;
            return s;
        }
        char[] cArray = this.keys;
        int n3 = this.hashKey(c);
        while ((c2 = cArray[n3 &= n]) != '\u0000') {
            if (c2 == c) {
                short s = this.values[n3];
                this.shiftConflictingKeys(n3);
                return s;
            }
            ++n3;
        }
        return 0;
    }

    @Override
    public int removeAll(CharContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof CharLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains('\u0000')) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = (short)0;
            }
            char[] cArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                char c = cArray[n2];
                if (c != '\u0000' && object.contains(c)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((CharCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(CharPredicate charPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && charPredicate.apply('\u0000')) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = (short)0;
        }
        char[] cArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            char c = cArray[n2];
            if (c != '\u0000' && charPredicate.apply(c)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    @Override
    public int removeAll(CharShortPredicate charShortPredicate) {
        int n;
        short[] sArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && charShortPredicate.apply('\u0000', (sArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = (short)0;
        }
        char[] cArray = this.keys;
        sArray = this.values;
        while (n4 <= n3) {
            char c = cArray[n4];
            if (c != '\u0000' && charShortPredicate.apply(c, sArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        char[] cArray = this.keys;
        short[] sArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            char c;
            int n4;
            int n5 = 0;
            do {
                if ((c = cArray[n4 = n + (n3 = n5 + 1) & n2]) == '\u0000') {
                    cArray[n] = (char)0;
                    sArray[n] = (short)0;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(c) & n2) < n3);
            cArray[n] = c;
            sArray[n] = sArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<CharShortCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            CharShortCursor charShortCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(charShortCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(charShortCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public ShortCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return CharBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<CharShortCursor> {
        private final CharShortCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = CharShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharShortCursor();
        }

        @Override
        protected CharShortCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharShortHashMap.this.keys;
                    n = this.slot;
                    char c = cArray[n];
                    if (c != '\u0000') {
                        this.cursor.index = n;
                        this.cursor.key = c;
                        this.cursor.value = CharShortHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && CharShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = (char)0;
                this.cursor.value = CharShortHashMap.this.values[this.max];
                return this.cursor;
            }
            return (CharShortCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final CharShortHashMap owner;

        public KeysContainer() {
            this.owner = CharShortHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(char c) {
            return this.owner.containsKey(c);
        }

        @Override
        public <T extends CharPredicate> T forEach(final T t) {
            this.owner.forEach(new CharShortPredicate(){

                @Override
                public boolean apply(char c, short s) {
                    return t.apply(c);
                }
            });
            return t;
        }

        @Override
        public <T extends CharProcedure> T forEach(final T t) {
            this.owner.forEach(new CharShortProcedure(){

                @Override
                public void apply(char c, short s) {
                    t.apply(c);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(char c) {
            if (this.owner.containsKey(c)) {
                this.owner.remove(c);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeAll(CharPredicate charPredicate) {
            return this.owner.removeAll(charPredicate);
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = CharShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharCursor();
        }

        @Override
        protected CharCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharShortHashMap.this.keys;
                    n = this.slot;
                    char c = cArray[n];
                    if (c != '\u0000') {
                        this.cursor.index = n;
                        this.cursor.value = c;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && CharShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = (char)0;
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractShortCollection {
        private final CharShortHashMap owner;

        private ValuesContainer() {
            this.owner = CharShortHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(short s) {
            Iterator<CharShortCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != s) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T t) {
            Iterator<CharShortCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends ShortProcedure> T forEach(T t) {
            Iterator<CharShortCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final ShortPredicate shortPredicate) {
            return this.owner.removeAll(new CharShortPredicate(){

                @Override
                public boolean apply(char c, short s) {
                    return shortPredicate.apply(s);
                }
            });
        }

        @Override
        public int removeAll(final short s) {
            return this.owner.removeAll(new CharShortPredicate(){

                @Override
                public boolean apply(char c, short s2) {
                    boolean bl = s2 == s;
                    return bl;
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = CharShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCursor();
        }

        @Override
        protected ShortCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    char[] cArray = CharShortHashMap.this.keys;
                    n = this.slot;
                    if (cArray[n] != '\u0000') {
                        this.cursor.index = n;
                        this.cursor.value = CharShortHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && CharShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = CharShortHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }
}

